/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.ImmutableMap;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GT_Single_Recipe_Check_Processing_Array
extends GT_Single_Recipe_Check {
    protected final int recipeAmperage;
    protected final ItemStack machineStack;

    protected GT_Single_Recipe_Check_Processing_Array(GT_MetaTileEntity_MultiBlockBase multiBlockBase, GT_Recipe recipe, ImmutableMap<GT_Utility.ItemId, Integer> itemCost, ImmutableMap<Fluid, Integer> fluidCost, int recipeAmperage, ItemStack machineStack) {
        super(multiBlockBase, recipe, itemCost, fluidCost);
        this.recipeAmperage = recipeAmperage;
        this.machineStack = machineStack;
    }

    public int getRecipeAmperage() {
        return this.recipeAmperage;
    }

    @Override
    public boolean checkRecipeInputsSingleStack(boolean consumeInputs) {
        throw new UnsupportedOperationException("Use checkRecipeInputs(boolean, int) instead.");
    }

    @Override
    public boolean checkRecipeInputs(boolean consumeInputs) {
        throw new UnsupportedOperationException("Use checkRecipeInputs(boolean, int) instead.");
    }

    public int checkRecipeInputs(boolean consumeInputs, int maxParallel) {
        if (!GT_Utility.areStacksEqual(this.machineStack, this.multiBlockBase.mInventory[1])) {
            return 0;
        }
        int parallel = maxParallel;
        ArrayList<ItemStack> items = null;
        if (this.totalItemCost > 0) {
            items = this.multiBlockBase.getStoredInputs();
            HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
            for (ItemStack itemStack : items) {
                itemMap.merge(GT_Utility.ItemId.createNoCopy(itemStack), itemStack.field_77994_a, Integer::sum);
            }
            for (Object entry2 : this.itemCost.entrySet()) {
                if ((parallel = Math.min(parallel, itemMap.getOrDefault(entry2.getKey(), 0) / (Integer)entry2.getValue())) > 0) continue;
                return 0;
            }
        }
        ArrayList<FluidStack> fluids = null;
        if (this.totalFluidCost > 0) {
            fluids = this.multiBlockBase.getStoredFluids();
            HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
            for (FluidStack fluidStack : fluids) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
            }
            for (Map.Entry entry3 : this.fluidCost.entrySet()) {
                if ((parallel = Math.min(parallel, fluidMap.getOrDefault(entry3.getKey(), 0) / (Integer)entry3.getValue())) > 0) continue;
                return 0;
            }
        }
        int finalParallel = parallel;
        if (consumeInputs) {
            int paid;
            int runningCost;
            GT_Utility.ItemId key;
            if (this.totalItemCost > 0) {
                int remainingItemCost = this.totalItemCost * finalParallel;
                Map<GT_Utility.ItemId, Integer> runningItemCost = this.itemCost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Integer)entry.getValue() * finalParallel));
                for (ItemStack itemStack : items) {
                    key = GT_Utility.ItemId.createNoCopy(itemStack);
                    runningCost = runningItemCost.getOrDefault(key, 0);
                    paid = Math.min(itemStack.field_77994_a, runningCost);
                    itemStack.field_77994_a -= paid;
                    runningItemCost.put(key, runningCost - paid);
                    if ((remainingItemCost -= paid) > 0) continue;
                    break;
                }
            }
            if (this.totalFluidCost > 0) {
                int remainingFluidCost = this.totalFluidCost * finalParallel;
                Map<Fluid, Integer> runningFluidCost = this.fluidCost.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Integer)entry.getValue() * finalParallel));
                for (FluidStack fluidStack : fluids) {
                    key = fluidStack.getFluid();
                    runningCost = runningFluidCost.getOrDefault(key, 0);
                    paid = Math.min(fluidStack.amount, runningCost);
                    fluidStack.amount -= paid;
                    runningFluidCost.put((Fluid)key, runningCost - paid);
                    if ((remainingFluidCost -= paid) > 0) continue;
                    break;
                }
            }
        }
        return finalParallel;
    }

    @Nullable
    public static GT_Single_Recipe_Check tryLoad(GT_MetaTileEntity_MultiBlockBase parent, GT_Recipe.GT_Recipe_Map recipeMap, NBTTagCompound tag, ItemStack machineStack) {
        if (recipeMap == null || machineStack == null) {
            return null;
        }
        GT_Recipe found = GT_Single_Recipe_Check_Processing_Array.tryFindRecipe(parent, recipeMap, tag);
        if (found == null) {
            return null;
        }
        return new GT_Single_Recipe_Check_Processing_Array(parent, found, GT_Single_Recipe_Check_Processing_Array.loadItemCost(tag), GT_Single_Recipe_Check_Processing_Array.loadFluidCost(tag), recipeMap.mAmperage, machineStack.func_77946_l());
    }

    public static Builder processingArrayBuilder(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        return new Builder(multiBlockBase);
    }

    public static final class Builder {
        private final GT_MetaTileEntity_MultiBlockBase multiBlockBase;
        private Map<GT_Utility.ItemId, Integer> beforeItems;
        private Map<Fluid, Integer> beforeFluids;
        private Map<GT_Utility.ItemId, Integer> afterItems;
        private Map<Fluid, Integer> afterFluids;
        private GT_Recipe recipe;
        private int recipeAmperage;

        private Builder(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
            this.multiBlockBase = multiBlockBase;
        }

        public Builder setBefore(ItemStack[] inputs, FluidStack[] fluids) {
            this.beforeItems = Builder.buildItemMapDirect(inputs);
            this.beforeFluids = Builder.buildFluidMapDirect(fluids);
            return this;
        }

        static Map<GT_Utility.ItemId, Integer> buildItemMapDirect(ItemStack[] inputs) {
            HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
            for (ItemStack itemStack : inputs) {
                itemMap.merge(GT_Utility.ItemId.create(itemStack), itemStack.field_77994_a, Integer::sum);
            }
            return itemMap;
        }

        static Map<Fluid, Integer> buildFluidMapDirect(FluidStack[] fluids) {
            HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
            for (FluidStack fluidStack : fluids) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
            }
            return fluidMap;
        }

        public Builder setAfter(ItemStack[] inputs, FluidStack[] fluids) {
            this.afterItems = Builder.buildItemMapDirect(inputs);
            this.afterFluids = Builder.buildFluidMapDirect(fluids);
            return this;
        }

        public Builder setRecipe(GT_Recipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public Builder setRecipeAmperage(int recipeAmperage) {
            this.recipeAmperage = recipeAmperage;
            return this;
        }

        public GT_Single_Recipe_Check_Processing_Array build() {
            ImmutableMap.Builder itemCostBuilder = ImmutableMap.builder();
            for (Map.Entry<GT_Utility.ItemId, Integer> entry : this.beforeItems.entrySet()) {
                int cost = entry.getValue() - this.afterItems.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                itemCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            ImmutableMap.Builder fluidCostBuilder = ImmutableMap.builder();
            for (Map.Entry<Fluid, Integer> entry : this.beforeFluids.entrySet()) {
                int cost = entry.getValue() - this.afterFluids.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                fluidCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            return new GT_Single_Recipe_Check_Processing_Array(this.multiBlockBase, this.recipe, (ImmutableMap<GT_Utility.ItemId, Integer>)itemCostBuilder.build(), (ImmutableMap<Fluid, Integer>)fluidCostBuilder.build(), this.recipeAmperage, this.multiBlockBase.mInventory[1].func_77946_l());
        }
    }
}

