/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.VoidProtectionHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_ParallelHelper {
    private IVoidable machine;
    private GT_Recipe mRecipe;
    private long mAvailableEUt;
    private int mCurrentParallel = 0;
    private int mMaxParallel = 1;
    private int mBatchModifier = 1;
    private ItemStack[] mItemInputs;
    private ItemStack[] mItemOutputs;
    private FluidStack[] mFluidInputs;
    private FluidStack[] mFluidOutputs;
    private boolean protectExcessItem;
    private boolean protectExcessFluid;
    private boolean mConsume;
    private boolean mBatchMode;
    private boolean mCalculateOutputs;
    private boolean mBuilt;
    private float mDurationMultiplier;
    private float mEUtModifier = 1.0f;

    @Deprecated
    public GT_ParallelHelper setController(GT_MetaTileEntity_MultiBlockBase machineMeta) {
        return this.setMachine(machineMeta, machineMeta.protectsExcessItem(), machineMeta.protectsExcessFluid());
    }

    @Deprecated
    public GT_ParallelHelper setController(GT_MetaTileEntity_MultiBlockBase machineMeta, boolean protectExcessItem, boolean protectExcessFluid) {
        return this.setMachine(machineMeta, protectExcessItem, protectExcessFluid);
    }

    public GT_ParallelHelper setMachine(IVoidable machine) {
        return this.setMachine(machine, machine.protectsExcessItem(), machine.protectsExcessFluid());
    }

    public GT_ParallelHelper setMachine(IVoidable machine, boolean protectExcessItem, boolean protectExcessFluid) {
        this.protectExcessItem = protectExcessItem;
        this.protectExcessFluid = protectExcessFluid;
        this.machine = machine;
        return this;
    }

    public GT_ParallelHelper setRecipe(GT_Recipe aRecipe) {
        this.mRecipe = aRecipe;
        return this;
    }

    public GT_ParallelHelper setItemInputs(ItemStack ... aItemInputs) {
        this.mItemInputs = aItemInputs;
        return this;
    }

    public GT_ParallelHelper setFluidInputs(FluidStack ... aFluidInputs) {
        this.mFluidInputs = aFluidInputs;
        return this;
    }

    public GT_ParallelHelper setAvailableEUt(long aAvailableEUt) {
        this.mAvailableEUt = aAvailableEUt;
        return this;
    }

    public GT_ParallelHelper setEUtModifier(float aEUtModifier) {
        this.mEUtModifier = aEUtModifier;
        return this;
    }

    public GT_ParallelHelper enableConsumption() {
        this.mConsume = true;
        return this;
    }

    public GT_ParallelHelper setMaxParallel(int aMaxParallel) {
        this.mMaxParallel = aMaxParallel;
        return this;
    }

    public GT_ParallelHelper enableBatchMode(int aBatchModifier) {
        this.mBatchMode = true;
        this.mBatchModifier = aBatchModifier;
        return this;
    }

    public GT_ParallelHelper enableOutputCalculation() {
        this.mCalculateOutputs = true;
        return this;
    }

    public GT_ParallelHelper build() {
        if (this.mBuilt) {
            throw new IllegalStateException("Tried to build twice");
        }
        this.mBuilt = true;
        this.determineParallel();
        return this;
    }

    public int getCurrentParallel() {
        if (!this.mBuilt) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.mCurrentParallel;
    }

    public float getDurationMultiplier() {
        if (!this.mBuilt) {
            throw new IllegalStateException("Tried to get duration multiplier before building");
        }
        if (this.mBatchMode) {
            return this.mDurationMultiplier;
        }
        return 1.0f;
    }

    public ItemStack[] getItemOutputs() {
        if (!this.mBuilt || !this.mCalculateOutputs) {
            throw new IllegalStateException("Tried to get item outputs before building or without enabling calculation of outputs");
        }
        return this.mItemOutputs;
    }

    public FluidStack[] getFluidOutputs() {
        if (!this.mBuilt || !this.mCalculateOutputs) {
            throw new IllegalStateException("Tried to get fluid outputs before building or without enabling calculation of outputs");
        }
        return this.mFluidOutputs;
    }

    protected void determineParallel() {
        if ((long)this.mRecipe.mEUt > this.mAvailableEUt) {
            return;
        }
        ItemStack[] tItemInputs = null;
        FluidStack[] tFluidInputs = null;
        long tCurrentUsage = 0L;
        if (this.mConsume) {
            tItemInputs = this.mItemInputs;
            tFluidInputs = this.mFluidInputs;
        } else {
            int i;
            if (this.mItemInputs == null) {
                tItemInputs = new ItemStack[]{};
            } else {
                tItemInputs = new ItemStack[this.mItemInputs.length];
                for (i = 0; i < this.mItemInputs.length; ++i) {
                    tItemInputs[i] = this.mItemInputs[i].func_77946_l();
                }
            }
            if (this.mFluidInputs == null) {
                this.mFluidInputs = new FluidStack[0];
            } else {
                tFluidInputs = new FluidStack[this.mFluidInputs.length];
                for (i = 0; i < this.mFluidInputs.length; ++i) {
                    tFluidInputs[i] = this.mFluidInputs[i].copy();
                }
            }
        }
        if (this.mBatchMode) {
            this.mMaxParallel *= this.mBatchModifier;
        }
        if (this.protectExcessItem || this.protectExcessFluid) {
            if (this.machine == null) {
                throw new IllegalStateException("Tried to calculate void protection, but machine is not set");
            }
            VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper();
            voidProtectionHelper.setMachine(this.machine).setItemOutputs(this.mRecipe.mOutputs).setFluidOutputs(this.mRecipe.mFluidOutputs).setMaxParallel(this.mMaxParallel).build();
            this.mMaxParallel = Math.min(voidProtectionHelper.getMaxParallel(), this.mMaxParallel);
        }
        float tRecipeEUt = (float)this.mRecipe.mEUt * this.mEUtModifier;
        while (this.mCurrentParallel < this.mMaxParallel / this.mBatchModifier && (float)tCurrentUsage < (float)this.mAvailableEUt - tRecipeEUt && this.mRecipe.isRecipeInputEqual(true, false, tFluidInputs, tItemInputs)) {
            tCurrentUsage = (long)((float)tCurrentUsage + tRecipeEUt);
            ++this.mCurrentParallel;
        }
        if (this.mBatchMode) {
            int tExtraParallels;
            for (tExtraParallels = 0; tExtraParallels < this.mCurrentParallel * (this.mBatchModifier - 1) && this.mRecipe.isRecipeInputEqual(false, false, tFluidInputs, tItemInputs); ++tExtraParallels) {
                this.mRecipe.isRecipeInputEqual(true, false, tFluidInputs, tItemInputs);
            }
            this.mDurationMultiplier = 1.0f + (float)tExtraParallels / (float)this.mCurrentParallel;
            this.mCurrentParallel += tExtraParallels;
        }
        if (this.mCalculateOutputs) {
            int i;
            if (this.mRecipe.mOutputs != null) {
                this.mItemOutputs = new ItemStack[this.mRecipe.mOutputs.length];
                for (i = 0; i < this.mRecipe.mOutputs.length; ++i) {
                    if (this.mRecipe.getOutputChance(i) < XSTR.XSTR_INSTANCE.nextInt(10000)) continue;
                    if (this.mRecipe.getOutput(i) == null) {
                        this.mItemOutputs[i] = null;
                        continue;
                    }
                    ItemStack tItem = this.mRecipe.getOutput(i).func_77946_l();
                    tItem.field_77994_a *= this.mCurrentParallel;
                    this.mItemOutputs[i] = tItem;
                }
            }
            if (this.mRecipe.mFluidOutputs != null) {
                this.mFluidOutputs = new FluidStack[this.mRecipe.mFluidOutputs.length];
                for (i = 0; i < this.mRecipe.mFluidOutputs.length; ++i) {
                    if (this.mRecipe.getFluidOutput(i) == null) {
                        this.mFluidOutputs[i] = null;
                        continue;
                    }
                    FluidStack tFluid = this.mRecipe.getFluidOutput(i).copy();
                    tFluid.amount *= this.mCurrentParallel;
                    this.mFluidOutputs[i] = tFluid;
                }
            }
        }
    }
}

