/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.net.GT_Packet_TileEntityCoverGUI;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Packet_GtTileEntityGuiRequest
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected int guiId;
    protected int dimId;
    protected int playerId;
    protected int parentGuiId;

    public GT_Packet_GtTileEntityGuiRequest() {
        super(true);
    }

    public GT_Packet_GtTileEntityGuiRequest(int mX, short mY, int mZ, int guiId, int dimID, int playerID, int parentGuiId) {
        super(false);
        this.mX = mX;
        this.mY = mY;
        this.mZ = mZ;
        this.guiId = guiId;
        this.dimId = dimID;
        this.playerId = playerID;
        this.parentGuiId = parentGuiId;
    }

    public GT_Packet_GtTileEntityGuiRequest(int mX, short mY, int mZ, int guiId, int dimID, int playerID) {
        this(mX, mY, mZ, guiId, dimID, playerID, -1);
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeInt(this.guiId);
        aOut.writeInt(this.dimId);
        aOut.writeInt(this.playerId);
        aOut.writeInt(this.parentGuiId);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new GT_Packet_GtTileEntityGuiRequest(aData.readInt(), aData.readShort(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public byte getPacketID() {
        return 15;
    }

    @Override
    public void process(IBlockAccess aWorld) {
        CoverableTileEntity coverableTile;
        BaseTileEntity baseTile;
        WorldServer world = DimensionManager.getWorld((int)this.dimId);
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(this.mX, (int)this.mY, this.mZ);
        if (!(tile instanceof BaseTileEntity) || (baseTile = (BaseTileEntity)tile).isDead()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)world.func_73045_a(this.playerId);
        CoverableTileEntity coverableTileEntity = coverableTile = baseTile instanceof CoverableTileEntity ? (CoverableTileEntity)baseTile : null;
        if (10 <= this.guiId && this.guiId < 16 && coverableTile != null) {
            ForgeDirection coverSide = ForgeDirection.getOrientation((int)((byte)(this.guiId - 10)));
            GT_Packet_TileEntityCoverGUI packet = new GT_Packet_TileEntityCoverGUI(this.mX, this.mY, this.mZ, coverSide, coverableTile.getCoverIDAtSide(coverSide), coverableTile.getComplexCoverDataAtSide(coverSide), this.dimId, this.playerId, this.parentGuiId);
            GT_Values.NW.sendToPlayer(packet, player);
        } else if (this.guiId == 0) {
            if (baseTile.useModularUI()) {
                GT_UIInfos.openGTTileEntityUI(baseTile, (EntityPlayer)player);
            } else {
                baseTile.openGUI((EntityPlayer)player);
            }
        }
    }
}

