/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.Tier;
import gregtech.api.gui.GT_Container_BasicMachine;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import ic2.core.Ic2Items;
import java.util.Locale;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_MetaTileEntity_BasicMachine_GT_Recipe
extends GT_MetaTileEntity_BasicMachine {
    private final GT_Recipe.GT_Recipe_Map mRecipes;
    private final int mTankCapacity;
    private final SpecialEffects mSpecialEffect;
    private final ResourceLocation mSoundResourceLocation;
    private final boolean mSharedTank;
    private final boolean mRequiresFluidForFiltering;
    private final byte mGUIParameterA;
    private final byte mGUIParameterB;
    private FallbackableUITexture progressBarTexture;

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aGUIParameterA, int aGUIParameterB, String aGUIName, ResourceLocation aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, SpecialEffects aSpecialEffect, String aOverlays, Object[] aRecipe) {
        super(aID, aName, aNameRegional, aTier, aRecipes.mAmperage, aDescription, aInputSlots, aOutputSlots, aGUIName, aRecipes.mNEIName, TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_GLOW")).glow().build()));
        this.mSharedTank = aSharedTank;
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = aSpecialEffect;
        this.mRequiresFluidForFiltering = aRequiresFluidForFiltering;
        this.mRecipes = aRecipes;
        this.mSoundResourceLocation = aSound;
        this.mGUIParameterA = (byte)aGUIParameterA;
        this.mGUIParameterB = (byte)aGUIParameterB;
        this.progressBarTexture = this.mRecipes.getProgressBarTextureRaw();
        if (aRecipe != null) {
            for (int i = 3; i < aRecipe.length; ++i) {
                Object object;
                if (!(aRecipe[i] instanceof X)) continue;
                block0 : switch ((X)((Object)aRecipe[i])) {
                    case CIRCUIT: {
                        object = Tier.ELECTRIC[this.mTier].mManagingObject;
                        break;
                    }
                    case BETTER_CIRCUIT: {
                        object = Tier.ELECTRIC[this.mTier].mBetterManagingObject;
                        break;
                    }
                    case HULL: {
                        object = Tier.ELECTRIC[this.mTier].mHullObject;
                        break;
                    }
                    case WIRE: {
                        object = Tier.ELECTRIC[this.mTier].mConductingObject;
                        break;
                    }
                    case WIRE4: {
                        object = Tier.ELECTRIC[this.mTier].mLargerConductingObject;
                        break;
                    }
                    case STICK_DISTILLATION: {
                        object = OrePrefixes.stick.get(Materials.Blaze);
                        break;
                    }
                    case GLASS: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                object = new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE);
                                break block0;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                if (Mods.BartWorks.isModLoaded()) {
                                    object = "blockGlass" + GT_Values.VN[aTier];
                                    break block0;
                                }
                                object = Ic2Items.reinforcedGlass;
                                break block0;
                            }
                        }
                        if (Mods.BartWorks.isModLoaded()) {
                            object = "blockGlass" + GT_Values.VN[8];
                            break;
                        }
                        object = Ic2Items.reinforcedGlass;
                        break;
                    }
                    case PLATE: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.plate.get(Materials.Steel);
                                break block0;
                            }
                            case 2: {
                                object = OrePrefixes.plate.get(Materials.Aluminium);
                                break block0;
                            }
                            case 3: {
                                object = OrePrefixes.plate.get(Materials.StainlessSteel);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.plate.get(Materials.Titanium);
                                break block0;
                            }
                            case 5: {
                                object = OrePrefixes.plate.get(Materials.TungstenSteel);
                                break block0;
                            }
                            case 6: {
                                object = OrePrefixes.plate.get(Materials.HSSG);
                                break block0;
                            }
                            case 7: {
                                object = OrePrefixes.plate.get(Materials.HSSE);
                                break block0;
                            }
                        }
                        object = OrePrefixes.plate.get(Materials.Neutronium);
                        break;
                    }
                    case PIPE: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.pipeMedium.get(Materials.Bronze);
                                break block0;
                            }
                            case 2: {
                                object = OrePrefixes.pipeMedium.get(Materials.Steel);
                                break block0;
                            }
                            case 3: {
                                object = OrePrefixes.pipeMedium.get(Materials.StainlessSteel);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.pipeMedium.get(Materials.Titanium);
                                break block0;
                            }
                            case 5: {
                                object = OrePrefixes.pipeMedium.get(Materials.TungstenSteel);
                                break block0;
                            }
                            case 6: {
                                object = OrePrefixes.pipeSmall.get(Materials.Ultimate);
                                break block0;
                            }
                            case 7: {
                                object = OrePrefixes.pipeMedium.get(Materials.Ultimate);
                                break block0;
                            }
                            case 8: {
                                object = OrePrefixes.pipeLarge.get(Materials.Ultimate);
                                break block0;
                            }
                        }
                        object = OrePrefixes.pipeHuge.get(Materials.Ultimate);
                        break;
                    }
                    case COIL_HEATING: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.wireGt02.get(Materials.AnyCopper);
                                break block0;
                            }
                            case 2: {
                                object = OrePrefixes.wireGt02.get(Materials.Cupronickel);
                                break block0;
                            }
                            case 3: {
                                object = OrePrefixes.wireGt02.get(Materials.Kanthal);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.wireGt02.get(Materials.Nichrome);
                                break block0;
                            }
                            case 5: {
                                object = OrePrefixes.wireGt02.get(Materials.TPV);
                                break block0;
                            }
                            case 6: {
                                object = OrePrefixes.wireGt02.get(Materials.HSSG);
                                break block0;
                            }
                            case 7: {
                                object = OrePrefixes.wireGt02.get(Materials.Naquadah);
                                break block0;
                            }
                            case 8: {
                                object = OrePrefixes.wireGt02.get(Materials.NaquadahAlloy);
                                break block0;
                            }
                            case 9: {
                                object = OrePrefixes.wireGt04.get(Materials.NaquadahAlloy);
                                break block0;
                            }
                        }
                        object = OrePrefixes.wireGt08.get(Materials.NaquadahAlloy);
                        break;
                    }
                    case COIL_HEATING_DOUBLE: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.wireGt04.get(Materials.AnyCopper);
                                break block0;
                            }
                            case 2: {
                                object = OrePrefixes.wireGt04.get(Materials.Cupronickel);
                                break block0;
                            }
                            case 3: {
                                object = OrePrefixes.wireGt04.get(Materials.Kanthal);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.wireGt04.get(Materials.Nichrome);
                                break block0;
                            }
                            case 5: {
                                object = OrePrefixes.wireGt04.get(Materials.TPV);
                                break block0;
                            }
                            case 6: {
                                object = OrePrefixes.wireGt04.get(Materials.HSSG);
                                break block0;
                            }
                            case 7: {
                                object = OrePrefixes.wireGt04.get(Materials.Naquadah);
                                break block0;
                            }
                            case 8: {
                                object = OrePrefixes.wireGt04.get(Materials.NaquadahAlloy);
                                break block0;
                            }
                            case 9: {
                                object = OrePrefixes.wireGt08.get(Materials.NaquadahAlloy);
                                break block0;
                            }
                        }
                        object = OrePrefixes.wireGt16.get(Materials.NaquadahAlloy);
                        break;
                    }
                    case STICK_MAGNETIC: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.stick.get(Materials.IronMagnetic);
                                break block0;
                            }
                            case 2: 
                            case 3: {
                                object = OrePrefixes.stick.get(Materials.SteelMagnetic);
                                break block0;
                            }
                            case 4: 
                            case 5: {
                                object = OrePrefixes.stick.get(Materials.NeodymiumMagnetic);
                                break block0;
                            }
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                object = OrePrefixes.stick.get(Materials.SamariumMagnetic);
                                break block0;
                            }
                        }
                        object = OrePrefixes.stick.get(Materials.TengamAttuned);
                        break;
                    }
                    case STICK_ELECTROMAGNETIC: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.stick.get(Materials.AnyIron);
                                break block0;
                            }
                            case 2: 
                            case 3: {
                                object = OrePrefixes.stick.get(Materials.Steel);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.stick.get(Materials.Neodymium);
                                break block0;
                            }
                        }
                        object = OrePrefixes.stick.get(Materials.VanadiumGallium);
                        break;
                    }
                    case COIL_ELECTRIC: {
                        switch (this.mTier) {
                            case 0: {
                                object = OrePrefixes.wireGt01.get(Materials.Lead);
                                break block0;
                            }
                            case 1: {
                                object = OrePrefixes.wireGt02.get(Materials.Tin);
                                break block0;
                            }
                            case 2: {
                                object = OrePrefixes.wireGt02.get(Materials.AnyCopper);
                                break block0;
                            }
                            case 3: {
                                object = OrePrefixes.wireGt04.get(Materials.AnyCopper);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.wireGt08.get(Materials.AnnealedCopper);
                                break block0;
                            }
                            case 5: {
                                object = OrePrefixes.wireGt16.get(Materials.AnnealedCopper);
                                break block0;
                            }
                            case 6: {
                                object = OrePrefixes.wireGt04.get(Materials.YttriumBariumCuprate);
                                break block0;
                            }
                            case 7: {
                                object = OrePrefixes.wireGt08.get(Materials.Iridium);
                                break block0;
                            }
                        }
                        object = OrePrefixes.wireGt16.get(Materials.Osmium);
                        break;
                    }
                    case ROBOT_ARM: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Robot_Arm_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Robot_Arm_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Robot_Arm_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Robot_Arm_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Robot_Arm_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Robot_Arm_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Robot_Arm_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Robot_Arm_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Robot_Arm_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Robot_Arm_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Robot_Arm_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Robot_Arm_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Robot_Arm_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Robot_Arm_MAX;
                        break;
                    }
                    case PUMP: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Electric_Pump_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Electric_Pump_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Electric_Pump_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Electric_Pump_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Electric_Pump_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Electric_Pump_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Electric_Pump_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Electric_Pump_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Electric_Pump_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Electric_Pump_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Electric_Pump_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Electric_Pump_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Electric_Pump_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Electric_Pump_MAX;
                        break;
                    }
                    case MOTOR: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Electric_Motor_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Electric_Motor_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Electric_Motor_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Electric_Motor_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Electric_Motor_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Electric_Motor_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Electric_Motor_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Electric_Motor_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Electric_Motor_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Electric_Motor_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Electric_Motor_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Electric_Motor_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Electric_Motor_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Electric_Motor_MAX;
                        break;
                    }
                    case PISTON: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Electric_Piston_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Electric_Piston_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Electric_Piston_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Electric_Piston_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Electric_Piston_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Electric_Piston_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Electric_Piston_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Electric_Piston_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Electric_Piston_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Electric_Piston_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Electric_Piston_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Electric_Piston_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Electric_Piston_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Electric_Piston_MAX;
                        break;
                    }
                    case CONVEYOR: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Conveyor_Module_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Conveyor_Module_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Conveyor_Module_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Conveyor_Module_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Conveyor_Module_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Conveyor_Module_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Conveyor_Module_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Conveyor_Module_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Conveyor_Module_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Conveyor_Module_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Conveyor_Module_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Conveyor_Module_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Conveyor_Module_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Conveyor_Module_MAX;
                        break;
                    }
                    case EMITTER: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Emitter_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Emitter_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Emitter_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Emitter_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Emitter_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Emitter_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Emitter_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Emitter_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Emitter_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Emitter_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Emitter_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Emitter_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Emitter_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Emitter_MAX;
                        break;
                    }
                    case SENSOR: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Sensor_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Sensor_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Sensor_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Sensor_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Sensor_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Sensor_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Sensor_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Sensor_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Sensor_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Sensor_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Sensor_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Sensor_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Sensor_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Sensor_MAX;
                        break;
                    }
                    case FIELD_GENERATOR: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = ItemList.Field_Generator_LV;
                                break block0;
                            }
                            case 2: {
                                object = ItemList.Field_Generator_MV;
                                break block0;
                            }
                            case 3: {
                                object = ItemList.Field_Generator_HV;
                                break block0;
                            }
                            case 4: {
                                object = ItemList.Field_Generator_EV;
                                break block0;
                            }
                            case 5: {
                                object = ItemList.Field_Generator_IV;
                                break block0;
                            }
                            case 6: {
                                object = ItemList.Field_Generator_LuV;
                                break block0;
                            }
                            case 7: {
                                object = ItemList.Field_Generator_ZPM;
                                break block0;
                            }
                            case 8: {
                                object = ItemList.Field_Generator_UV;
                                break block0;
                            }
                            case 9: {
                                object = ItemList.Field_Generator_UHV;
                                break block0;
                            }
                            case 10: {
                                object = ItemList.Field_Generator_UEV;
                                break block0;
                            }
                            case 11: {
                                object = ItemList.Field_Generator_UIV;
                                break block0;
                            }
                            case 12: {
                                object = ItemList.Field_Generator_UMV;
                                break block0;
                            }
                            case 13: {
                                object = ItemList.Field_Generator_UXV;
                                break block0;
                            }
                        }
                        object = ItemList.Field_Generator_MAX;
                        break;
                    }
                    case ROTOR: {
                        switch (this.mTier) {
                            case 0: 
                            case 1: {
                                object = OrePrefixes.rotor.get(Materials.Tin);
                                break block0;
                            }
                            case 2: {
                                object = OrePrefixes.rotor.get(Materials.Bronze);
                                break block0;
                            }
                            case 3: {
                                object = OrePrefixes.rotor.get(Materials.Steel);
                                break block0;
                            }
                            case 4: {
                                object = OrePrefixes.rotor.get(Materials.StainlessSteel);
                                break block0;
                            }
                            case 5: {
                                object = OrePrefixes.rotor.get(Materials.TungstenSteel);
                                break block0;
                            }
                            case 6: {
                                object = OrePrefixes.rotor.get(Mods.BartWorks.isModLoaded() ? Materials.get("Rhodium-PlatedPalladium") : Materials.Chrome);
                                break block0;
                            }
                            case 7: {
                                object = OrePrefixes.rotor.get(Materials.Iridium);
                                break block0;
                            }
                        }
                        object = OrePrefixes.rotor.get(Materials.Osmium);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("MISSING TIER MAPPING FOR: " + aRecipe[i] + " AT TIER " + this.mTier);
                    }
                }
                aRecipe[i] = object;
            }
            if (!GT_ModHandler.addCraftingRecipe(this.getStackForm(1L), GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.REVERSIBLE, aRecipe)) {
                throw new IllegalArgumentException("INVALID CRAFTING RECIPE FOR: " + this.getStackForm(1L).func_82833_r());
            }
        }
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, boolean usesFluids, int aGUIParameterA, int aGUIParameterB, String aGUIName, SoundResource aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, SpecialEffects aSpecialEffect, String aOverlays, Object[] aRecipe) {
        this(aID, aName, aNameRegional, aTier, aDescription, aRecipes, aInputSlots, aOutputSlots, usesFluids ? GT_MetaTileEntity_BasicMachine_GT_Recipe.getCapacityForTier(aTier) : 0, aGUIParameterA, aGUIParameterB, aGUIName, aSound.resourceLocation, aSharedTank, aRequiresFluidForFiltering, aSpecialEffect, aOverlays, aRecipe);
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aGUIParameterA, int aGUIParameterB, String aGUIName, SoundResource aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, SpecialEffects aSpecialEffect, String aOverlays, Object[] aRecipe) {
        this(aID, aName, aNameRegional, aTier, aDescription, aRecipes, aInputSlots, aOutputSlots, aTankCapacity, aGUIParameterA, aGUIParameterB, aGUIName, aSound.resourceLocation, aSharedTank, aRequiresFluidForFiltering, aSpecialEffect, aOverlays, aRecipe);
    }

    @Deprecated
    public GT_MetaTileEntity_BasicMachine_GT_Recipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aGUIParameterA, int aGUIParameterB, String aGUIName, String aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, int aSpecialEffect, String aOverlays, Object[] aRecipe) {
        this(aID, aName, aNameRegional, aTier, aDescription, aRecipes, aInputSlots, aOutputSlots, aTankCapacity, aGUIParameterA, aGUIParameterB, aGUIName, new ResourceLocation(aSound), aSharedTank, aRequiresFluidForFiltering, SpecialEffects.fromId(aSpecialEffect), aOverlays, aRecipe);
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(String aName, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aAmperage, int aGUIParameterA, int aGUIParameterB, ITexture[][][] aTextures, String aGUIName, String aNEIName, String aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, int aSpecialEffect) {
        super(aName, aTier, aAmperage, aDescription, aTextures, aInputSlots, aOutputSlots, aGUIName, aNEIName);
        this.mSharedTank = aSharedTank;
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = SpecialEffects.fromId(aSpecialEffect);
        this.mRequiresFluidForFiltering = aRequiresFluidForFiltering;
        this.mRecipes = aRecipes;
        this.mSoundResourceLocation = new ResourceLocation(aSound);
        this.mGUIParameterA = (byte)aGUIParameterA;
        this.mGUIParameterB = (byte)aGUIParameterB;
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(String aName, int aTier, String[] aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aAmperage, int aGUIParameterA, int aGUIParameterB, ITexture[][][] aTextures, String aGUIName, String aNEIName, String aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, int aSpecialEffect) {
        super(aName, aTier, aAmperage, aDescription, aTextures, aInputSlots, aOutputSlots, aGUIName, aNEIName);
        this.mSharedTank = aSharedTank;
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = SpecialEffects.fromId(aSpecialEffect);
        this.mRequiresFluidForFiltering = aRequiresFluidForFiltering;
        this.mRecipes = aRecipes;
        this.mSoundResourceLocation = new ResourceLocation(aSound);
        this.mGUIParameterA = (byte)aGUIParameterA;
        this.mGUIParameterB = (byte)aGUIParameterB;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_BasicMachine_GT_Recipe(this.mName, (int)this.mTier, this.mDescriptionArray, this.mRecipes, this.mInputSlotCount, this.mOutputItems == null ? 0 : this.mOutputItems.length, this.mTankCapacity, this.mAmperage, (int)this.mGUIParameterA, (int)this.mGUIParameterB, this.mTextures, this.mGUIName, this.mNEIName, this.mSoundResourceLocation.toString(), this.mSharedTank, this.mRequiresFluidForFiltering, this.mSpecialEffect.ordinal()).setProgressBarTexture(this.progressBarTexture);
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe setProgressBarTexture(FallbackableUITexture progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
        return this;
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe setProgressBarTextureName(String name, UITexture fallback) {
        return this.setProgressBarTexture(new FallbackableUITexture(UITexture.fullImage((String)Mods.GregTech.ID, (String)("gui/progressbar/" + name)), fallback));
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe setProgressBarTextureName(String name) {
        return this.setProgressBarTextureName(name, GT_UITextures.PROGRESSBAR_ARROW);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), this.mGUIName, GT_Utility.isStringValid(this.mNEIName) ? this.mNEIName : (this.getRecipeList() != null ? this.getRecipeList().mUnlocalizedName : ""), this.mGUIParameterA, this.mGUIParameterB);
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack)) {
            return false;
        }
        switch (this.mInputSlotCount) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.getFillableStack() == null) {
                    return !this.mRequiresFluidForFiltering && this.getRecipeList().containsInput(aStack);
                }
                return this.getRecipeList().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, true, true, GT_Values.V[this.mTier], new FluidStack[]{this.getFillableStack()}, this.getSpecialSlot(), this.appendSelectedCircuit(aStack)) != null;
            }
            case 2: {
                return (!this.mRequiresFluidForFiltering || this.getFillableStack() != null) && (this.getInputAt(0) != null && this.getInputAt(1) != null || (this.getInputAt(0) == null && this.getInputAt(1) == null ? this.getRecipeList().containsInput(aStack) : this.getRecipeList().containsInput(aStack) && this.getRecipeList().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, true, true, GT_Values.V[this.mTier], new FluidStack[]{this.getFillableStack()}, this.getSpecialSlot(), aIndex == this.getInputSlot() ? this.appendSelectedCircuit(aStack, this.getInputAt(1)) : this.appendSelectedCircuit(this.getInputAt(0), aStack)) != null));
            }
        }
        int tID = this.getBaseMetaTileEntity().getMetaTileID();
        if ((tID >= 211 && tID <= 218 || tID >= 1180 && tID <= 1187 || tID >= 10780 && tID <= 10786) && GT_Utility.isStackValid(aStack)) {
            for (int oreID : OreDictionary.getOreIDs((ItemStack)aStack)) {
                if (!OreDictionary.getOreName((int)oreID).startsWith("circuit")) continue;
                return true;
            }
        }
        return this.getRecipeList().containsInput(aStack);
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            switch (this.mSpecialEffect) {
                case TOP_SMOKE: {
                    if (aBaseMetaTileEntity.getFrontFacing() == ForgeDirection.UP || aBaseMetaTileEntity.getCoverIDAtSide(ForgeDirection.UP) != 0 || aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) break;
                    ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setIdentifier((Enum)ParticleFX.SMOKE)).setPosition((float)aBaseMetaTileEntity.getXCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f, (float)aBaseMetaTileEntity.getYCoord() + 0.9f + XSTR.XSTR_INSTANCE.nextFloat() * 0.2f, (float)aBaseMetaTileEntity.getZCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f).setWorld(aBaseMetaTileEntity.getWorld()).run();
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mSpecialEffect) {
            case MAIN_RANDOM_SPARKS: {
                double mZ;
                double z;
                double mX;
                double x;
                if (!aBaseMetaTileEntity.isActive() || XSTR.XSTR_INSTANCE.nextInt(3) != 0) break;
                ForgeDirection mainFacing = this.mMainFacing;
                if ((mainFacing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0 || aBaseMetaTileEntity.getCoverIDAtSide(mainFacing) != 0 || aBaseMetaTileEntity.getOpacityAtSide(mainFacing)) break;
                double oX = aBaseMetaTileEntity.getXCoord();
                double oY = aBaseMetaTileEntity.getYCoord();
                double oZ = aBaseMetaTileEntity.getZCoord();
                double offset = 0.02;
                double horizontal = 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat() * 8.0 / 16.0 - 0.25;
                double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 + 0.3125;
                if (mainFacing == ForgeDirection.WEST) {
                    x = oX - 0.02;
                    mX = -0.05;
                    z = oZ + horizontal;
                    mZ = 0.0;
                } else if (mainFacing == ForgeDirection.EAST) {
                    x = oX + 0.02;
                    mX = 0.05;
                    z = oZ + horizontal;
                    mZ = 0.0;
                } else if (mainFacing == ForgeDirection.NORTH) {
                    x = oX + horizontal;
                    mX = 0.0;
                    z = oZ - 0.02;
                    mZ = -0.05;
                } else {
                    x = oX + horizontal;
                    mX = 0.0;
                    z = oZ + 0.02;
                    mZ = 0.05;
                }
                WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(mX, 0.0, mZ).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.LAVA)).run();
                break;
            }
        }
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return this.mRecipes;
    }

    @Override
    public int getCapacity() {
        return this.mTankCapacity;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1 && this.mSoundResourceLocation != null && GT_Utility.isStringValid(this.mSoundResourceLocation.func_110624_b()) && GT_Utility.isStringValid(this.mSoundResourceLocation.func_110623_a())) {
            GT_Utility.doSoundAtClient(this.mSoundResourceLocation, 100, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        BaseMetaTileEntity myMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (myMetaTileEntity.mTickTimer > myMetaTileEntity.mLastSoundTick + (long)GT_Values.ticksBetweenSounds) {
            if (this.mSoundResourceLocation != null && GT_Utility.isStringValid(this.mSoundResourceLocation.func_110624_b()) && GT_Utility.isStringValid(this.mSoundResourceLocation.func_110623_a())) {
                this.sendLoopStart((byte)1);
            }
            myMetaTileEntity.mLastSoundTick = myMetaTileEntity.mTickTimer;
        }
    }

    @Override
    public FluidStack getFillableStack() {
        return this.mSharedTank ? this.getDrainableStack() : super.getFillableStack();
    }

    @Override
    public FluidStack setFillableStack(FluidStack aFluid) {
        return this.mSharedTank ? this.setDrainableStack(aFluid) : super.setFillableStack(aFluid);
    }

    @Override
    protected ProgressBar createProgressBar(UITexture texture, int imageSize, ProgressBar.Direction direction, Pos2d pos, Size size) {
        return super.createProgressBar(texture, imageSize, direction, pos, size).setTexture(this.progressBarTexture.get(), this.mRecipes.getProgressBarImageSize());
    }

    public static enum SpecialEffects {
        NONE,
        TOP_SMOKE,
        MAIN_RANDOM_SPARKS;

        static final SpecialEffects[] VALID_SPECIAL_EFFECTS;

        static SpecialEffects fromId(int id) {
            return id >= 0 && id < VALID_SPECIAL_EFFECTS.length ? VALID_SPECIAL_EFFECTS[id] : NONE;
        }

        static {
            VALID_SPECIAL_EFFECTS = new SpecialEffects[]{NONE, TOP_SMOKE, MAIN_RANDOM_SPARKS};
        }
    }

    public static enum X {
        PUMP,
        WIRE,
        WIRE4,
        HULL,
        PIPE,
        GLASS,
        PLATE,
        MOTOR,
        ROTOR,
        SENSOR,
        PISTON,
        CIRCUIT,
        EMITTER,
        CONVEYOR,
        ROBOT_ARM,
        COIL_HEATING,
        COIL_ELECTRIC,
        STICK_MAGNETIC,
        STICK_DISTILLATION,
        BETTER_CIRCUIT,
        FIELD_GENERATOR,
        COIL_HEATING_DOUBLE,
        STICK_ELECTROMAGNETIC;

    }
}

