/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.modularui;

import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.builder.UIBuilder;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GT_Packet_SendCoverData;
import gregtech.api.util.GT_CoverBehaviorBase;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_UIInfos {
    public static final Function<ContainerConstructor, UIInfo<?, ?>> GTTileEntityUIFactory = containerConstructor -> UIBuilder.of().container((player, world, x, y, z) -> {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITileWithModularUI) {
            ITileWithModularUI mui = (ITileWithModularUI)te;
            return GT_UIInfos.createTileEntityContainer(player, arg_0 -> ((ITileWithModularUI)mui).createWindow(arg_0), () -> ((TileEntity)te).func_70296_d(), containerConstructor);
        }
        return null;
    }).gui((player, world, x, y, z) -> {
        if (!world.field_72995_K) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITileWithModularUI) {
            ITileWithModularUI mui = (ITileWithModularUI)te;
            return GT_UIInfos.createTileEntityGuiContainer(player, arg_0 -> ((ITileWithModularUI)mui).createWindow(arg_0), containerConstructor);
        }
        return null;
    }).build();
    private static final UIInfo<?, ?> GTTileEntityDefaultUI = GTTileEntityUIFactory.apply(ModularUIContainer::new);
    private static final Map<ForgeDirection, UIInfo<?, ?>> coverUI = new HashMap();

    public static void openGTTileEntityUI(IHasWorldObjectAndCoords aTileEntity, EntityPlayer aPlayer) {
        if (aTileEntity.isClientSide()) {
            return;
        }
        GTTileEntityDefaultUI.open(aPlayer, aTileEntity.getWorld(), aTileEntity.getXCoord(), (int)aTileEntity.getYCoord(), aTileEntity.getZCoord());
    }

    public static void openCoverUI(ICoverable tileEntity, EntityPlayer player, ForgeDirection side) {
        if (tileEntity.isClientSide()) {
            return;
        }
        GT_Values.NW.sendToPlayer(new GT_Packet_SendCoverData(side, tileEntity.getCoverIDAtSide(side), tileEntity.getComplexCoverDataAtSide(side), tileEntity), (EntityPlayerMP)player);
        coverUI.get(side).open(player, tileEntity.getWorld(), tileEntity.getXCoord(), (int)tileEntity.getYCoord(), tileEntity.getZCoord());
    }

    public static void openPlayerHeldItemUI(EntityPlayer player) {
        if (NetworkUtils.isClient()) {
            return;
        }
        UIInfos.PLAYER_HELD_ITEM_UI.open(player);
    }

    private static ModularUIContainer createTileEntityContainer(EntityPlayer player, Function<UIBuildContext, ModularWindow> windowCreator, Runnable onWidgetUpdate, ContainerConstructor containerCreator) {
        UIBuildContext buildContext = new UIBuildContext(player);
        ModularWindow window = windowCreator.apply(buildContext);
        if (window == null) {
            return null;
        }
        return containerCreator.of(new ModularUIContext(buildContext, onWidgetUpdate), window);
    }

    @SideOnly(value=Side.CLIENT)
    private static ModularGui createTileEntityGuiContainer(EntityPlayer player, Function<UIBuildContext, ModularWindow> windowCreator, ContainerConstructor containerConstructor) {
        ModularUIContainer container = GT_UIInfos.createTileEntityContainer(player, windowCreator, null, containerConstructor);
        if (container == null) {
            return null;
        }
        return new ModularGui(container);
    }

    private static ModularUIContainer createCoverContainer(EntityPlayer player, Function<GT_CoverUIBuildContext, ModularWindow> windowCreator, Runnable onWidgetUpdate, int coverID, ForgeDirection side, ICoverable tile) {
        GT_CoverUIBuildContext buildContext = new GT_CoverUIBuildContext(player, coverID, side, tile, false);
        ModularWindow window = windowCreator.apply(buildContext);
        if (window == null) {
            return null;
        }
        return new ModularUIContainer(new ModularUIContext((UIBuildContext)buildContext, onWidgetUpdate), window);
    }

    @SideOnly(value=Side.CLIENT)
    private static ModularGui createCoverGuiContainer(EntityPlayer player, Function<GT_CoverUIBuildContext, ModularWindow> windowCreator, int coverID, ForgeDirection side, ICoverable tile) {
        ModularUIContainer container = GT_UIInfos.createCoverContainer(player, windowCreator, null, coverID, side, tile);
        if (container == null) {
            return null;
        }
        return new ModularGui(container);
    }

    static {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            coverUI.put(side, UIBuilder.of().container((player, world, x, y, z) -> {
                TileEntity te = world.func_147438_o(x, y, z);
                if (!(te instanceof ICoverable)) {
                    return null;
                }
                ICoverable gtTileEntity = (ICoverable)te;
                GT_CoverBehaviorBase<?> cover = gtTileEntity.getCoverBehaviorAtSideNew(side);
                return GT_UIInfos.createCoverContainer(player, cover::createWindow, () -> ((TileEntity)te).func_70296_d(), gtTileEntity.getCoverIDAtSide(side), side, gtTileEntity);
            }).gui((player, world, x, y, z) -> {
                if (!world.field_72995_K) {
                    return null;
                }
                TileEntity te = world.func_147438_o(x, y, z);
                if (!(te instanceof ICoverable)) {
                    return null;
                }
                ICoverable gtTileEntity = (ICoverable)te;
                GT_CoverBehaviorBase<?> cover = gtTileEntity.getCoverBehaviorAtSideNew(side);
                return GT_UIInfos.createCoverGuiContainer(player, cover::createWindow, gtTileEntity.getCoverIDAtSide(side), side, gtTileEntity);
            }).build());
        }
    }

    @FunctionalInterface
    public static interface ContainerConstructor {
        public ModularUIContainer of(ModularUIContext var1, ModularWindow var2);
    }
}

