/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.GT_ContainerMetaTile_Machine;
import gregtech.api.gui.GT_Slot_Output;
import gregtech.api.gui.GT_Slot_Render;
import gregtech.api.interfaces.IFluidAccess;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_Container_BasicTank
extends GT_ContainerMetaTile_Machine {
    public int mContent = 0;
    protected int oContent = 0;

    public GT_Container_BasicTank(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(aInventoryPlayer, aTileEntity);
    }

    @Override
    public void addSlots(InventoryPlayer aInventoryPlayer) {
        this.func_75146_a(new Slot((IInventory)this.mTileEntity, 0, 80, 17));
        this.func_75146_a(new GT_Slot_Output((IInventory)this.mTileEntity, 1, 80, 53));
        this.func_75146_a(new GT_Slot_Render((IInventory)this.mTileEntity, 2, 59, 42));
    }

    @Override
    public ItemStack func_75144_a(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
        if (aSlotIndex == 2 && aMouseclick < 2) {
            GT_MetaTileEntity_BasicTank tTank = (GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity();
            if (this.mTileEntity.isClientSide()) {
                Slot slot = (Slot)this.field_75151_b.get(aSlotIndex);
                tTank.setDrainableStack(GT_Utility.getFluidFromDisplayStack(slot.func_75211_c()));
            }
            IFluidAccess tDrainableAccess = this.constructFluidAccess(tTank, false);
            return GT_Container_BasicTank.handleFluidSlotClick(tDrainableAccess, aPlayer, aMouseclick == 0, true, !tTank.isDrainableStackSeparate());
        }
        return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.mTileEntity.isClientSide() || this.mTileEntity.getMetaTileEntity() == null) {
            return;
        }
        this.mContent = ((GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity()).mFluid != null ? ((GT_MetaTileEntity_BasicTank)this.mTileEntity.getMetaTileEntity()).mFluid.amount : 0;
        this.sendProgressBar();
        this.oContent = this.mContent;
    }

    public void sendProgressBar() {
        for (ICrafting player : this.field_75149_d) {
            if (this.mTimer % 500 != 0 && this.oContent == this.mContent) continue;
            player.func_71112_a((Container)this, 100, this.mContent & 0xFFFF);
            player.func_71112_a((Container)this, 101, this.mContent >>> 16);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 100: {
                this.mContent = this.mContent & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 101: {
                this.mContent = this.mContent & 0xFFFF | value << 16;
            }
        }
    }

    @Override
    public int getSlotCount() {
        return 2;
    }

    @Override
    public int getShiftClickSlotCount() {
        return 1;
    }

    protected IFluidAccess constructFluidAccess(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
        return new BasicTankFluidAccess(aTank, aIsFillableStack);
    }

    static class BasicTankFluidAccess
    implements IFluidAccess {
        protected final GT_MetaTileEntity_BasicTank mTank;
        protected final boolean mIsFillableStack;

        public BasicTankFluidAccess(GT_MetaTileEntity_BasicTank aTank, boolean aIsFillableStack) {
            this.mTank = aTank;
            this.mIsFillableStack = aIsFillableStack;
        }

        @Override
        public void set(FluidStack stack) {
            if (this.mIsFillableStack) {
                this.mTank.setFillableStack(stack);
            } else {
                this.mTank.setDrainableStack(stack);
            }
        }

        @Override
        public FluidStack get() {
            return this.mIsFillableStack ? this.mTank.getFillableStack() : this.mTank.getDrainableStack();
        }

        @Override
        public int getCapacity() {
            return this.mTank.getCapacity();
        }
    }
}

