/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.api;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldClient;
import ftb.utils.world.LMWorldServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class FriendsAPI {
    public static boolean areFriends(UUID player, UUID otherPlayer) {
        if (LMWorldServer.inst != null) {
            LMPlayerServer p0 = LMWorldServer.inst.getPlayer(player);
            if (p0 == null) {
                return false;
            }
            return p0.isFriend(LMWorldServer.inst.getPlayer(otherPlayer));
        }
        return false;
    }

    public static List<UUID> getFriends(UUID player) {
        ArrayList<UUID> list = new ArrayList<UUID>();
        if (LMWorldServer.inst != null) {
            LMPlayerServer p0 = LMWorldServer.inst.getPlayer(player);
            if (p0 == null) {
                return list;
            }
            for (LMPlayer p : p0.getFriends()) {
                list.add(p.getProfile().getId());
            }
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isClientFriend(UUID otherPlayer) {
        if (LMWorldClient.inst != null && LMWorldClient.inst.clientPlayer != null) {
            return LMWorldClient.inst.clientPlayer.isFriend(LMWorldClient.inst.getPlayer(otherPlayer));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<UUID> getClientFriends() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        if (LMWorldClient.inst != null && LMWorldClient.inst.clientPlayer != null) {
            for (LMPlayer p : LMWorldClient.inst.clientPlayer.getFriends()) {
                list.add(p.getProfile().getId());
            }
        }
        return list;
    }
}

