/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.entity;

import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.common.entity.EntityChaosCrystal;
import com.brandon3055.draconicevolution.common.entity.EntityDragonProjectile;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.TileChaosShard;
import com.brandon3055.draconicevolution.common.utills.DamageSourceChaos;
import com.brandon3055.draconicevolution.common.utills.DragonChunkLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityChaosGuardian
extends EntityDragon {
    private Entity target;
    public int homeX = 0;
    public int homeY = -1;
    public int homeZ = 0;
    public boolean homeSet = false;
    private int nextAttackTimer = 100;
    private int attackInProgress = -1;
    private int attackTimer = 0;
    private EnumBehaviour previousBehaviour = EnumBehaviour.ROAMING;
    private int ignitionChargeTimer = 0;
    public List<EntityChaosCrystal> crystals = null;
    public int activeCrystals = 0;
    public EntityChaosCrystal healingChaosCrystal;
    public int crystalX = 0;
    public int crystalY = -1;
    public int crystalZ = 0;
    private static final int ATTACK_FIREBALL_CHARGE = 0;
    private static final int ATTACK_FIREBALL_CHASER = 1;
    private static final int ATTACK_ENERGY_CHASER = 2;
    private static final int ATTACK_CHAOS_CHASER = 3;
    private static final int ATTACK_TELEPORT = 4;
    public float circlePosition = 0.0f;
    public float circleDirection = 1.0f;
    public EnumBehaviour behaviour = EnumBehaviour.ROAMING;
    private static final WeightedRandom.Item[] weightedAttacks = new WeightedRandom.Item[]{new WeightedAttack(16, 0), new WeightedAttack(14, 1), new WeightedAttack(12, 2), new WeightedAttack(10, 3)};
    private static final WeightedRandom.Item[] weightedLowHealthAttaxks = new WeightedRandom.Item[]{new WeightedAttack(5, 1), new WeightedAttack(5, 4), new WeightedAttack(10, 2), new WeightedAttack(15, 3)};
    private static final WeightedRandom.Item[] weightedBehaviours = new WeightedRandom.Item[]{new WeightedBehaviour(1, EnumBehaviour.LOW_HEALTH_STRATEGY), new WeightedBehaviour(10, EnumBehaviour.GUARDING), new WeightedBehaviour(4, EnumBehaviour.CHARGING), new WeightedBehaviour(12, EnumBehaviour.FIREBOMB), new WeightedBehaviour(20, EnumBehaviour.CIRCLE_PLAYER)};

    public EntityChaosGuardian(World par1World) {
        super(par1World);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)this.crystalX);
        this.field_70180_af.func_75682_a(22, (Object)this.crystalY);
        this.field_70180_af.func_75682_a(23, (Object)this.crystalZ);
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2000.0);
    }

    public void func_70636_d() {
        float f12;
        double d2;
        double d1;
        double d10;
        float f2;
        float f1;
        float f;
        if (!this.homeSet) {
            this.homeX = (int)this.field_70165_t;
            this.homeY = (int)this.field_70163_u;
            this.homeZ = (int)this.field_70161_v;
            this.field_70980_b = this.homeX;
            this.field_70978_d = this.homeZ;
            this.homeSet = true;
        }
        if (this.crystals == null) {
            this.updateCrystals();
        }
        float moveSpeedMultiplier = this.behaviour.dragonSpeed;
        if (this.field_70170_p.field_72995_K) {
            this.crystalX = this.field_70180_af.func_75679_c(21);
            this.crystalY = this.field_70180_af.func_75679_c(22);
            this.crystalZ = this.field_70180_af.func_75679_c(23);
            f = MathHelper.func_76134_b((float)(this.field_70988_bD * (float)Math.PI * 2.0f));
            f1 = MathHelper.func_76134_b((float)(this.field_70991_bC * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.field_70995_bG <= 0) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.enderdragon.wings", 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.field_70991_bC = this.field_70988_bD;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(21, (Object)this.crystalX);
            this.field_70180_af.func_75692_b(22, (Object)this.crystalY);
            this.field_70180_af.func_75692_b(23, (Object)this.crystalZ);
            this.updateTarget();
            if (this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 500.0) == null && this.func_70011_f(this.homeX, this.homeY, this.homeZ) < 100.0) {
                DragonChunkLoader.stopLoading(this);
            } else if (this.func_110143_aJ() > 0.0f) {
                DragonChunkLoader.updateLoaded(this);
            }
            if (this.field_70995_bG > 0) {
                DragonChunkLoader.stopLoading(this);
            }
            this.customAIUpdate();
            if (this.behaviour == EnumBehaviour.FIREBOMB && Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0) {
                moveSpeedMultiplier = 0.0f;
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.behaviour = EnumBehaviour.DEAD;
            f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        this.updateDragonEnderCrystal();
        f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
        f *= moveSpeedMultiplier == 0.0f ? 1.0f : moveSpeedMultiplier;
        this.field_70988_bD = this.field_70994_bF ? (this.field_70988_bD += f * 0.5f) : (this.field_70988_bD += (f *= (float)Math.pow(2.0, this.field_70181_x)));
        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
        if (this.field_70976_f < 0) {
            for (int i = 0; i < this.field_70979_e.length; ++i) {
                this.field_70979_e[i][0] = this.field_70177_z;
                this.field_70979_e[i][1] = this.field_70163_u;
            }
        }
        if (++this.field_70976_f == this.field_70979_e.length) {
            this.field_70976_f = 0;
        }
        this.field_70979_e[this.field_70976_f][0] = this.field_70177_z;
        this.field_70979_e[this.field_70976_f][1] = this.field_70163_u;
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70716_bi > 0) {
                d10 = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
                double d0 = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
                d1 = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
                d2 = MathHelper.func_76138_g((double)(this.field_70712_bm - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
                --this.field_70716_bi;
                this.func_70107_b(d10, d0, d1);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            d10 = this.field_70980_b - this.field_70165_t;
            double d0 = this.field_70981_c - this.field_70163_u;
            d1 = this.field_70978_d - this.field_70161_v;
            d2 = d10 * d10 + d0 * d0 + d1 * d1;
            if (this.target != null) {
                if (this.behaviour == EnumBehaviour.CIRCLE_PLAYER) {
                    this.field_70980_b = this.target.field_70165_t + (double)((int)(Math.cos(this.circlePosition) * 60.0));
                    this.field_70978_d = this.target.field_70161_v + (double)((int)(Math.sin(this.circlePosition) * 60.0));
                    moveSpeedMultiplier = 1.0f + Math.min((float)Utills.getDistanceAtoB((double)this.field_70980_b, (double)this.field_70978_d, (double)this.field_70165_t, (double)this.field_70161_v) / 50.0f * 3.0f, 3.0f);
                } else {
                    this.field_70980_b = this.target.field_70165_t;
                    this.field_70978_d = this.target.field_70161_v;
                }
                double d3 = this.field_70980_b - this.field_70165_t;
                double d5 = this.field_70978_d - this.field_70161_v;
                double d7 = Math.sqrt(d3 * d3 + d5 * d5);
                double d8 = (double)0.4f + d7 / 80.0 - 1.0;
                if (d8 > 10.0) {
                    d8 = 10.0;
                }
                this.field_70981_c = this.target.field_70121_D.field_72338_b + d8 + (double)(this.behaviour == EnumBehaviour.CIRCLE_PLAYER ? 25 : 0);
            } else if (this.behaviour != EnumBehaviour.FIREBOMB) {
                this.field_70980_b += this.field_70146_Z.nextGaussian() * 2.0;
                this.field_70978_d += this.field_70146_Z.nextGaussian() * 2.0;
            }
            if (this.field_70989_bE || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                this.setNewTarget();
            }
            if ((d0 /= (double)MathHelper.func_76133_a((double)(d10 * d10 + d1 * d1))) < (double)(-(f12 = 0.6f))) {
                d0 = -f12;
            }
            if (d0 > (double)f12) {
                d0 = f12;
            }
            this.field_70181_x += d0 * (double)0.1f;
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            double d4 = 180.0 - Math.atan2(d10, d1) * 180.0 / Math.PI;
            double d6 = MathHelper.func_76138_g((double)(d4 - (double)this.field_70177_z));
            if (d6 > 50.0) {
                d6 = 50.0;
            }
            if (d6 < -50.0) {
                d6 = -50.0;
            }
            Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70980_b - this.field_70165_t), (double)(this.field_70981_c - this.field_70163_u), (double)(this.field_70978_d - this.field_70161_v)).func_72432_b();
            Vec3 vec32 = Vec3.func_72443_a((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
            float f5 = (float)(vec32.func_72430_b(vec3) + 0.5) / 1.5f;
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            this.field_70704_bt *= 0.8f;
            float f6 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
            double d9 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
            if (d9 > 40.0) {
                d9 = 40.0;
            }
            this.field_70704_bt = (float)((double)this.field_70704_bt + d6 * ((double)0.7f / d9 / (double)f6));
            this.field_70177_z += this.field_70704_bt * 0.1f;
            float f7 = (float)(2.0 / (d9 + 1.0));
            float f8 = 0.06f;
            this.func_70060_a(0.0f, -1.0f, f8 * (f5 * f7 + (1.0f - f7)));
            if (this.field_70994_bF) {
                this.func_70091_d(this.field_70159_w * (double)0.8f * (double)moveSpeedMultiplier, this.field_70181_x * (double)0.8f * (double)moveSpeedMultiplier, this.field_70179_y * (double)0.8f * (double)moveSpeedMultiplier);
            } else {
                this.func_70091_d(this.field_70159_w * (double)moveSpeedMultiplier, this.field_70181_x * (double)moveSpeedMultiplier, this.field_70179_y * (double)moveSpeedMultiplier);
            }
            Vec3 vec31 = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
            float f9 = (float)(vec31.func_72430_b(vec32) + 1.0) / 2.0f;
            f9 = 0.8f + 0.15f * f9;
            this.field_70159_w *= (double)f9;
            this.field_70179_y *= (double)f9;
            this.field_70181_x *= (double)0.91f;
        }
        this.field_70761_aq = this.field_70177_z;
        this.field_70986_h.field_70131_O = 3.0f;
        this.field_70986_h.field_70130_N = 3.0f;
        this.field_70985_j.field_70131_O = 2.0f;
        this.field_70985_j.field_70130_N = 2.0f;
        this.field_70984_by.field_70131_O = 2.0f;
        this.field_70984_by.field_70130_N = 2.0f;
        this.field_70982_bz.field_70131_O = 2.0f;
        this.field_70982_bz.field_70130_N = 2.0f;
        this.field_70987_i.field_70131_O = 3.0f;
        this.field_70987_i.field_70130_N = 5.0f;
        this.field_70983_bA.field_70131_O = 2.0f;
        this.field_70983_bA.field_70130_N = 4.0f;
        this.field_70990_bB.field_70131_O = 3.0f;
        this.field_70990_bB.field_70130_N = 4.0f;
        f1 = (float)(this.func_70974_a(5, 1.0f)[1] - this.func_70974_a(10, 1.0f)[1]) * 10.0f / 180.0f * (float)Math.PI;
        f2 = MathHelper.func_76134_b((float)f1);
        float f10 = -MathHelper.func_76126_a((float)f1);
        float f3 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f11 = MathHelper.func_76126_a((float)f3);
        float f4 = MathHelper.func_76134_b((float)f3);
        this.field_70987_i.func_70071_h_();
        this.field_70987_i.func_70012_b(this.field_70165_t + (double)(f11 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f4 * 0.5f), 0.0f, 0.0f);
        this.field_70983_bA.func_70071_h_();
        this.field_70983_bA.func_70012_b(this.field_70165_t + (double)(f4 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f11 * 4.5f), 0.0f, 0.0f);
        this.field_70990_bB.func_70071_h_();
        this.field_70990_bB.func_70012_b(this.field_70165_t - (double)(f4 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f11 * 4.5f), 0.0f, 0.0f);
        if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.field_70983_bA.field_70121_D.func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
            this.collideWithEntities(this.field_70170_p.func_72839_b((Entity)this, this.field_70990_bB.field_70121_D.func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0)));
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70986_h.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        double[] adouble1 = this.func_70974_a(5, 1.0f);
        double[] adouble = this.func_70974_a(0, 1.0f);
        f12 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
        float f13 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f - this.field_70704_bt * 0.01f));
        this.field_70986_h.func_70071_h_();
        this.field_70986_h.func_70012_b(this.field_70165_t + (double)(f12 * 5.5f * f2), this.field_70163_u + (adouble[1] - adouble1[1]) * 1.0 + (double)(f10 * 5.5f), this.field_70161_v - (double)(f13 * 5.5f * f2), 0.0f, 0.0f);
        for (int j = 0; j < 3; ++j) {
            EntityDragonPart entitydragonpart = null;
            if (j == 0) {
                entitydragonpart = this.field_70985_j;
            }
            if (j == 1) {
                entitydragonpart = this.field_70984_by;
            }
            if (j == 2) {
                entitydragonpart = this.field_70982_bz;
            }
            double[] adouble2 = this.func_70974_a(12 + j * 2, 1.0f);
            float f14 = this.field_70177_z * (float)Math.PI / 180.0f + this.simplifyAngle(adouble2[0] - adouble1[0]) * (float)Math.PI / 180.0f * 1.0f;
            float f15 = MathHelper.func_76126_a((float)f14);
            float f16 = MathHelper.func_76134_b((float)f14);
            float f17 = 1.5f;
            float f18 = (float)(j + 1) * 2.0f;
            entitydragonpart.func_70071_h_();
            entitydragonpart.func_70012_b(this.field_70165_t - (double)((f11 * f17 + f15 * f18) * f2), this.field_70163_u + (adouble2[1] - adouble1[1]) * 1.0 - (double)((f18 + f17) * f10) + 1.5, this.field_70161_v + (double)((f4 * f17 + f16 * f18) * f2), 0.0f, 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70994_bF = this.destroyBlocksInAABB(this.field_70986_h.field_70121_D) | this.destroyBlocksInAABB(this.field_70987_i.field_70121_D);
        }
    }

    public void onCrystalTargeted(EntityPlayer player, boolean destroyed) {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.target = player;
        if (destroyed || this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY) {
            this.attackInProgress = 3;
            this.behaviour = EnumBehaviour.CHARGING;
            this.nextAttackTimer = 20;
            this.attackTimer = 100;
            this.updateCrystals();
        } else {
            this.attackInProgress = 0;
            this.previousBehaviour = this.behaviour;
            this.behaviour = EnumBehaviour.CHARGING;
            this.nextAttackTimer = 20;
            this.attackTimer = 1000;
        }
        if (this.field_70995_bG <= 0) {
            this.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.enderdragon.growl", 20.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f);
        }
    }

    public void updateCrystals() {
        if (this.crystals == null) {
            this.crystals = new ArrayList<EntityChaosCrystal>();
        }
        List list = this.field_70170_p.func_72872_a(EntityChaosCrystal.class, AxisAlignedBB.func_72330_a((double)this.homeX, (double)this.homeY, (double)this.homeZ, (double)this.homeX, (double)this.homeY, (double)this.homeZ).func_72314_b(200.0, 200.0, 200.0));
        this.activeCrystals = 0;
        for (EntityChaosCrystal crystal : list) {
            if (!this.crystals.contains((Object)crystal)) {
                this.crystals.add(crystal);
            }
            if (!crystal.isAlive()) continue;
            ++this.activeCrystals;
        }
    }

    private void customAIUpdate() {
        if (this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP() * 0.2f) {
            this.behaviour = EnumBehaviour.LOW_HEALTH_STRATEGY;
        }
        if (this.field_70173_aa % 200 == 0) {
            this.crystals = null;
            this.activeCrystals = 0;
            this.crystalY = -1;
            this.healingChaosCrystal = null;
            this.updateCrystals();
        }
        switch (this.behaviour) {
            case ROAMING: {
                if (this.field_70170_p.func_72846_b((double)this.homeX, (double)this.homeY, (double)this.homeZ, 200.0) == null) break;
                this.selectNewBehaviour();
                break;
            }
            case GO_HOME: {
                if (!(Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) < 70.0)) break;
                this.selectNewBehaviour();
                break;
            }
            case GUARDING: {
                break;
            }
            case FIREBOMB: {
                break;
            }
            case CHARGING: {
                if (!(Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) > 300.0)) break;
                this.behaviour = EnumBehaviour.GO_HOME;
                break;
            }
            case CIRCLE_PLAYER: {
                this.circlePosition += 0.02f * this.circleDirection;
                if (!(Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70161_v, (double)this.homeX, (double)this.homeZ) > 300.0) && !(this.field_70163_u > 250.0)) break;
                this.behaviour = EnumBehaviour.GO_HOME;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                if (this.field_70170_p.func_72846_b(this.field_70980_b, this.field_70981_c, this.field_70978_d, 60.0) == null || this.attackInProgress == 4) break;
                boolean flag = false;
                for (int escape = 0; !flag && escape < 50; ++escape) {
                    this.field_70980_b = (double)this.homeX + (this.field_70146_Z.nextDouble() - 0.5) * 220.0;
                    this.field_70981_c = (double)(this.homeY + 20) + this.field_70146_Z.nextDouble() * 20.0;
                    this.field_70978_d = (double)this.homeZ + (this.field_70146_Z.nextDouble() - 0.5) * 220.0;
                    if (this.field_70170_p.func_72846_b(this.field_70980_b, this.field_70981_c, this.field_70978_d, 60.0) != null) continue;
                    flag = true;
                }
                this.target = null;
                break;
            }
            case DEAD: {
                this.target = null;
                this.field_70980_b = this.homeX;
                this.field_70981_c = this.homeY;
                this.field_70978_d = this.homeZ;
            }
        }
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        if (this.field_70173_aa % 1000 == 0 && this.field_70146_Z.nextBoolean()) {
            this.selectNewBehaviour();
        }
        if (this.ignitionChargeTimer > 1 || this.ignitionChargeTimer == 1 && this.field_70173_aa % 20 == 0 && !ConfigHandler.disableGuardianCrystalRespawn) {
            --this.ignitionChargeTimer;
        }
        if (this.ignitionChargeTimer <= 0 && !this.field_70170_p.field_72995_K) {
            if ((this.field_70173_aa - 19) % 20 == 0) {
                this.ignitionChargeTimer = (this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 1000 : 2000) + this.field_70146_Z.nextInt(600);
            }
            if (this.activeCrystals < this.crystals.size() && this.field_70173_aa % 10 == 0) {
                EntityChaosCrystal closest = null;
                for (EntityChaosCrystal crystal : this.crystals) {
                    if (crystal.isAlive() || closest != null && !(this.func_70032_d((Entity)crystal) < this.func_70032_d((Entity)closest))) continue;
                    closest = crystal;
                }
                if (closest != null) {
                    EntityDragonProjectile charge = new EntityDragonProjectile(this.field_70170_p, 7, closest, 0.0f, (Entity)this);
                    charge.func_70107_b(this.field_70986_h.field_70165_t + Math.cos((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0, this.field_70986_h.field_70163_u + 1.5, this.field_70986_h.field_70161_v + Math.sin((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0);
                    this.field_70170_p.func_72838_d((Entity)charge);
                }
            }
        }
        this.updateAttack();
    }

    private void updateAttack() {
        if (this.field_70170_p.field_72995_K || this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        if (this.behaviour == EnumBehaviour.FIREBOMB && Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0) {
            if (this.target == null || this.field_70173_aa % 100 == 0) {
                this.setNewTarget();
            }
            if (this.target != null) {
                double distance = Utills.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70161_v, (double)this.field_70986_h.field_70165_t, (double)this.field_70986_h.field_70161_v);
                if (Utills.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) < 5.0) {
                    distance *= -1.0;
                }
                float anglePitch = (float)Math.toDegrees(Math.atan2(this.target.field_70163_u - this.field_70986_h.field_70163_u, distance)) * -1.0f;
                float angleYaw = (float)Math.toDegrees(Math.atan2(this.target.field_70165_t - this.field_70986_h.field_70165_t, this.target.field_70161_v - this.field_70161_v)) * -1.0f;
                this.field_70125_A = anglePitch;
                if (Utills.getDistanceAtoB((double)this.target.field_70165_t, (double)this.target.field_70161_v, (double)this.field_70165_t, (double)this.field_70161_v) > 8.0) {
                    this.field_70177_z = angleYaw + 180.0f;
                }
                if (this.field_70173_aa % 2 == 0) {
                    EntityDragonProjectile projectile = new EntityDragonProjectile(this.field_70170_p, 1, this.target instanceof EntityLivingBase ? (EntityLivingBase)this.target : null, 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                    projectile.func_70107_b(this.field_70986_h.field_70165_t + Math.cos((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0, this.field_70986_h.field_70163_u + 1.5, this.field_70986_h.field_70161_v + Math.sin((this.field_70177_z - 90.0f) / 180.0f * (float)Math.PI) * 2.0);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                }
            }
        } else if (this.nextAttackTimer > 0) {
            --this.nextAttackTimer;
        } else if (this.nextAttackTimer == 0) {
            List targets;
            Entity attackTarget = this.target;
            List list = targets = attackTarget == null ? this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.homeX, (double)this.homeY, (double)this.homeZ, (double)this.homeX, (double)this.homeY, (double)this.homeZ).func_72314_b(100.0, 100.0, 100.0)) : null;
            if (targets != null && targets.size() > 0) {
                Iterator i = targets.iterator();
                while (i.hasNext()) {
                    if (!((EntityPlayer)i.next()).field_71075_bZ.field_75098_d) continue;
                    i.remove();
                }
            }
            if (attackTarget == null && targets != null && targets.size() > 0) {
                attackTarget = (Entity)targets.get(this.field_70146_Z.nextInt(targets.size()));
            }
            if (attackTarget == null) {
                return;
            }
            if (this.attackInProgress == -1) {
                this.selectNewAttack();
                switch (this.attackInProgress) {
                    case 0: {
                        this.attackTimer = 90 + this.field_70146_Z.nextInt(80);
                        this.previousBehaviour = this.behaviour;
                        this.behaviour = EnumBehaviour.CHARGING;
                        break;
                    }
                    case 1: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(80);
                        break;
                    }
                    case 2: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(80);
                        break;
                    }
                    case 3: {
                        this.attackTimer = 10 + this.field_70146_Z.nextInt(80);
                        break;
                    }
                    case 4: {
                        this.attackTimer = 90 + this.field_70146_Z.nextInt(80);
                    }
                }
            }
            switch (this.attackInProgress) {
                case 0: {
                    EntityDragonProjectile projectile;
                    if (this.target == null && this.behaviour == EnumBehaviour.CHARGING) {
                        this.target = attackTarget;
                    }
                    if (Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)attackTarget.field_70165_t, (double)attackTarget.field_70163_u, (double)attackTarget.field_70161_v) > 10.0) {
                        float angle;
                        if (this.attackTimer % 2 == 0) {
                            projectile = new EntityDragonProjectile(this.field_70170_p, 1, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                            projectile.func_70107_b(this.field_70986_h.field_70165_t, this.field_70986_h.field_70163_u, this.field_70986_h.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        double distance = Utills.getDistanceAtoB((double)attackTarget.field_70165_t, (double)attackTarget.field_70161_v, (double)this.field_70986_h.field_70165_t, (double)this.field_70986_h.field_70161_v);
                        this.field_70125_A = angle = (float)Math.toDegrees(Math.atan2(attackTarget.field_70163_u - this.field_70986_h.field_70163_u, distance)) * -1.0f;
                        break;
                    }
                    this.attackTimer = 0;
                    break;
                }
                case 1: {
                    if (this.attackTimer % 10 != 0) break;
                    EntityDragonProjectile projectile = new EntityDragonProjectile(this.field_70170_p, 3, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 2.0f, (Entity)this);
                    projectile.func_70107_b(this.field_70986_h.field_70165_t, this.field_70986_h.field_70163_u, this.field_70986_h.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 2: {
                    if (this.attackTimer % 10 != 0) break;
                    EntityDragonProjectile projectile = new EntityDragonProjectile(this.field_70170_p, 4, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.field_70986_h.field_70165_t, this.field_70986_h.field_70163_u, this.field_70986_h.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 3: {
                    if (this.attackTimer % 10 != 0) break;
                    EntityDragonProjectile projectile = new EntityDragonProjectile(this.field_70170_p, 5, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 10.0f, (Entity)this);
                    projectile.func_70107_b(this.field_70986_h.field_70165_t, this.field_70986_h.field_70163_u, this.field_70986_h.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)projectile);
                    break;
                }
                case 4: {
                    EntityDragonProjectile projectile;
                    if (this.target == null) {
                        this.target = this.field_70170_p.func_72856_b((Entity)this, 100.0);
                    }
                    if (this.target == null) {
                        this.attackInProgress = -1;
                        return;
                    }
                    if (Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)attackTarget.field_70165_t, (double)attackTarget.field_70163_u, (double)attackTarget.field_70161_v) > 15.0) {
                        float angle;
                        if (this.attackTimer % 2 == 0) {
                            projectile = new EntityDragonProjectile(this.field_70170_p, 2, attackTarget instanceof EntityLivingBase ? (EntityLivingBase)attackTarget : null, 5.0f + this.field_70146_Z.nextFloat() * 8.0f, (Entity)this);
                            projectile.func_70107_b(this.field_70986_h.field_70165_t, this.field_70986_h.field_70163_u, this.field_70986_h.field_70161_v);
                            this.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        double distance = Utills.getDistanceAtoB((double)attackTarget.field_70165_t, (double)attackTarget.field_70161_v, (double)this.field_70986_h.field_70165_t, (double)this.field_70986_h.field_70161_v);
                        this.field_70125_A = angle = (float)Math.toDegrees(Math.atan2(attackTarget.field_70163_u - this.field_70986_h.field_70163_u, distance)) * -1.0f;
                        break;
                    }
                    this.attackTimer = 0;
                }
            }
            --this.attackTimer;
            if (this.attackTimer <= -1) {
                if (this.attackInProgress == 0) {
                    this.behaviour = this.previousBehaviour;
                }
                this.attackInProgress = -1;
                this.nextAttackTimer = -1;
            }
        } else {
            this.nextAttackTimer = this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? 10 + this.field_70146_Z.nextInt(50) : 60 + this.field_70146_Z.nextInt(200);
        }
    }

    private void selectNewAttack() {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.attackInProgress = this.behaviour == EnumBehaviour.LOW_HEALTH_STRATEGY ? ((WeightedAttack)WeightedRandom.func_76274_a((Random)this.field_70146_Z, (WeightedRandom.Item[])EntityChaosGuardian.weightedLowHealthAttaxks)).attack : (this.behaviour != EnumBehaviour.FIREBOMB ? ((WeightedAttack)WeightedRandom.func_76274_a((Random)this.field_70146_Z, (WeightedRandom.Item[])EntityChaosGuardian.weightedAttacks)).attack : 2);
    }

    private void selectNewBehaviour() {
        if (this.field_70170_p.field_72995_K || this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        EnumBehaviour newBehaviour = this.behaviour;
        while (newBehaviour == this.behaviour) {
            newBehaviour = ((WeightedBehaviour)WeightedRandom.func_76274_a((Random)this.field_70146_Z, (WeightedRandom.Item[])EntityChaosGuardian.weightedBehaviours)).randomBehaviour;
        }
        this.previousBehaviour = this.behaviour = newBehaviour;
    }

    private void updateTarget() {
        switch (this.behaviour) {
            case ROAMING: {
                break;
            }
            case GO_HOME: {
                break;
            }
            case GUARDING: {
                break;
            }
            case CHARGING: {
                break;
            }
            case FIREBOMB: {
                if (!(Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) > 3.0)) break;
                this.field_70980_b = this.homeX;
                this.field_70981_c = this.homeY + 30;
                this.field_70978_d = this.homeZ;
                break;
            }
            case CIRCLE_PLAYER: {
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                break;
            }
            case DEAD: {
                this.field_70980_b = this.homeX;
                this.field_70981_c = this.homeY;
                this.field_70978_d = this.homeZ;
                this.target = null;
            }
        }
    }

    private void setNewTarget() {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return;
        }
        this.field_70989_bE = false;
        switch (this.behaviour) {
            case ROAMING: {
                double d2;
                double d1;
                double d0;
                boolean flag = false;
                do {
                    this.field_70980_b = this.homeX;
                    this.field_70981_c = (float)this.homeY + this.field_70146_Z.nextFloat() * 50.0f;
                    this.field_70978_d = this.homeZ;
                    this.field_70980_b += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                    this.field_70978_d += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                } while (!(flag = (d0 = this.field_70165_t - this.field_70980_b) * d0 + (d1 = this.field_70163_u - this.field_70981_c) * d1 + (d2 = this.field_70161_v - this.field_70978_d) * d2 > 100.0));
                this.target = null;
                break;
            }
            case GO_HOME: 
            case GUARDING: {
                this.field_70980_b = this.homeX;
                this.field_70981_c = (float)this.homeY + this.field_70146_Z.nextFloat() * 50.0f;
                this.field_70978_d = this.homeZ;
                this.target = null;
                break;
            }
            case CHARGING: 
            case CIRCLE_PLAYER: {
                if (this.field_70170_p.func_72846_b((double)this.homeX, (double)this.homeY, (double)this.homeZ, 200.0) == null) break;
                this.target = this.field_70170_p.func_72846_b((double)this.homeX, (double)this.homeY, (double)this.homeZ, 200.0);
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                break;
            }
            case FIREBOMB: {
                List targets = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(150.0, 150.0, 150.0));
                this.target = null;
                while (targets.size() > 0 && this.target == null) {
                    EntityPlayer potentialTarget = (EntityPlayer)targets.get(this.field_70146_Z.nextInt(targets.size()));
                    if (this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)potentialTarget.field_70165_t, (double)potentialTarget.field_70163_u, (double)potentialTarget.field_70161_v)) == null) {
                        this.target = potentialTarget;
                        continue;
                    }
                    targets.remove(potentialTarget);
                }
                break;
            }
        }
    }

    public boolean func_70965_a(EntityDragonPart part, DamageSource damageSource, float dmg) {
        if (this.behaviour == EnumBehaviour.DEAD) {
            return false;
        }
        if (part != this.field_70986_h) {
            dmg = dmg / 4.0f + 1.0f;
        }
        if (dmg > 50.0f) {
            dmg = (float)((double)dmg - (double)(dmg - 50.0f) * 0.7);
        }
        switch (this.behaviour) {
            case ROAMING: {
                break;
            }
            case GO_HOME: {
                break;
            }
            case GUARDING: {
                if (this.field_70146_Z.nextInt(5) != 0) break;
                this.selectNewBehaviour();
                break;
            }
            case CHARGING: {
                if (this.field_70146_Z.nextInt(6) != 0) break;
                this.selectNewBehaviour();
                break;
            }
            case CIRCLE_PLAYER: {
                if (this.field_70146_Z.nextInt(6) == 0) {
                    this.selectNewBehaviour();
                    break;
                }
                if (this.field_70146_Z.nextInt(4) != 0) break;
                this.circleDirection *= -1.0f;
                break;
            }
            case LOW_HEALTH_STRATEGY: {
                if (this.field_70146_Z.nextInt(6) == 0 && this.func_110143_aJ() >= this.func_110138_aP() * 0.2f) {
                    this.selectNewBehaviour();
                }
                if (!(damageSource.func_76346_g() instanceof EntityPlayer) || this.attackInProgress == 4) break;
                boolean flag = false;
                for (int escape = 0; !flag && escape < 50; ++escape) {
                    this.field_70980_b = (double)this.homeX + (this.field_70146_Z.nextDouble() - 0.5) * 260.0;
                    this.field_70981_c = (double)(this.homeY + 20) + (this.field_70146_Z.nextDouble() - 0.5) * 50.0;
                    this.field_70978_d = (double)this.homeZ + (this.field_70146_Z.nextDouble() - 0.5) * 260.0;
                    if (!(this.func_70032_d(damageSource.func_76346_g()) >= 70.0f)) continue;
                    flag = true;
                }
                this.target = null;
                break;
            }
            case FIREBOMB: {
                if (this.target == null && Utills.getDistanceAtoB((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)this.homeX, (double)(this.homeY + 30), (double)this.homeZ) <= 3.0 || this.field_70146_Z.nextInt(5) == 0) {
                    this.selectNewBehaviour();
                }
                if (!(damageSource.func_76346_g() instanceof EntityPlayer) || damageSource.func_76346_g() == this.target || this.field_70170_p.func_72933_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)damageSource.func_76346_g().field_70165_t, (double)damageSource.func_76346_g().field_70163_u, (double)damageSource.func_76346_g().field_70161_v)) != null) break;
                this.target = damageSource.func_76346_g();
                break;
            }
        }
        if ((damageSource.func_76346_g() instanceof EntityPlayer || damageSource.func_94541_c()) && this.healingChaosCrystal == null) {
            this.func_82195_e(damageSource, dmg);
        } else if (damageSource.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.func_76346_g()).func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"msg.de.guardianAttackBlocked.txt")));
        }
        return true;
    }

    protected void func_70609_aI() {
        if (this.field_70995_bG == 0) {
            if (this.field_70170_p.func_147438_o(this.homeX, this.homeY, this.homeZ) instanceof TileChaosShard) {
                ((TileChaosShard)this.field_70170_p.func_147438_o(this.homeX, this.homeY, this.homeZ)).setDefeated();
            } else {
                for (int x = this.homeX - 100; x < this.homeX + 100; ++x) {
                    block1: for (int y = this.homeY - 100; y < this.homeX + 100; ++y) {
                        if (y < 0 || y > 255) continue;
                        for (int z = this.homeX - 100; z < this.homeX + 100; ++z) {
                            if (!(this.field_70170_p.func_147438_o(x, y, z) instanceof TileChaosShard)) continue;
                            ((TileChaosShard)this.field_70170_p.func_147438_o(x, y, z)).setDefeated();
                            continue block1;
                        }
                    }
                }
            }
        }
        ++this.field_70995_bG;
        if (this.field_70995_bG >= 180 && this.field_70995_bG <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (this.field_70995_bG == 1) {
            this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.enderdragon.end", 50.0f, 1.0f, false);
        }
        if (this.func_70011_f(this.homeX, this.homeY, this.homeZ) < 20.0 && this.field_70995_bG % 2 == 0) {
            EntityLightningBolt bolt = new EntityLightningBolt(this.field_70170_p, (double)this.homeX, (double)(this.homeY + 1), (double)this.homeZ);
            bolt.field_70158_ak = true;
            this.field_70170_p.func_72942_c((Entity)bolt);
        }
        if (this.func_70011_f(this.homeX, this.homeY, this.homeZ) < 5.0 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 200000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.updateCrystals();
            for (EntityChaosCrystal crystal : this.crystals) {
                crystal.setDeathTimer();
            }
            this.func_70106_y();
        }
    }

    private void collideWithEntities(List par1List) {
    }

    private void attackEntitiesInList(List par1List) {
        if (this.behaviour == EnumBehaviour.CHARGING) {
            boolean hasAttacked = false;
            for (int i = 0; i < par1List.size(); ++i) {
                Entity entity = (Entity)par1List.get(i);
                if (!(entity instanceof EntityPlayer)) continue;
                ((EntityLivingBase)entity).func_130011_c((Entity)this);
                entity.func_70097_a((DamageSource)new DamageSourceChaos((Entity)this), 50.0f);
                hasAttacked = true;
            }
            if (hasAttacked && this.field_70146_Z.nextInt(2) == 0) {
                this.behaviour = EnumBehaviour.GUARDING;
            }
        }
    }

    private void updateDragonEnderCrystal() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.healingChaosCrystal = null;
            this.crystalY = -1;
            return;
        }
        if (this.healingChaosCrystal != null) {
            if (!this.healingChaosCrystal.isAlive()) {
                this.func_70965_a(this.field_70986_h, DamageSource.func_94539_a(null), 10.0f);
                this.healingChaosCrystal = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 2.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0) {
            EntityChaosCrystal closest = null;
            for (EntityChaosCrystal crystal : this.crystals) {
                if (!crystal.isAlive() || closest != null && !(this.func_70032_d((Entity)crystal) < this.func_70032_d((Entity)closest))) continue;
                closest = crystal;
            }
            this.healingChaosCrystal = closest;
            if (this.healingChaosCrystal != null) {
                this.crystalX = (int)Math.floor(this.healingChaosCrystal.field_70165_t);
                this.crystalY = (int)Math.floor(this.healingChaosCrystal.field_70163_u);
                this.crystalZ = (int)Math.floor(this.healingChaosCrystal.field_70161_v);
            } else {
                this.crystalY = -1;
            }
        }
    }

    private float simplifyAngle(double par1) {
        return (float)MathHelper.func_76138_g((double)par1);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        if (!ConfigHandler.dragonBreaksBlocks) {
            return false;
        }
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        int l = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block.isAir((IBlockAccess)this.field_70170_p, k1, l1, i2)) continue;
                    if (block.canEntityDestroy((IBlockAccess)this.field_70170_p, k1, l1, i2, (Entity)this) && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = this.field_70170_p.func_147468_f(k1, l1, i2) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d1 = par1AxisAlignedBB.field_72340_a + (par1AxisAlignedBB.field_72336_d - par1AxisAlignedBB.field_72340_a) * (double)this.field_70146_Z.nextFloat();
            double d2 = par1AxisAlignedBB.field_72338_b + (par1AxisAlignedBB.field_72337_e - par1AxisAlignedBB.field_72338_b) * (double)this.field_70146_Z.nextFloat();
            double d0 = par1AxisAlignedBB.field_72339_c + (par1AxisAlignedBB.field_72334_f - par1AxisAlignedBB.field_72339_c) * (double)this.field_70146_Z.nextFloat();
            this.field_70170_p.func_72869_a("largeexplode", d1, d2, d0, 0.0, 0.0, 0.0);
        }
        return flag;
    }

    private void spawnEgg() {
    }

    private void createEnderPortal(int par1, int par2) {
        int b0 = this.homeY - 3;
        int b1 = 4;
        for (int k = b0 - 1; k <= b0 + 32; ++k) {
            for (int l = par1 - b1; l <= par1 + b1; ++l) {
                for (int i1 = par2 - b1; i1 <= par2 + b1; ++i1) {
                    double d0 = l - par1;
                    double d1 = i1 - par2;
                    double d2 = d0 * d0 + d1 * d1;
                    if (!(d2 <= ((double)b1 - 0.5) * ((double)b1 - 0.5))) continue;
                    if (k < b0) {
                        if (!(d2 <= ((double)(b1 - 1) - 0.5) * ((double)(b1 - 1) - 0.5))) continue;
                        this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150357_h);
                        continue;
                    }
                    if (k > b0) {
                        this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150350_a);
                        continue;
                    }
                    if (!(d2 > ((double)(b1 - 1) - 0.5) * ((double)(b1 - 1) - 0.5))) continue;
                    this.field_70170_p.func_147449_b(l, k, i1, Blocks.field_150357_h);
                }
            }
        }
        this.field_70170_p.func_147449_b(par1, b0 + 0, par2, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(par1, b0 + 1, par2, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(par1, b0 + 2, par2, Blocks.field_150357_h);
        this.field_70170_p.func_147449_b(par1, b0 + 3, par2, Blocks.field_150357_h);
    }

    public void func_70109_d(NBTTagCompound compound) {
        super.func_70109_d(compound);
        compound.func_74768_a("HomeXCoord", this.homeX);
        compound.func_74768_a("HomeYCoord", this.homeY);
        compound.func_74768_a("HomeZCoord", this.homeZ);
        compound.func_74778_a("Behaviour", this.behaviour.name());
        compound.func_74757_a("HomeSet", this.homeSet);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.homeX = compound.func_74762_e("HomeXCoord");
        this.homeY = compound.func_74762_e("HomeYCoord");
        this.homeZ = compound.func_74762_e("HomeZCoord");
        if (compound.func_74764_b("Behaviour")) {
            this.behaviour = EnumBehaviour.valueOf(compound.func_74779_i("Behaviour"));
        }
        this.homeSet = compound.func_74767_n("HomeSet");
        this.field_70980_b = this.homeX;
        this.field_70978_d = this.homeZ;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70623_bb() {
    }

    public boolean func_70097_a(DamageSource damageSource, float dmg) {
        return super.func_70097_a(damageSource, dmg);
    }

    public void func_71027_c(int p_71027_1_) {
    }

    private static class WeightedBehaviour
    extends WeightedRandom.Item {
        public EnumBehaviour randomBehaviour;

        public WeightedBehaviour(int weight, EnumBehaviour randomBehaviour) {
            super(weight);
            this.randomBehaviour = randomBehaviour;
        }
    }

    private static class WeightedAttack
    extends WeightedRandom.Item {
        public int attack;

        public WeightedAttack(int weight, int attack) {
            super(weight);
            this.attack = attack;
        }
    }

    private static enum EnumBehaviour {
        ROAMING(1.0f),
        GO_HOME(1.3f),
        GUARDING(0.8f),
        CHARGING(2.0f),
        FIREBOMB(1.5f),
        CIRCLE_PLAYER(1.2f),
        LOW_HEALTH_STRATEGY(2.0f),
        DEAD(0.5f);

        public float dragonSpeed;

        private EnumBehaviour(float dragonSpeed) {
            this.dragonSpeed = dragonSpeed;
        }
    }
}

