/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.texture;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.io.ThemeFileHandler;
import journeymap.client.model.MapType;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.ui.theme.Theme;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;

public class TextureCache {
    private final Map<Name, TextureImpl> namedTextures = Collections.synchronizedMap(new HashMap(Name.values().length + Name.values().length / 2 + 1));
    private final Map<String, TextureImpl> playerSkins = Collections.synchronizedMap(new HashMap());
    private final Map<String, TextureImpl> entityIcons = Collections.synchronizedMap(new HashMap());
    private final Map<String, TextureImpl> themeImages = Collections.synchronizedMap(new HashMap());
    private ThreadPoolExecutor texExec = new ThreadPoolExecutor(2, 4, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new JMThreadFactory("texture"), new ThreadPoolExecutor.CallerRunsPolicy());

    private TextureCache() {
    }

    public static TextureCache instance() {
        return Holder.INSTANCE;
    }

    public Future<TextureImpl> scheduleTextureTask(Callable<TextureImpl> textureTask) {
        return this.texExec.submit(textureTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextureImpl getNamedTexture(Name name, String filename, boolean retain) {
        Map<Name, TextureImpl> map = this.namedTextures;
        synchronized (map) {
            TextureImpl tex = this.namedTextures.get((Object)name);
            if (tex == null || !tex.hasImage() && retain) {
                BufferedImage img = FileHandler.getWebImage(filename);
                if (img == null) {
                    img = this.getUnknownEntity().getImage();
                }
                if (img != null) {
                    if (tex != null) {
                        tex.queueForDeletion();
                    }
                    tex = new TextureImpl(img, retain);
                    tex.setDescription(String.format("%s (%s)", new Object[]{name, filename}));
                    this.namedTextures.put(name, tex);
                }
            }
            return tex;
        }
    }

    public TextureImpl getMinimapCustomSquare(int size, float alpha) {
        size = Math.max(64, Math.min(size, 1024));
        alpha = Math.max(0.0f, Math.min(alpha, 1.0f));
        String frameImg = size <= 128 ? "minimap/minimap-square-128.png" : (size <= 256 ? "minimap/minimap-square-256.png" : (size <= 512 ? "minimap/minimap-square-512.png" : "minimap/minimap-square-128.png"));
        BufferedImage img = FileHandler.getWebImage(frameImg);
        BufferedImage resizedImg = new BufferedImage(size, size, 2);
        Graphics2D g = (Graphics2D)resizedImg.getGraphics();
        g.setComposite(AlphaComposite.getInstance(3, alpha));
        g.drawImage(img, 0, 0, size, size, null);
        g.dispose();
        TextureImpl tex = this.namedTextures.get((Object)Name.MinimapCustomSquare);
        if (tex != null) {
            tex.queueForDeletion();
        }
        tex = new TextureImpl(resizedImg, false);
        this.namedTextures.put(Name.MinimapCustomSquare, tex);
        return tex;
    }

    public TextureImpl getWaypoint() {
        return this.getNamedTexture(Name.Waypoint, "waypoint.png", false);
    }

    public TextureImpl getWaypointEdit() {
        return this.getNamedTexture(Name.WaypointEdit, "waypoint-edit.png", false);
    }

    public TextureImpl getWaypointOffscreen() {
        return this.getNamedTexture(Name.WaypointOffscreen, "waypoint-offscreen.png", false);
    }

    public TextureImpl getDeathpoint() {
        return this.getNamedTexture(Name.Deathpoint, "waypoint-death.png", false);
    }

    public TextureImpl getLogo() {
        return this.getNamedTexture(Name.Logo, "ico/journeymap60.png", false);
    }

    public TextureImpl getPatreonLogo() {
        return this.getNamedTexture(Name.Patreon, "patreon.png", false);
    }

    public TextureImpl getHostileLocator() {
        return this.getNamedTexture(Name.LocatorHostile, "locator-hostile.png", false);
    }

    public TextureImpl getNeutralLocator() {
        return this.getNamedTexture(Name.LocatorNeutral, "locator-neutral.png", false);
    }

    public TextureImpl getOtherLocator() {
        return this.getNamedTexture(Name.LocatorOther, "locator-other.png", false);
    }

    public TextureImpl getPetLocator() {
        return this.getNamedTexture(Name.LocatorPet, "locator-pet.png", false);
    }

    public TextureImpl getPlayerLocator() {
        return this.getNamedTexture(Name.LocatorPlayer, "locator-player.png", false);
    }

    public TextureImpl getPlayerLocatorSmall() {
        return this.getNamedTexture(Name.LocatorPlayerSmall, "locator-player-sm.png", false);
    }

    public TextureImpl getColorPicker() {
        return this.getNamedTexture(Name.ColorPicker, "colorpick.png", true);
    }

    public TextureImpl getUnknownEntity() {
        return this.getNamedTexture(Name.UnknownEntity, "unknown.png", true);
    }

    public TextureImpl getBrick() {
        return this.getNamedTexture(Name.Brick, "brick.png", true);
    }

    public TextureImpl getGrid(Name name) {
        switch (name) {
            case GridCheckers: {
                return this.getNamedTexture(Name.GridCheckers, "grid-checkers.png", true);
            }
            case GridDots: {
                return this.getNamedTexture(Name.GridDots, "grid-dots.png", true);
            }
        }
        return this.getNamedTexture(Name.GridSquares, "grid.png", true);
    }

    public TextureImpl getTileSample(MapType mapType) {
        if (mapType.isNight()) {
            return this.getTileSampleNight();
        }
        if (mapType.isUnderground()) {
            return this.getTileSampleUnderground();
        }
        return this.getTileSampleDay();
    }

    public TextureImpl getTileSampleDay() {
        return this.getNamedTexture(Name.TileSampleDay, "tile-sample-day.png", true);
    }

    public TextureImpl getTileSampleNight() {
        return this.getNamedTexture(Name.TileSampleNight, "tile-sample-night.png", true);
    }

    public TextureImpl getTileSampleUnderground() {
        return this.getNamedTexture(Name.TileSampleUnderground, "tile-sample-underground.png", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getEntityIconTexture(String setName, String iconPath) {
        String texName = String.format("%s/%s", setName, iconPath);
        Map<String, TextureImpl> map = this.entityIcons;
        synchronized (map) {
            String assetPath;
            File parentDir;
            BufferedImage img;
            TextureImpl tex = this.entityIcons.get(texName);
            if ((tex == null || !tex.hasImage() && tex.retainImage) && (img = FileHandler.getIconFromFile(parentDir = IconSetFileHandler.getEntityIconDir(), assetPath = "/assets/journeymap/icon/entity", setName, iconPath, this.getUnknownEntity().getImage())) != null) {
                if (tex != null) {
                    tex.queueForDeletion();
                }
                tex = new TextureImpl(img);
                this.entityIcons.put(texName, tex);
            }
            return tex;
        }
    }

    public TextureImpl getThemeTexture(Theme theme, String iconPath) {
        return this.getThemeTexture(theme, iconPath, 0, 0, false, 1.0f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getThemeTexture(Theme theme, String iconPath, int width, int height, boolean resize, float alpha, boolean retainImage) {
        String texName = String.format("%s/%s", theme.directory, iconPath);
        Map<String, TextureImpl> map = this.themeImages;
        synchronized (map) {
            TextureImpl tex = this.themeImages.get(texName);
            if (tex == null || !tex.hasImage() && tex.retainImage || resize && (width != tex.width || height != tex.height) || tex.alpha != alpha) {
                String assetPath;
                File parentDir = ThemeFileHandler.getThemeIconDir();
                BufferedImage img = FileHandler.getIconFromFile(parentDir, assetPath = "/assets/journeymap/icon/theme", theme.directory, iconPath, null);
                if (img != null) {
                    if ((resize || alpha < 1.0f) && (alpha < 1.0f || img.getWidth() != width || img.getHeight() != height)) {
                        BufferedImage tmp = new BufferedImage(width, height, img.getType());
                        Graphics2D g = tmp.createGraphics();
                        g.setComposite(AlphaComposite.getInstance(3, alpha));
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.drawImage(img, 0, 0, width, height, null);
                        g.dispose();
                        img = tmp;
                    }
                    if (tex != null) {
                        tex.queueForDeletion();
                    }
                    tex = new TextureImpl(img, retainImage);
                    tex.alpha = alpha;
                    this.themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: " + texName);
                    return this.getUnknownEntity();
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getScaledCopy(String texName, TextureImpl original, int width, int height, float alpha) {
        Map<String, TextureImpl> map = this.themeImages;
        synchronized (map) {
            TextureImpl tex = this.themeImages.get(texName);
            if (tex == null || !tex.hasImage() && tex.retainImage || width != tex.width || height != tex.height || tex.alpha != alpha) {
                BufferedImage img = original.getImage();
                if (img != null) {
                    if (alpha < 1.0f || img.getWidth() != width || img.getHeight() != height) {
                        BufferedImage tmp = new BufferedImage(width, height, img.getType());
                        Graphics2D g = tmp.createGraphics();
                        g.setComposite(AlphaComposite.getInstance(3, alpha));
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.drawImage(img, 0, 0, width, height, null);
                        g.dispose();
                        img = tmp;
                    }
                    if (tex != null) {
                        tex.queueForDeletion();
                    }
                    tex = new TextureImpl(img);
                    tex.alpha = alpha;
                    this.themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unable to get scaled image: " + texName);
                    return this.getUnknownEntity();
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImpl getPlayerSkin(final String username) {
        TextureImpl tex = null;
        Map<String, TextureImpl> map = this.playerSkins;
        synchronized (map) {
            tex = this.playerSkins.get(username);
            if (tex != null) {
                return tex;
            }
            BufferedImage blank = new BufferedImage(24, 24, 2);
            tex = new TextureImpl(null, blank, true, false);
            this.playerSkins.put(username, tex);
        }
        final TextureImpl playerSkinTex = tex;
        this.texExec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BufferedImage img = TextureCache.this.downloadSkin(username);
                if (img != null) {
                    BufferedImage scaledImage = new BufferedImage(24, 24, img.getType());
                    Graphics2D g = RegionImageHandler.initRenderingHints(scaledImage.createGraphics());
                    g.drawImage(img, 0, 0, 24, 24, null);
                    g.dispose();
                    playerSkinTex.setImage(scaledImage, true);
                } else {
                    Journeymap.getLogger().warn("Couldn't get a skin at all for " + username);
                }
                return null;
            }
        });
        return playerSkinTex;
    }

    protected BufferedImage downloadSkin(String username) {
        BufferedImage img = null;
        Object conn = null;
        try {
            String skinPath = String.format("http://skins.minecraft.net/MinecraftSkins/%s.png", StringUtils.func_76338_a((String)username));
            img = this.downloadImage(new URL(skinPath));
            if (img == null) {
                img = this.downloadImage(new URL("https://minecraft.net/images/steve.png"));
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().warn("Error getting skin image for " + username + ": " + e.getMessage());
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage downloadImage(URL imageURL) {
        BufferedImage img = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)imageURL.openConnection(Minecraft.func_71410_x().func_110437_J());
            HttpURLConnection.setFollowRedirects(true);
            conn.setInstanceFollowRedirects(true);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(1000);
            conn.connect();
            if (conn.getResponseCode() / 100 == 2) {
                img = ImageIO.read(conn.getInputStream()).getSubimage(8, 8, 8, 8);
            } else {
                Journeymap.getLogger().warn("Bad Response getting image: " + imageURL + " : " + conn.getResponseCode());
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().warn("Error getting skin image: " + imageURL + " : " + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Map<Object, TextureImpl> map = this.namedTextures;
        synchronized (map) {
            ExpireTextureTask.queue(this.namedTextures.values());
            this.namedTextures.clear();
        }
        map = this.entityIcons;
        synchronized (map) {
            ExpireTextureTask.queue(this.entityIcons.values());
            this.entityIcons.clear();
        }
        map = this.themeImages;
        synchronized (map) {
            ExpireTextureTask.queue(this.themeImages.values());
            this.themeImages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeThemeImages() {
        Map<String, TextureImpl> map = this.themeImages;
        synchronized (map) {
            ExpireTextureTask.queue(this.themeImages.values());
            this.themeImages.clear();
        }
    }

    private static class Holder {
        private static final TextureCache INSTANCE = new TextureCache();

        private Holder() {
        }
    }

    public static enum Name {
        MinimapSmallSquare,
        MinimapMediumSquare,
        MinimapLargeSquare,
        MinimapCustomSquare,
        MinimapSmallCircle,
        MinimapLargeCircle,
        Waypoint,
        Deathpoint,
        WaypointOffscreen,
        WaypointEdit,
        Logo,
        Patreon,
        LocatorHostile,
        LocatorNeutral,
        LocatorOther,
        LocatorPet,
        LocatorPlayer,
        LocatorPlayerSmall,
        ColorPicker,
        UnknownEntity,
        GridSquares,
        GridDots,
        GridCheckers,
        Brick,
        TileSampleDay,
        TileSampleNight,
        TileSampleUnderground;

    }
}

