/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.ItemNaturesCompass;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.WorldWorkerManager;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    public final int sampleSpace;
    public final int maxDistance;
    public World world;
    public BiomeGenBase biome;
    public int samples;
    public int nextLength;
    public EnumFacing direction;
    public ItemStack stack;
    public EntityPlayer player;
    public int x;
    public int z;
    public int length;
    public boolean finished;
    public int lastRadiusThreshold;
    public static Set<BiomeGenBase> availableBiomes = new HashSet<BiomeGenBase>();
    public static int oldDimensionId = 0;
    public static int newDimensionId;
    public static boolean completedSearch;

    public BiomeSearchWorker(World world, EntityPlayer player, ItemStack stack, BiomeGenBase biome, int startX, int startZ) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.biome = biome;
        this.x = startX;
        this.z = startZ;
        this.sampleSpace = ConfigHandler.sampleSpace;
        this.maxDistance = ConfigHandler.maxSearchDistance;
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = EnumFacing.UP;
        this.finished = false;
        this.lastRadiusThreshold = 0;
        newDimensionId = world.field_73011_w.field_76574_g;
    }

    public void start() {
        if (this.stack != null && this.stack.func_77973_b() == NaturesCompass.naturesCompass) {
            if (!completedSearch || oldDimensionId != newDimensionId) {
                completedSearch = false;
                oldDimensionId = newDimensionId;
                availableBiomes.clear();
            }
            if (this.maxDistance > 0 && this.sampleSpace > 0) {
                NaturesCompass.logger.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxDistance + " max distance");
                WorldWorkerManager.addWorker(this);
            } else {
                this.finish(false);
            }
        }
    }

    @Override
    public boolean hasWork() {
        return !this.finished && this.getRadius() <= this.maxDistance && this.samples <= ConfigHandler.maxSamples;
    }

    @Override
    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == EnumFacing.NORTH) {
                this.z -= this.sampleSpace;
            } else if (this.direction == EnumFacing.EAST) {
                this.x += this.sampleSpace;
            } else if (this.direction == EnumFacing.SOUTH) {
                this.z += this.sampleSpace;
            } else if (this.direction == EnumFacing.WEST) {
                this.x -= this.sampleSpace;
            }
            BiomeGenBase biomeAtPos = this.world.getBiomeGenForCoordsBody(this.x, this.z);
            availableBiomes.add(biomeAtPos);
            if (biomeAtPos == this.biome) {
                this.finish(true);
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != EnumFacing.UP) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.getClockWise(this.direction);
                } else {
                    this.direction = EnumFacing.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 500 && radius / 500 > this.lastRadiusThreshold) {
                if (this.stack != null && this.stack.func_77973_b() == NaturesCompass.naturesCompass) {
                    ((ItemNaturesCompass)this.stack.func_77973_b()).setSearchRadius(this.stack, this.roundRadius(radius, 500), this.player);
                }
                this.lastRadiusThreshold = radius / 500;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (this.stack != null && this.stack.func_77973_b() == NaturesCompass.naturesCompass) {
            if (found) {
                NaturesCompass.logger.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ItemNaturesCompass)this.stack.func_77973_b()).setFound(this.stack, this.x, this.z, this.player);
            } else {
                NaturesCompass.logger.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ItemNaturesCompass)this.stack.func_77973_b()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 500));
                completedSearch = true;
            }
        } else {
            NaturesCompass.logger.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return BiomeUtils.getDistanceToBiome(this.player, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }

    public EnumFacing getClockWise(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + direction);
    }

    static {
        completedSearch = false;
    }
}

