/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.ColourAndCoords;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.alchemy.energy.TileSegmentedReagentHandler;
import WayofTime.alchemicalWizardry.common.entity.projectile.EntityParticleBeam;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TEReagentConduit
extends TileSegmentedReagentHandler {
    public List<ColourAndCoords> destinationList = new LinkedList<ColourAndCoords>();
    public Map<Reagent, List<Int3>> reagentTargetList = new HashMap<Reagent, List<Int3>>();
    public Map<Reagent, Integer> reagentTankDesignationList = new HashMap<Reagent, Integer>();
    public int tickRate = 20;
    int hasChanged = 0;
    public boolean affectedByRedstone = true;
    public int maxConnextions = 5;
    public int renderCount = 0;

    public TEReagentConduit() {
        this(2, 2000);
    }

    public TEReagentConduit(int numberOfTanks, int size) {
        super(numberOfTanks, size);
    }

    public Int3 getColour() {
        int[] redMap = new int[this.tanks.length];
        int[] greenMap = new int[this.tanks.length];
        int[] blueMap = new int[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            ReagentContainer container = this.tanks[i];
            if (container == null || container.getReagent() == null) continue;
            Reagent reagent = container.getReagent().reagent;
            redMap[i] = reagent.getColourRed();
            greenMap[i] = reagent.getColourGreen();
            blueMap[i] = reagent.getColourBlue();
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < this.tanks.length; ++i) {
            red += redMap[i];
            green += greenMap[i];
            blue += blueMap[i];
        }
        return new Int3(red /= this.tanks.length, green /= this.tanks.length, blue /= this.tanks.length);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("hasChanged", this.hasChanged);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.destinationList.size(); ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            tagList.func_74742_a((NBTBase)this.destinationList.get(i).writeToNBT(savedTag));
        }
        tag.func_74782_a("destinationList", (NBTBase)tagList);
        NBTTagList reagentTagList = new NBTTagList();
        for (Map.Entry entry : this.reagentTargetList.entrySet()) {
            NBTTagCompound savedTag = new NBTTagCompound();
            savedTag.func_74778_a("reagent", ReagentRegistry.getKeyForReagent((Reagent)entry.getKey()));
            NBTTagList coordinateTagList = new NBTTagList();
            for (Int3 coord : (List)entry.getValue()) {
                NBTTagCompound coordinateTag = new NBTTagCompound();
                coord.writeToNBT(coordinateTag);
                coordinateTagList.func_74742_a((NBTBase)coordinateTag);
            }
            savedTag.func_74782_a("coordinateList", (NBTBase)coordinateTagList);
            reagentTagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTargetList", (NBTBase)reagentTagList);
        NBTTagList tankDesignationList = new NBTTagList();
        for (Map.Entry<Reagent, Integer> entry : this.reagentTankDesignationList.entrySet()) {
            NBTTagCompound savedTag = new NBTTagCompound();
            savedTag.func_74778_a("reagent", ReagentRegistry.getKeyForReagent(entry.getKey()));
            savedTag.func_74768_a("integer", entry.getValue().intValue());
            tankDesignationList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("tankDesignationList", (NBTBase)tankDesignationList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.hasChanged = tag.func_74762_e("hasChanged");
        NBTTagList tagList = tag.func_150295_c("destinationList", 10);
        this.destinationList = new LinkedList<ColourAndCoords>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.destinationList.add(ColourAndCoords.readFromNBT(savedTag));
        }
        this.reagentTargetList = new HashMap<Reagent, List<Int3>>();
        NBTTagList reagentTagList = tag.func_150295_c("reagentTargetList", 10);
        for (int i = 0; i < reagentTagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = reagentTagList.func_150305_b(i);
            Reagent reagent = ReagentRegistry.getReagentForKey(savedTag.func_74779_i("reagent"));
            LinkedList<Int3> coordList = new LinkedList<Int3>();
            NBTTagList coordinateList = savedTag.func_150295_c("coordinateList", 10);
            for (int j = 0; j < coordinateList.func_74745_c(); ++j) {
                coordList.add(Int3.readFromNBT(coordinateList.func_150305_b(j)));
            }
            this.reagentTargetList.put(reagent, coordList);
        }
        this.reagentTankDesignationList = new HashMap<Reagent, Integer>();
        NBTTagList tankDesignationList = tag.func_150295_c("tankDesignationList", 10);
        for (int i = 0; i < tankDesignationList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = tankDesignationList.func_150305_b(i);
            this.reagentTankDesignationList.put(ReagentRegistry.getReagentForKey(savedTag.func_74779_i("reagent")), new Integer(savedTag.func_74762_e("integer")));
        }
    }

    public void readClientNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("destinationList", 10);
        this.destinationList = new LinkedList<ColourAndCoords>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound savedTag = tagList.func_150305_b(i);
            this.destinationList.add(ColourAndCoords.readFromNBT(savedTag));
        }
        NBTTagList reagentTagList = tag.func_150295_c("reagentTanks", 10);
        int size = reagentTagList.func_74745_c();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = reagentTagList.func_150305_b(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
    }

    public void writeClientNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.destinationList.size(); ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            tagList.func_74742_a((NBTBase)this.destinationList.get(i).writeToNBT(savedTag));
        }
        tag.func_74782_a("destinationList", (NBTBase)tagList);
        NBTTagList reagentTagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            reagentTagList.func_74742_a((NBTBase)savedTag);
        }
        tag.func_74782_a("reagentTanks", (NBTBase)reagentTagList);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasChanged > 1) {
                this.hasChanged = 1;
            } else if (this.hasChanged == 1) {
                this.hasChanged = 0;
            }
            if (this.field_145850_b.func_72820_D() % 100L == 99L) {
                this.updateColourList();
            }
            if (this.affectedByRedstone && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                return;
            }
            int totalTransfered = 0;
            block0: for (Map.Entry<Reagent, List<Int3>> entry : this.reagentTargetList.entrySet()) {
                for (Int3 coord : entry.getValue()) {
                    int amount;
                    int z;
                    int y;
                    int x;
                    TileEntity tile;
                    int amountLeft;
                    if (totalTransfered >= this.tickRate) continue block0;
                    ReagentStack maxDrainAmount = this.drain(ForgeDirection.UNKNOWN, new ReagentStack(entry.getKey(), this.tickRate - totalTransfered), false);
                    if (maxDrainAmount == null || (amountLeft = maxDrainAmount.amount) <= 0 || !((tile = this.field_145850_b.func_147438_o(x = this.field_145851_c + coord.xCoord, y = this.field_145848_d + coord.yCoord, z = this.field_145849_e + coord.zCoord)) instanceof IReagentHandler) || (amount = Math.min(((IReagentHandler)tile).fill(ForgeDirection.UNKNOWN, maxDrainAmount, false), amountLeft)) <= 0) continue;
                    amountLeft -= amount;
                    totalTransfered += amount;
                    ReagentStack stack = this.drain(ForgeDirection.UNKNOWN, new ReagentStack(entry.getKey(), amount), true);
                    ((IReagentHandler)tile).fill(ForgeDirection.UNKNOWN, stack, true);
                }
            }
        } else {
            if (this.affectedByRedstone && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                return;
            }
            ++this.renderCount;
            if (this.field_145850_b.func_72820_D() % 100L != 0L) {
                return;
            }
            this.sendPlayerStuffs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendPlayerStuffs() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        if (SpellHelper.canPlayerSeeAlchemy((EntityPlayer)player)) {
            for (ColourAndCoords colourSet : this.destinationList) {
                if (!(this.field_145850_b.func_147438_o(this.field_145851_c + colourSet.xCoord, this.field_145848_d + colourSet.yCoord, this.field_145849_e + colourSet.zCoord) instanceof IReagentHandler)) continue;
                EntityParticleBeam beam = new EntityParticleBeam(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                double velocity = Math.sqrt(Math.pow(colourSet.xCoord, 2.0) + Math.pow(colourSet.yCoord, 2.0) + Math.pow(colourSet.zCoord, 2.0));
                double wantedVel = 0.3;
                beam.func_70016_h(wantedVel * (double)colourSet.xCoord / velocity, wantedVel * (double)colourSet.yCoord / velocity, wantedVel * (double)colourSet.zCoord / velocity);
                beam.setColour((float)colourSet.colourRed / 255.0f, (float)colourSet.colourGreen / 255.0f, (float)colourSet.colourBlue / 255.0f);
                beam.setDestination(this.field_145851_c + colourSet.xCoord, this.field_145848_d + colourSet.yCoord, this.field_145849_e + colourSet.zCoord);
                this.field_145850_b.func_72838_d((Entity)beam);
            }
        }
    }

    public void updateColourList() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<ColourAndCoords> newList = this.compileListForReagentTargets(this.reagentTargetList);
        if (newList != null && !newList.equals(this.destinationList)) {
            this.destinationList = newList;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public List<ColourAndCoords> compileListForReagentTargets(Map<Reagent, List<Int3>> map) {
        LinkedList<ColourAndCoords> list = new LinkedList<ColourAndCoords>();
        for (Map.Entry<Reagent, List<Int3>> entry : map.entrySet()) {
            Reagent reagent;
            if (entry.getValue() == null || (reagent = entry.getKey()) == null) continue;
            List<Int3> coords = entry.getValue();
            for (Int3 coord : coords) {
                if (coord == null) continue;
                list.add(new ColourAndCoords(reagent.getColourRed(), reagent.getColourGreen(), reagent.getColourBlue(), reagent.getColourIntensity(), coord.xCoord, coord.yCoord, coord.zCoord));
            }
        }
        return list;
    }

    public boolean addDestinationViaOffset(int red, int green, int blue, int intensity, int xOffset, int yOffset, int zOffset) {
        if (xOffset == 0 && yOffset == 0 && zOffset == 0) {
            return false;
        }
        this.destinationList.add(new ColourAndCoords(red, green, blue, intensity, xOffset, yOffset, zOffset));
        return true;
    }

    public boolean addDestinationViaActual(int red, int green, int blue, int intensity, int x, int y, int z) {
        return this.addDestinationViaOffset(red, green, blue, intensity, x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 90210, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    public boolean addReagentDestinationViaOffset(Reagent reagent, int xOffset, int yOffset, int zOffset) {
        int totalConnections = 0;
        for (Map.Entry<Reagent, List<Int3>> entry : this.reagentTargetList.entrySet()) {
            if (entry.getValue() == null) continue;
            totalConnections += entry.getValue().size();
        }
        if (totalConnections >= this.maxConnextions) {
            return false;
        }
        if (xOffset == 0 && yOffset == 0 && zOffset == 0) {
            return false;
        }
        Int3 newCoord = new Int3(xOffset, yOffset, zOffset);
        if (this.reagentTargetList.containsKey(reagent)) {
            List<Int3> coordList = this.reagentTargetList.get(reagent);
            if (coordList == null) {
                LinkedList<Int3> newCoordList = new LinkedList<Int3>();
                newCoordList.add(newCoord);
                this.reagentTargetList.put(reagent, newCoordList);
            } else {
                coordList.add(newCoord);
            }
            return true;
        }
        LinkedList<Int3> newCoordList = new LinkedList<Int3>();
        newCoordList.add(newCoord);
        this.reagentTargetList.put(reagent, newCoordList);
        return true;
    }

    public boolean addReagentDestinationViaActual(Reagent reagent, int x, int y, int z) {
        return this.addReagentDestinationViaOffset(reagent, x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e);
    }

    public boolean removeReagentDestinationViaOffset(Reagent reagent, int xOffset, int yOffset, int zOffset) {
        List<Int3> coords;
        if (this.reagentTargetList.containsKey(reagent) && (coords = this.reagentTargetList.get(reagent)) != null) {
            Int3 reference = new Int3(xOffset, yOffset, zOffset);
            return coords.remove(reference);
        }
        return false;
    }

    public boolean removeReagentDestinationViaActual(Reagent reagent, int x, int y, int z) {
        return this.removeReagentDestinationViaOffset(reagent, x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e);
    }

    @Override
    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        if (doFill && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.hasChanged = 2;
        }
        return super.fill(from, resource, doFill);
    }

    @Override
    public ReagentStack drain(ForgeDirection from, ReagentStack resource, boolean doDrain) {
        if (doDrain && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.hasChanged = 2;
        }
        return super.drain(from, resource, doDrain);
    }
}

