/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IFluidSink;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logistics.ILogisticsFluidManager;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class LogisticsFluidManager
implements ILogisticsFluidManager {
    @Override
    public Pair<Integer, Integer> getBestReply(FluidStack stack, IRouter sourceRouter, List<Integer> jamList) {
        for (ExitRoute candidateRouter : sourceRouter.getIRoutersByCost()) {
            int amount;
            CoreRoutedPipe pipe;
            if (!candidateRouter.containsFlag(PipeRoutingConnectionType.canRouteTo) || candidateRouter.destination.getSimpleID() == sourceRouter.getSimpleID() || jamList.contains(candidateRouter.destination.getSimpleID()) || candidateRouter.destination.getPipe() == null || !candidateRouter.destination.getPipe().isEnabled() || !((pipe = candidateRouter.destination.getPipe()) instanceof IFluidSink) || (amount = ((IFluidSink)((Object)pipe)).sinkAmount(stack)) <= 0) continue;
            return new Pair<Integer, Integer>(candidateRouter.destination.getSimpleID(), amount);
        }
        return new Pair<Integer, Integer>(0, 0);
    }

    @Override
    public ItemIdentifierStack getFluidContainer(FluidStack stack) {
        ItemStack item = new ItemStack(LogisticsPipes.LogisticsFluidContainer, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        stack.writeToNBT(nbt);
        item.func_77982_d(nbt);
        return ItemIdentifierStack.getFromStack(item);
    }

    @Override
    public FluidStack getFluidFromContainer(ItemIdentifierStack stack) {
        if (stack.makeNormalStack().func_77973_b() instanceof LogisticsFluidContainer && stack.getItem().tag != null) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.getItem().tag);
        }
        return null;
    }

    @Override
    public TreeSet<ItemIdentifierStack> getAvailableFluid(List<ExitRoute> validDestinations) {
        HashMap<FluidIdentifier, Integer> allAvailableItems = new HashMap<FluidIdentifier, Integer>();
        for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideFluids)) continue;
            IProvideFluids provider = (IProvideFluids)((Object)r.destination.getPipe());
            Map<FluidIdentifier, Integer> allItems = provider.getAvailableFluids();
            for (Map.Entry<FluidIdentifier, Integer> liquid : allItems.entrySet()) {
                Integer amount = (Integer)allAvailableItems.get(liquid.getKey());
                if (amount == null) {
                    allAvailableItems.put(liquid.getKey(), liquid.getValue());
                    continue;
                }
                long addition = (long)amount.intValue() + (long)liquid.getValue().intValue();
                if (addition > Integer.MAX_VALUE) {
                    addition = Integer.MAX_VALUE;
                }
                allAvailableItems.put(liquid.getKey(), (int)addition);
            }
        }
        TreeSet<ItemIdentifierStack> itemIdentifierStackList = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry item : allAvailableItems.entrySet()) {
            itemIdentifierStackList.add(new ItemIdentifierStack(((FluidIdentifier)item.getKey()).getItemIdentifier(), (Integer)item.getValue()));
        }
        return itemIdentifierStackList;
    }
}

