/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketEntityUpdate;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketErrorUpdateEntity
extends PacketEntityUpdate
implements IForestryPacketClient {
    private IErrorLogic errorLogic;

    public PacketErrorUpdateEntity() {
    }

    public PacketErrorUpdateEntity(Entity entity, IErrorLogicSource errorLogicSource) {
        super(entity);
        this.errorLogic = errorLogicSource.getErrorLogic();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.errorLogic.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        Entity entity = this.getTarget(Proxies.common.getRenderWorld());
        if (entity instanceof IErrorLogicSource) {
            IErrorLogicSource errorSourceTile = (IErrorLogicSource)entity;
            this.errorLogic = errorSourceTile.getErrorLogic();
            this.errorLogic.readData(data);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.ERROR_UPDATE_ENTITY;
    }
}

