/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.spawn.impl;

import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.spawn.IBiomeDescriptor;
import crazypants.enderzoo.spawn.IBiomeFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public abstract class AbstractBiomeFilter
implements IBiomeFilter {
    protected final List<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
    protected final List<BiomeDictionary.Type> typeExcludes = new ArrayList<BiomeDictionary.Type>();
    protected final List<String> names = new ArrayList<String>();
    protected final List<String> nameExcludes = new ArrayList<String>();

    @Override
    public void addBiomeDescriptor(IBiomeDescriptor biome) {
        if (biome.getType() != null) {
            if (biome.isExclude()) {
                this.typeExcludes.add(biome.getType());
            } else {
                this.types.add(biome.getType());
            }
        } else if (biome.getName() != null) {
            if (biome.isExclude()) {
                this.nameExcludes.add(biome.getName());
            } else {
                this.names.add(biome.getName());
            }
        }
    }

    protected boolean isExcluded(BiomeGenBase candidate) {
        for (BiomeDictionary.Type exType : this.typeExcludes) {
            if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)candidate, (BiomeDictionary.Type)exType)) continue;
            if (Config.spawnConfigPrintDetailedOutput) {
                System.out.print("Excluded " + candidate.field_76791_y + ", ");
            }
            return true;
        }
        for (String exName : this.nameExcludes) {
            if (exName == null || !exName.equals(candidate.field_76791_y)) continue;
            System.out.print("Excluded " + candidate.field_76791_y + ", ");
            return false;
        }
        return false;
    }
}

