/*
 * Decompiled with CFR 0.152.
 */
package kubatech.commands;

import java.math.BigInteger;
import java.util.UUID;
import kubatech.api.helpers.UUIDFinder;
import kubatech.api.tea.TeaNetwork;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandTea
extends CommandBase {
    public String func_71517_b() {
        return "tea";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "tea " + Translations.USAGE.get();
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (p_71515_2_.length < 2) {
            p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
            return;
        }
        UUID player = UUIDFinder.getUUID(p_71515_2_[0]);
        if (player == null) {
            p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.PLAYER_NOT_FOUND.get()));
            return;
        }
        TeaNetwork teaNetwork = TeaNetwork.getNetwork(player);
        if (!p_71515_2_[1].equalsIgnoreCase("get") && p_71515_2_.length < 3) {
            p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
            return;
        }
        switch (p_71515_2_[1].toLowerCase()) {
            case "get": {
                p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.SUCCESS_GET.get(p_71515_2_[0], teaNetwork.teaAmount)));
                break;
            }
            case "set": {
                BigInteger tea;
                try {
                    tea = new BigInteger(p_71515_2_[2]);
                }
                catch (NumberFormatException ex) {
                    p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
                    return;
                }
                teaNetwork.teaAmount = tea;
                teaNetwork.markDirty();
                p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.SUCCESS_SET.get(p_71515_2_[0], teaNetwork.teaAmount)));
                break;
            }
            case "add": {
                BigInteger tea;
                try {
                    tea = new BigInteger(p_71515_2_[2]);
                }
                catch (NumberFormatException ex) {
                    p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
                    return;
                }
                teaNetwork.addTea(tea);
                p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(Translations.SUCCESS_ADD.get(p_71515_2_[0], teaNetwork.teaAmount)));
                break;
            }
        }
    }

    static enum Translations {
        INVALID_OPTION,
        PLAYER_NOT_FOUND,
        SUCCESS_GET,
        SUCCESS_SET,
        SUCCESS_ADD,
        USAGE;

        final String key = "command.tea." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public String get(Object ... args) {
            return StatCollector.func_74837_a((String)this.key, (Object[])args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

