/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.ComponentMenuTarget;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuTargetTank
extends ComponentMenuTarget {
    private static final int RADIO_BUTTON_X = 36;
    private static final int RADIO_BUTTON_Y = 45;
    private static final int RADIO_BUTTON_SPACING = 12;
    private boolean[] onlyFull = new boolean[directions.length];
    private RadioButtonList radioButtons = new RadioButtonList(){

        @Override
        public void updateSelectedOption(int selectedOption) {
            DataWriter dw = ComponentMenuTargetTank.this.getWriterForServerComponentPacket();
            dw.writeData(ComponentMenuTargetTank.this.selectedDirectionId, DataBitHelper.MENU_TARGET_DIRECTION_ID);
            dw.writeData(ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA.getId(), DataBitHelper.MENU_TARGET_TYPE_HEADER);
            dw.writeBoolean(selectedOption == 1);
            PacketHandler.sendDataToServer(dw);
        }
    };
    private static final String NBT_FULL = "ONLY_FULL";

    public ComponentMenuTargetTank(FlowComponent parent) {
        super(parent);
        this.radioButtons.add(new RadioButton(36, 45, Localization.EMPTY_TANK));
        this.radioButtons.add(new RadioButton(36, 57, Localization.FILLED_TANK));
    }

    @Override
    protected ComponentMenuTarget.Button getSecondButton() {
        return new ComponentMenuTarget.Button(27){

            @Override
            protected String getLabel() {
                return ComponentMenuTargetTank.this.useAdvancedSetting(ComponentMenuTargetTank.this.selectedDirectionId) ? Localization.ADVANCED_MODE.toString() : Localization.SIMPLE_MODE.toString();
            }

            @Override
            protected String getMouseOverText() {
                return ComponentMenuTargetTank.this.useAdvancedSetting(ComponentMenuTargetTank.this.selectedDirectionId) ? Localization.SIMPLE_MODE_LONG.toString() : Localization.ADVANCED_MODE_LONG.toString();
            }

            @Override
            protected void onClicked() {
                ComponentMenuTargetTank.this.writeData(ComponentMenuTarget.DataTypeHeader.USE_ADVANCED_SETTING, ComponentMenuTargetTank.this.useAdvancedSetting(ComponentMenuTargetTank.this.selectedDirectionId) ? 0 : 1);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawAdvancedComponent(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
    }

    @Override
    protected void refreshAdvancedComponent() {
        if (this.selectedDirectionId != -1) {
            this.radioButtons.setSelectedOption(this.onlyFull[this.selectedDirectionId] ? 1 : 0);
        }
    }

    @Override
    protected void writeAdvancedSetting(DataWriter dw, int i) {
        dw.writeBoolean(this.onlyFull[i]);
    }

    @Override
    protected void readAdvancedSetting(DataReader dr, int i) {
        this.onlyFull[i] = dr.readBoolean();
    }

    @Override
    protected void copyAdvancedSetting(ComponentMenu menu, int i) {
        ComponentMenuTargetTank menuTarget = (ComponentMenuTargetTank)menu;
        this.onlyFull[i] = menuTarget.onlyFull[i];
    }

    @Override
    protected void onAdvancedClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
    }

    @Override
    protected void loadAdvancedComponent(NBTTagCompound directionTag, int i) {
        this.onlyFull[i] = directionTag.func_74767_n(NBT_FULL);
    }

    @Override
    protected void saveAdvancedComponent(NBTTagCompound directionTag, int i) {
        directionTag.func_74757_a(NBT_FULL, this.onlyFull[i]);
    }

    @Override
    protected void resetAdvancedSetting(int i) {
        this.onlyFull[i] = false;
    }

    @Override
    protected void refreshAdvancedComponentData(ContainerManager container, ComponentMenu newData, int i) {
        ComponentMenuTargetTank newDataTarget = (ComponentMenuTargetTank)newData;
        if (this.onlyFull[i] != newDataTarget.onlyFull[i]) {
            this.onlyFull[i] = newDataTarget.onlyFull[i];
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(i, DataBitHelper.MENU_TARGET_DIRECTION_ID);
            dw.writeData(ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA.getId(), DataBitHelper.MENU_TARGET_TYPE_HEADER);
            dw.writeBoolean(this.onlyFull[i]);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    protected void readAdvancedNetworkComponent(DataReader dr, ComponentMenuTarget.DataTypeHeader header, int i) {
        this.onlyFull[i] = dr.readBoolean();
        this.refreshAdvancedComponent();
    }

    public boolean requireEmpty(int side) {
        return !this.onlyFull[side];
    }
}

