/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.items;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;
import stevesaddons.StevesAddons;
import stevesaddons.naming.NameRegistry;
import stevesaddons.registry.ItemRegistry;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityClusterElement;

public class ItemLabeler
extends Item {
    public ItemLabeler() {
        this.func_77637_a(ModBlocks.creativeTab);
        this.func_77655_b("labeler");
        this.func_111206_d("StevesAddons".toLowerCase() + ":" + "labeler");
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            player.openGui((Object)StevesAddons.INSTANCE, 0, world, player.field_70176_ah, player.field_70162_ai, player.field_70164_aj);
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (ItemLabeler.isValidTile(player.func_130014_f_(), x, y, z)) {
            if (player.func_130014_f_().field_72995_K) {
                String label = ItemLabeler.getLabel(stack);
                if (label.isEmpty()) {
                    if (NameRegistry.removeName(player.func_130014_f_(), x, y, z)) {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"stevesaddons.chat.cleared")));
                    }
                } else {
                    NameRegistry.saveName(player.func_130014_f_(), x, y, z, label);
                    player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"stevesaddons.chat.saved", (Object[])new Object[]{label})));
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isValidTile(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IInventory || te instanceof IFluidHandler || te instanceof IEnergyProvider || te instanceof IEnergyReceiver || te instanceof TileEntityClusterElement;
    }

    public static List<String> getSavedStrings(ItemStack stack) {
        ArrayList<String> result = new ArrayList<String>();
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return result;
        }
        NBTTagList tagList = tagCompound.func_150295_c("saved", 8);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            result.add(tagList.func_150307_f(i));
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemRegistry.defaultLabeler);
    }

    public static void setLabel(ItemStack stack, String string) {
        stack.func_77978_p().func_74778_a("Label", string);
    }

    public static void saveStrings(ItemStack stack, List<String> strings) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        NBTTagList tagList = new NBTTagList();
        for (String string : strings) {
            tagList.func_74742_a((NBTBase)new NBTTagString(string));
        }
        tagCompound.func_74782_a("saved", (NBTBase)tagList);
    }

    public static String getLabel(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74779_i("Label") : "";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extra) {
        super.func_77624_a(stack, player, list, extra);
        String label = ItemLabeler.getLabel(stack);
        if (label.isEmpty()) {
            list.add("Clear Label");
        } else {
            list.add("Label: " + label);
        }
    }
}

