/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import com.rwtema.extrautils.helper.XURandom;
import com.rwtema.extrautils.texture.TextureDerived;
import java.awt.image.BufferedImage;
import net.minecraft.client.resources.data.AnimationMetadataSection;

public class TextureUnstableLava
extends TextureDerived {
    public TextureUnstableLava(String p_i1282_1_, String baseIcon) {
        super(p_i1282_1_, baseIcon, TextureDerived.TextureMapType.BLOCK);
    }

    @Override
    public BufferedImage processImage(BufferedImage image, AnimationMetadataSection animationmetadatasection) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] aint = new int[h * w];
        int[] c = new int[256];
        image.getRGB(0, 0, w, h, aint, 0, w);
        int n1 = 0;
        for (int i = 0; i < aint.length; ++i) {
            if (this.rgb.getAlpha(aint[i]) > 10) {
                aint[i] = this.getLuminosity(aint[i]);
                n1 = Math.max(n1, aint[i]);
                continue;
            }
            aint[i] = 255;
        }
        int v = h / w;
        for (int i = 0; i < aint.length; ++i) {
            int x = i % w;
            int y = (i - x) / w % w;
            int sn = (i - x) / w / w;
            boolean p = true;
            int lum = 256 + (x * 16 / w + y * 16 / w - 16) % 32 * 1 * 2;
            int t = 0;
            while ((lum >= 256 || lum < 240) && t < 100) {
                ++t;
                if (lum >= 256) {
                    lum = 511 - lum;
                }
                if (lum >= 240) continue;
                lum = 480 - lum;
            }
            int col = aint[i];
            int l = col + n1;
            if ((l = 255 - (255 - l) * 2) < 0) {
                l = 0;
            }
            l = 192 + (l >> 2);
            if (XURandom.getInstance().nextInt(3) != 0) {
                l -= XURandom.getInstance().nextInt(4);
            }
            if ((l = l * lum / 255) > 255) {
                l = 255;
            }
            if (l < 128) {
                l = 128;
            }
            aint[i] = 0xFF000000 | l * 65793;
        }
        image.setRGB(0, 0, w, h, aint, 0, w);
        return image;
    }
}

