/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.client.gui.tabs;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Mouse;

public abstract class AbstractTab {
    protected final List<GuiButton> buttonList = new ArrayList<GuiButton>();
    protected final List<GuiLabel> labelList = new ArrayList<GuiLabel>();
    protected final List<GuiElementTextBox> textBoxList = new ArrayList<GuiElementTextBox>();
    protected Minecraft mc;
    protected int width;
    protected int height;
    protected int xSize;
    protected int ySize;
    private int field_146298_h;
    private GuiButton selectedButton;
    private int eventButton;
    private long lastMouseEvent;
    private Slot theSlot;
    protected FontRenderer fontRendererObj;
    protected GuiContainerGC parent;

    public AbstractTab(GuiContainerGC parent, Minecraft mc, int width, int height, int xSize, int ySize) {
        this.setWorldAndResolution(mc, width, height, xSize, ySize);
        this.parent = parent;
    }

    public abstract void initGui();

    public void setWorldAndResolution(Minecraft mc, int width, int height, int xSize, int ySize) {
        this.mc = mc;
        this.fontRendererObj = mc.field_71466_p;
        this.width = width;
        this.height = height;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void drawScreen(int mouseX, int mouseY, float ticks) {
        RenderHelper.func_74518_a();
        for (GuiButton guiButton : this.buttonList) {
            guiButton.func_146112_a(this.mc, mouseX, mouseY);
        }
        for (GuiLabel guiLabel : this.labelList) {
            guiLabel.func_146159_a(this.mc, mouseX, mouseY);
        }
        this.drawExtraScreenElements(mouseX, mouseY, ticks);
        RenderHelper.func_74520_c();
    }

    protected void drawExtraScreenElements(int mouseX, int mouseY, float ticks) {
    }

    public void addButton(GuiButton btn) {
        this.buttonList.add(btn);
    }

    public void addLabel(GuiLabel label) {
        this.labelList.add(label);
    }

    public void addTextBox(GuiElementTextBox box) {
        this.textBoxList.add(box);
        this.buttonList.add((GuiButton)box);
    }

    public boolean actionPerformed(GuiButton btn) {
        return false;
    }

    public void handleMouseInput() {
        int mouseX = Mouse.getEventX() * this.width / this.mc.field_71443_c;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.field_71440_d - 1;
        int eventButton = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            if (this.mc.field_71474_y.field_85185_A && this.field_146298_h++ > 0) {
                return;
            }
            this.eventButton = eventButton;
            this.lastMouseEvent = Minecraft.func_71386_F();
            this.mouseClicked(mouseX, mouseY, this.eventButton);
        } else if (eventButton != -1) {
            if (this.mc.field_71474_y.field_85185_A && --this.field_146298_h > 0) {
                return;
            }
            this.eventButton = -1;
            this.mouseMovedOrUp(mouseX, mouseY, eventButton);
        } else if (this.eventButton != -1 && this.lastMouseEvent > 0L) {
            long l = Minecraft.func_71386_F() - this.lastMouseEvent;
            this.mouseClickMove(mouseX, mouseY, this.eventButton, l);
        }
    }

    protected void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        if (this.selectedButton != null && state == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    protected boolean checkHotbarKeys(int keyCode) {
        if (this.mc.field_71439_g.field_71071_by.func_70445_o() == null && this.theSlot != null) {
            for (int j = 0; j < 9; ++j) {
                if (keyCode != this.mc.field_71474_y.field_151456_ac[j].func_151463_i()) continue;
                this.handleMouseClick(this.theSlot, this.theSlot.field_75222_d, j, 2);
                return true;
            }
        }
        return false;
    }

    protected void handleMouseClick(Slot slotIn, int slotId, int clickedButton, int clickType) {
    }

    public boolean keyTyped(char keyChar, int keyID) {
        if (keyID != 1) {
            for (GuiElementTextBox box : this.textBoxList) {
                if (!box.keyTyped(keyChar, keyID)) continue;
                return true;
            }
        }
        return false;
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (GuiButton guibutton : this.buttonList) {
                if (!guibutton.func_146116_c(this.mc, mouseX, mouseY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this.parent, guibutton, this.buttonList);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.selectedButton = event.button;
                event.button.func_146113_a(this.mc.func_147118_V());
                this.actionPerformed(event.button);
                if (!this.parent.equals(this.mc.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this.parent, event.button, this.buttonList));
            }
        }
    }

    public void onTabActivated() {
    }

    public abstract ResourceLocation getIcon();

    public abstract String getTooltip();

    public String getTooltipDescription() {
        return null;
    }
}

