/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.IMetaBlock;
import de.katzenpapst.amunra.block.SubBlock;
import de.katzenpapst.amunra.block.SubBlockLeaf;
import de.katzenpapst.amunra.item.ItemBlockMulti;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLeafMeta
extends BlockLeaves
implements IMetaBlock {
    public static String[] unlocLeafNames = null;
    protected final Map<String, Integer> nameMetaMap = new HashMap<String, Integer>();
    protected SubBlock[] subBlocksArray = new SubBlock[4];

    public BlockLeafMeta(Material mat, boolean gfxMode) {
        this.func_149713_g(1);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess worldIn, int x, int y, int z) {
        return 0xFFFFFF;
    }

    @Override
    public BlockMetaPair addSubBlock(int meta, SubBlock sb) {
        if (!(sb instanceof SubBlockLeaf)) {
            throw new IllegalArgumentException("SubBlocks need to be instanceof SubBlockLeaf");
        }
        if (meta >= this.subBlocksArray.length || meta < 0) {
            throw new IllegalArgumentException("Meta " + meta + " must be <= " + (this.subBlocksArray.length - 1) + " && >= 0");
        }
        if (this.subBlocksArray[meta] != null) {
            throw new IllegalArgumentException("Meta " + meta + " is already in use");
        }
        if (this.nameMetaMap.get(sb.func_149739_a()) != null) {
            throw new IllegalArgumentException("Name " + sb.func_149739_a() + " is already in use");
        }
        sb.setParent(this);
        this.nameMetaMap.put(sb.func_149739_a(), meta);
        this.subBlocksArray[meta] = sb;
        return new BlockMetaPair((Block)this, (byte)meta);
    }

    @Override
    public int getMetaByName(String name) {
        Integer i = this.nameMetaMap.get(name);
        if (i == null) {
            throw new IllegalArgumentException("Subblock " + name + " doesn't exist");
        }
        return i;
    }

    @Override
    public SubBlock getSubBlock(int meta) {
        meta = this.getDistinctionMeta(meta);
        return this.subBlocksArray[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.func_149662_c()) {
            return ((SubBlockLeaf)this.getSubBlock(meta)).getOpaqueIcon(side);
        }
        return this.getSubBlock(meta).func_149691_a(side, 0);
    }

    public String[] func_150125_e() {
        if (unlocLeafNames == null) {
            unlocLeafNames = new String[this.nameMetaMap.size()];
            for (Map.Entry<String, Integer> entry : this.nameMetaMap.entrySet()) {
                String key = entry.getKey();
                int value = entry.getValue();
                BlockLeafMeta.unlocLeafNames[value] = key;
            }
        }
        return unlocLeafNames;
    }

    @Override
    public void register() {
        GameRegistry.registerBlock((Block)this, ItemBlockMulti.class, (String)this.func_149739_a());
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            SubBlock sb = this.subBlocksArray[i];
            if (sb == null) continue;
            this.setHarvestLevel(sb.getHarvestTool(0), sb.getHarvestLevel(0), i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (SubBlock sb : this.subBlocksArray) {
            if (sb == null) continue;
            sb.func_149651_a(reg);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return AmunRa.arTab;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb.dropsSelf()) {
            return Item.func_150898_a((Block)this);
        }
        return sb.func_149650_a(0, random, fortune);
    }

    public int func_149692_a(int meta) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb.dropsSelf()) {
            return meta;
        }
        return sb.func_149692_a(0);
    }

    public int func_149643_k(World worldIn, int x, int y, int z) {
        return worldIn.func_72805_g(x, y, z);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        SubBlock sb = this.getSubBlock(meta);
        if (sb.dropsSelf()) {
            return 1;
        }
        return sb.quantityDropped(meta, fortune, random);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            if (this.subBlocksArray[i] == null) continue;
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z) & 3;
        if (this.getSubBlock(meta) != null) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.getDistinctionMeta(meta));
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    public boolean func_149655_b(IBlockAccess worldIn, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess worldIn, int x, int y, int z, int side) {
        Block block = worldIn.func_147439_a(x, y, z);
        if (!this.func_149662_c() && block == this) {
            return true;
        }
        return super.func_149646_a(worldIn, x, y, z, side);
    }

    public boolean func_149686_d() {
        return this.func_149662_c();
    }

    @Override
    public String getUnlocalizedSubBlockName(int meta) {
        return this.getSubBlock(meta).func_149739_a();
    }

    @Override
    public int getNumPossibleSubBlocks() {
        return 4;
    }

    public int func_149660_a(World worldIn, int x, int y, int z, int side, float subX, float subY, float subZ, int meta) {
        return this.getSubBlock(meta).func_149660_a(worldIn, x, y, z, side, subX, subY, subZ, meta);
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        return this.getSubBlock(metadata).getExpDrop(world, 0, fortune);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        int meta = worldIn.func_72805_g(x, y, z);
        this.getSubBlock(meta).func_149695_a(worldIn, x, y, z, neighbor);
        super.func_149695_a(worldIn, x, y, z, neighbor);
    }
}

