/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.integrations.pack;

import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;

public abstract class Pack {
    private String packName;
    private String packIcon;
    private String packType;

    public boolean isEnabled() {
        return true;
    }

    public abstract boolean load();

    public String getPackName() {
        return this.packName;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }

    public boolean hasPackName() {
        return !StringUtils.isNullOrEmpty(this.packName);
    }

    public String getPackIcon() {
        return this.hasPackIcon() ? StringUtils.formatAsIcon(this.packIcon) : "";
    }

    public void setPackIcon(String packIcon) {
        this.packIcon = packIcon;
    }

    public boolean hasPackIcon() {
        return !StringUtils.isNullOrEmpty(this.packIcon);
    }

    public void setPackData(String packName, String packIcon) {
        this.setPackName(packName);
        this.setPackIcon(packIcon);
    }

    public void setPackData(String packName) {
        this.setPackData(packName, packName);
    }

    public String getPackType() {
        return this.packType;
    }

    public void setPackType(String packType) {
        this.packType = packType;
    }

    public boolean hasPackType() {
        return !StringUtils.isNullOrEmpty(this.packType);
    }

    protected boolean showException(Exception ex) {
        return CommandUtils.isVerboseMode() || ex.getClass() != FileNotFoundException.class && ex.getClass() != NoSuchFileException.class;
    }
}

