/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.LockObject;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.TimeUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Random;

public class SystemUtils {
    public static final Random RANDOM = new Random();
    public static final int MINIMUM_REFRESH_RATE = 2;
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final boolean IS_LINUX = OS_NAME.startsWith("Linux") || OS_NAME.startsWith("LINUX");
    public static final boolean IS_MAC = OS_NAME.startsWith("Mac");
    public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean IS_64_BIT = OS_ARCH.contains("amd64") || OS_ARCH.contains("x86_64");
    public final LockObject TICK_LOCK;
    public int TIMER;
    public boolean HAS_LOADED;
    public boolean HAS_GAME_LOADED;
    public boolean IS_GAME_CLOSING;
    public Instant CURRENT_INSTANT;
    private boolean isTiming;
    private boolean refreshedCallbacks;
    private Instant BEGINNING_INSTANT;
    private long ELAPSED_TIME;
    private long LAST_TICKED;

    public SystemUtils() {
        block2: {
            this.TICK_LOCK = new LockObject();
            this.TIMER = 0;
            this.HAS_LOADED = false;
            this.HAS_GAME_LOADED = false;
            this.IS_GAME_CLOSING = false;
            this.isTiming = false;
            this.refreshedCallbacks = false;
            try {
                this.CURRENT_INSTANT = TimeUtils.getCurrentTime();
                this.ELAPSED_TIME = 0L;
                this.TICK_LOCK.unlock();
            }
            catch (Exception ex) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.system", new Object[0]), new Object[0]);
                if (!CommandUtils.isVerboseMode()) break block2;
                ex.printStackTrace();
            }
        }
    }

    public static boolean browseWithSystem(String cmd) {
        if (IS_LINUX) {
            if (SystemUtils.isXDG() && SystemUtils.runCommand("xdg-open", "%s", cmd)) {
                return true;
            }
            if (SystemUtils.isKDE() && SystemUtils.runCommand("kde-open", "%s", cmd)) {
                return true;
            }
            if (SystemUtils.isGNOME() && SystemUtils.runCommand("gnome-open", "%s", cmd)) {
                return true;
            }
            if (SystemUtils.runCommand("kde-open", "%s", cmd)) {
                return true;
            }
            if (SystemUtils.runCommand("gnome-open", "%s", cmd)) {
                return true;
            }
        }
        if (IS_MAC && SystemUtils.runCommand("open", "%s", cmd)) {
            return true;
        }
        return IS_WINDOWS && SystemUtils.runCommand("explorer", "%s", cmd);
    }

    private static boolean runCommand(String command, String args, String file) {
        ModUtils.LOG.debugInfo("Trying to exec: [cmd=\"%s\", args=\"%s\", file=\"%s\"]", command, args, file);
        String[] parts = SystemUtils.prepareCommand(command, args, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    ModUtils.LOG.debugError("Process ended immediately.", new Object[0]);
                } else {
                    ModUtils.LOG.debugError("Process crashed.", new Object[0]);
                }
                return false;
            }
            catch (IllegalThreadStateException itse) {
                ModUtils.LOG.debugError("Process is running.", new Object[0]);
                return true;
            }
        }
        catch (IOException e) {
            ModUtils.LOG.debugError("Error running command.", e);
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        List<String> parts = StringUtils.newArrayList();
        parts.add(command);
        if (args != null) {
            for (String s : args.split(" ")) {
                s = String.format(s, file);
                parts.add(s.trim());
            }
        }
        return parts.toArray(new String[0]);
    }

    public static boolean isXDG() {
        String xdgSessionId = System.getenv("XDG_SESSION_ID");
        return xdgSessionId != null && !xdgSessionId.isEmpty();
    }

    public static boolean isGNOME() {
        String gdmSession = System.getenv("GDMSESSION");
        return gdmSession != null && gdmSession.toLowerCase().contains("gnome");
    }

    public static boolean isKDE() {
        String gdmSession = System.getenv("GDMSESSION");
        return gdmSession != null && gdmSession.toLowerCase().contains("kde");
    }

    void onTick() {
        this.ELAPSED_TIME = TimeUtils.getDurationFrom(this.CURRENT_INSTANT).getSeconds();
        if (this.TIMER > 0) {
            if (!this.isTiming) {
                this.startTimer();
            } else {
                this.checkTimer();
            }
        } else if (this.isTiming) {
            this.isTiming = false;
        }
        if (this.LAST_TICKED != this.ELAPSED_TIME && this.ELAPSED_TIME % (long)this.getRefreshRate() == 0L && !this.refreshedCallbacks) {
            if (!this.HAS_LOADED && CraftPresence.CLIENT.STATUS == DiscordStatus.Ready) {
                this.HAS_LOADED = true;
            }
            if (this.HAS_LOADED && !this.HAS_GAME_LOADED && CraftPresence.instance.field_3816 != null) {
                this.HAS_GAME_LOADED = true;
            }
            this.refreshedCallbacks = true;
        }
    }

    void postTick() {
        if (this.refreshedCallbacks) {
            try {
                this.TICK_LOCK.waitForUnlock(() -> {
                    CraftPresence.CLIENT.updatePresence();
                    this.LAST_TICKED = this.ELAPSED_TIME;
                    this.refreshedCallbacks = false;
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private int getRefreshRate() {
        int result = CraftPresence.CONFIG.advancedSettings.refreshRate;
        if (result < 2) {
            result = 2;
        }
        return result;
    }

    private void startTimer() {
        this.BEGINNING_INSTANT = TimeUtils.getCurrentTime().plusSeconds(this.TIMER);
        this.isTiming = true;
    }

    private void checkTimer() {
        if (this.TIMER > 0) {
            long remainingTime = this.BEGINNING_INSTANT.getEpochSecond() - TimeUtils.getCurrentTime().getEpochSecond();
            this.TIMER = (int)remainingTime;
        }
    }
}

