/*
 * Decompiled with CFR 0.152.
 */
package external.com.jagrosh.discordipc.entities.pipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import external.com.jagrosh.discordipc.IPCClient;
import external.com.jagrosh.discordipc.IPCListener;
import external.com.jagrosh.discordipc.entities.Callback;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import external.com.jagrosh.discordipc.entities.Packet;
import external.com.jagrosh.discordipc.entities.User;
import external.com.jagrosh.discordipc.entities.pipe.MacPipe;
import external.com.jagrosh.discordipc.entities.pipe.PipeStatus;
import external.com.jagrosh.discordipc.entities.pipe.UnixPipe;
import external.com.jagrosh.discordipc.entities.pipe.WindowsPipe;
import external.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import external.org.slf4j.Logger;
import external.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public abstract class Pipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pipe.class);
    private static final int VERSION = 1;
    private static final String[] unixPaths = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};
    private static final String[] unixFolderPaths = new String[]{"/snap.discord", "/app/com.discordapp.Discord"};
    final IPCClient ipcClient;
    private final HashMap<String, Callback> callbacks;
    PipeStatus status = PipeStatus.CONNECTING;
    IPCListener listener;
    private DiscordBuild build;
    private User currentUser;

    Pipe(IPCClient ipcClient, HashMap<String, Callback> callbacks) {
        this.ipcClient = ipcClient;
        this.callbacks = callbacks;
    }

    public static Pipe openPipe(IPCClient ipcClient, long clientId, HashMap<String, Callback> callbacks, DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        int i;
        if (preferredOrder == null || preferredOrder.length == 0) {
            preferredOrder = new DiscordBuild[]{DiscordBuild.ANY};
        }
        Pipe pipe = null;
        Pipe[] open = new Pipe[DiscordBuild.values().length];
        for (i = 0; i < 10; ++i) {
            String location = Pipe.getPipeLocation(i);
            if (ipcClient.isDebugMode()) {
                ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Searching for IPC Pipe: \"%s\"", location));
            }
            try {
                File fileLocation = new File(location);
                if (fileLocation.exists()) {
                    if (ipcClient.isDebugMode()) {
                        ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Found valid file, attempting connection to IPC: \"%s\"", location));
                    }
                    if ((pipe = Pipe.createPipe(ipcClient, callbacks, fileLocation)) == null) continue;
                    JsonObject finalObject = new JsonObject();
                    finalObject.addProperty("v", (Number)1);
                    finalObject.addProperty("client_id", Long.toString(clientId));
                    pipe.send(Packet.OpCode.HANDSHAKE, finalObject);
                    Packet p = pipe.read();
                    JsonObject parsedData = p.getJson();
                    JsonObject data = parsedData.getAsJsonObject("data");
                    JsonObject userData = data.getAsJsonObject("user");
                    pipe.build = DiscordBuild.from(data.getAsJsonObject("config").get("api_endpoint").getAsString());
                    pipe.currentUser = new User(userData.getAsJsonPrimitive("username").getAsString(), userData.getAsJsonPrimitive("discriminator").getAsString(), Long.parseLong(userData.getAsJsonPrimitive("id").getAsString()), userData.has("avatar") && userData.get("avatar").isJsonPrimitive() ? userData.getAsJsonPrimitive("avatar").getAsString() : null);
                    if (ipcClient.isDebugMode()) {
                        ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Found a valid client (%s) with packet: %s", pipe.build.name(), p));
                        ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Found a valid user (%s) with id: %s", pipe.currentUser.getName(), pipe.currentUser.getId()));
                    }
                    if (pipe.build == preferredOrder[0] || DiscordBuild.ANY == preferredOrder[0]) {
                        if (!ipcClient.isDebugMode()) break;
                        ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Found preferred client: %s", pipe.build.name()));
                        break;
                    }
                    open[pipe.build.ordinal()] = pipe;
                    open[DiscordBuild.ANY.ordinal()] = pipe;
                    pipe.build = null;
                    pipe = null;
                    continue;
                }
                if (!ipcClient.isDebugMode()) continue;
                ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Unable to locate IPC Pipe: \"%s\"", location));
                continue;
            }
            catch (JsonParseException | IOException ex) {
                pipe = null;
            }
        }
        if (pipe == null) {
            for (i = 1; i < preferredOrder.length; ++i) {
                DiscordBuild cb = preferredOrder[i];
                if (ipcClient.isDebugMode()) {
                    ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Looking for client build: %s", cb.name()));
                }
                if (open[cb.ordinal()] == null) continue;
                pipe = open[cb.ordinal()];
                open[cb.ordinal()] = null;
                if (cb == DiscordBuild.ANY) {
                    for (int k = 0; k < open.length; ++k) {
                        if (open[k] != pipe) continue;
                        pipe.build = DiscordBuild.values()[k];
                        open[k] = null;
                    }
                } else {
                    pipe.build = cb;
                }
                if (!ipcClient.isDebugMode()) break;
                ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Found preferred client: %s", pipe.build.name()));
                break;
            }
            if (pipe == null) {
                throw new NoDiscordClientException();
            }
        }
        for (i = 0; i < open.length; ++i) {
            if (i == DiscordBuild.ANY.ordinal() || open[i] == null) continue;
            try {
                open[i].close();
                continue;
            }
            catch (IOException ex) {
                if (!ipcClient.isDebugMode()) continue;
                ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Failed to close an open IPC pipe: %s", ex));
            }
        }
        pipe.status = PipeStatus.CONNECTED;
        return pipe;
    }

    private static Pipe createPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, File location) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return new WindowsPipe(ipcClient, callbacks, location);
        }
        if (osName.contains("linux") || osName.contains("mac")) {
            try {
                return osName.contains("mac") ? new MacPipe(ipcClient, callbacks, location) : new UnixPipe(ipcClient, callbacks, location);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported OS: " + osName);
    }

    private static String generateNonce() {
        return UUID.randomUUID().toString();
    }

    private static String getPipeLocation(int index) {
        String str2;
        String tmpPath = null;
        String pipePath = "discord-ipc-" + index;
        if (System.getProperty("os.name").contains("Win")) {
            return "\\\\?\\pipe\\" + pipePath;
        }
        String[] stringArray = unixPaths;
        int n = stringArray.length;
        for (int i = 0; i < n && (tmpPath = System.getenv(str2 = stringArray[i])) == null; ++i) {
        }
        if (tmpPath == null) {
            tmpPath = "/tmp";
        }
        for (String str2 : unixFolderPaths) {
            String folderPath = tmpPath + str2;
            File folderFile = new File(folderPath);
            if (!folderFile.exists() || !folderFile.isDirectory() || folderFile.list().length <= 0) continue;
            tmpPath = folderPath;
            break;
        }
        return tmpPath + "/" + pipePath;
    }

    public void send(Packet.OpCode op, JsonObject data, Callback callback) {
        try {
            String nonce = Pipe.generateNonce();
            data.addProperty("nonce", nonce);
            Packet p = new Packet(op, data, this.ipcClient.getEncoding());
            if (callback != null && !callback.isEmpty()) {
                this.callbacks.put(nonce, callback);
            }
            this.write(p.toBytes());
            if (this.ipcClient.isDebugMode()) {
                this.ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Sent packet: %s", p.toDecodedString()));
            }
            if (this.listener != null) {
                this.listener.onPacketSent(this.ipcClient, p);
            }
        }
        catch (IOException ex) {
            this.ipcClient.getCurrentLogger(LOGGER).error("Encountered an IOException while sending a packet and disconnected!");
            this.status = PipeStatus.DISCONNECTED;
        }
    }

    public void send(Packet.OpCode op, JsonObject data) {
        this.send(op, data, null);
    }

    public Packet receive(Packet.OpCode op, byte[] data) {
        JsonObject packetData = new JsonParser().parse(new String(data)).getAsJsonObject();
        Packet p = new Packet(op, packetData, this.ipcClient.getEncoding());
        if (this.ipcClient.isDebugMode()) {
            this.ipcClient.getCurrentLogger(LOGGER).info(String.format("[DEBUG] Received packet: %s", p));
        }
        if (this.listener != null) {
            this.listener.onPacketReceived(this.ipcClient, p);
        }
        return p;
    }

    public abstract Packet read() throws IOException, JsonParseException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void registerApp(String var1, String var2);

    public abstract void registerSteamGame(String var1, String var2);

    public PipeStatus getStatus() {
        return this.status;
    }

    public void setStatus(PipeStatus status) {
        this.status = status;
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
    }

    public abstract void close() throws IOException;

    public DiscordBuild getDiscordBuild() {
        return this.build;
    }

    public User getCurrentUser() {
        return this.currentUser;
    }
}

