/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.block;

import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ICagedLadderConnectable;
import com.thecodewarrior.catwalks.ICustomLadder;
import com.thecodewarrior.catwalks.item.ItemCautionTape;
import com.thecodewarrior.catwalks.item.ItemRopeLight;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCagedLadder
extends Block
implements ICustomLadder,
ICagedLadderConnectable {
    RayTracer rayTracer = new RayTracer();
    public ForgeDirection direction;
    public boolean lights;
    public boolean isBottomOpen;
    public boolean tape;
    static IIcon inventory_bottom;
    static IIcon inventory_side;
    static IIcon inventory_front;
    static IIcon inventory_ladder;
    public static Map<TextureSide, Map<TextureType, IIcon>> textures;
    public static IIcon landing;
    public static IIcon landing_tape;
    public static IIcon transparent;
    public Map<RelativeSide, Cuboid6> closed = new HashMap<RelativeSide, Cuboid6>();
    public Map<RelativeSide, Cuboid6> open = new HashMap<RelativeSide, Cuboid6>();

    public BlockCagedLadder(ForgeDirection direction, boolean lights, boolean bottom, boolean tape) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        float px = 0.0625f;
        this.func_149676_a(px, 0.0f, px, 1.0f - px, 1.0f, 1.0f - px);
        this.func_149663_c("caged_ladder");
        this.func_149672_a(CatwalkMod.ladderSounds);
        if (!(direction != ForgeDirection.NORTH || lights || bottom || tape)) {
            this.func_149647_a(CatwalkMod.catwalkTab);
        }
        this.setHarvestLevel("wrench", 0);
        this.setHarvestLevel("pickaxe", 0);
        this.lights = lights;
        this.direction = direction;
        this.isBottomOpen = bottom;
        this.tape = tape;
        this.initHitBoxes();
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase e, ItemStack s) {
        int l = MathHelper.func_76128_c((double)((double)(e.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ForgeDirection d = ForgeDirection.NORTH;
        switch (l) {
            case 0: {
                d = ForgeDirection.SOUTH;
                break;
            }
            case 1: {
                d = ForgeDirection.EAST;
                break;
            }
            case 2: {
                d = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                d = ForgeDirection.WEST;
            }
        }
        this.updateIdData(w, x, y, z, d, this.lights, this.isBottomOpen, this.tape);
        this.updateNeighborSides(w, x, y, z, true);
    }

    public void func_149664_b(World w, int x, int y, int z, int meta) {
        this.updateNeighborSides(w, x, y, z, false);
    }

    public void func_149723_a(World w, int x, int y, int z, Explosion e) {
        this.updateNeighborSides(w, x, y, z, false);
    }

    public void updateNeighborSides(World world, int x, int y, int z, boolean self) {
        Block b = world.func_147439_a(x, y + 1, z);
        if (b instanceof BlockCagedLadder) {
            ((BlockCagedLadder)b).updateBottom(world, x, y + 1, z);
        }
        if (self) {
            this.updateBottom(world, x, y, z);
        }
    }

    public void updateBottom(World world, int x, int y, int z) {
        ForgeDirection direction = ((BlockCagedLadder)world.func_147439_a((int)x, (int)y, (int)z)).direction;
        if (world.func_147439_a(x, y - 1, z) instanceof BlockCagedLadder) {
            this.updateIdData(world, x, y, z, direction, this.lights, true, this.tape);
        } else {
            this.updateIdData(world, x, y, z, direction, this.lights, false, this.tape);
        }
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        if (player.func_70694_bm() != null) {
            boolean shouldBeSoft = false;
            if (CatwalkUtil.isHoldingWrench(player)) {
                shouldBeSoft = true;
            }
            if (shouldBeSoft) {
                hardness = this.field_149782_v / 10.0f;
            }
        }
        return player.getBreakSpeed((Block)this, false, metadata, x, y, z) / hardness / 30.0f;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (CatwalkUtil.isHoldingWrench(player) && player.func_70093_af()) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            for (ItemStack s : drops) {
                CatwalkUtil.giveItemToPlayer(player, s);
            }
            this.updateNeighborSides(world, x, y, z, false);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int blockSide, float hitX, float hitY, float hitZ) {
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        RelativeSide side = RelativeSide.TOP;
        if (hit != null) {
            side = (RelativeSide)((Object)((ExtendedMOP)hit).data);
        }
        ItemStack handStack = player.func_71045_bC();
        if (CatwalkUtil.isHoldingWrench(player) && !player.func_70093_af()) {
            this.updateOpenData(world, x, y, z, side, !this.isOpen(side, world.func_72805_g(x, y, z)));
        }
        if (handStack != null) {
            Item item = handStack.func_77973_b();
            boolean use = false;
            if (item instanceof ItemRopeLight && !this.lights) {
                this.updateIdData(world, x, y, z, this.direction, true, this.isBottomOpen, this.tape);
                use = true;
            }
            if (item instanceof ItemCautionTape && !this.tape) {
                this.updateIdData(world, x, y, z, this.direction, this.lights, this.isBottomOpen, true);
                use = true;
            }
            if (use && !player.field_71075_bZ.field_75098_d) {
                --handStack.field_77994_a;
            }
        }
        if (player.func_70093_af()) {
            if (this.lights && (handStack == null || handStack.func_77973_b() == CatwalkMod.itemRopeLight)) {
                if (!world.field_72995_K) {
                    CatwalkUtil.giveItemToPlayer(player, new ItemStack(CatwalkMod.itemRopeLight, 1));
                    this.updateIdData(world, x, y, z, this.direction, false, this.isBottomOpen, this.tape);
                }
            } else if (this.tape && (handStack == null || handStack.func_77973_b() == CatwalkMod.itemCautionTape) && !world.field_72995_K) {
                CatwalkUtil.giveItemToPlayer(player, new ItemStack(CatwalkMod.itemCautionTape, 1));
                this.updateIdData(world, x, y, z, this.direction, this.lights, this.isBottomOpen, false);
            }
        }
        return false;
    }

    public void initHitBoxes() {
        double in = 0.03125;
        double out = 0.09375;
        this.closed.put(RelativeSide.FDtoRS(ForgeDirection.NORTH, this.direction), new Cuboid6(in, 0.0, in, 1.0 - in, 1.0, out));
        this.closed.put(RelativeSide.FDtoRS(ForgeDirection.SOUTH, this.direction), new Cuboid6(in, 0.0, 1.0 - out, 1.0 - in, 1.0, 1.0 - in));
        this.closed.put(RelativeSide.FDtoRS(ForgeDirection.WEST, this.direction), new Cuboid6(in, 0.0, in, out, 1.0, 1.0 - in));
        this.closed.put(RelativeSide.FDtoRS(ForgeDirection.EAST, this.direction), new Cuboid6(1.0 - in, 0.0, in, 1.0 - out, 1.0, 1.0 - in));
        this.closed.put(RelativeSide.FDtoRS(ForgeDirection.DOWN, this.direction), new Cuboid6(in, 0.0, in, 1.0 - in, out, 1.0 - in));
        this.closed.put(RelativeSide.FDtoRS(ForgeDirection.UP, this.direction), new Cuboid6(in, 1.0 - out, in, 1.0 - in, 1.0, 1.0 - in));
        this.open.put(RelativeSide.FRONT, this.getOpenHighlightCuboid(this.open, RelativeSide.FRONT, this.direction));
        this.open.put(RelativeSide.LEFT, this.getOpenHighlightCuboid(this.open, RelativeSide.LEFT, this.direction));
        this.open.put(RelativeSide.RIGHT, this.getOpenHighlightCuboid(this.open, RelativeSide.RIGHT, this.direction));
        this.open.put(RelativeSide.LADDER, this.getOpenHighlightCuboid(this.open, RelativeSide.LADDER, this.direction));
        this.open.put(RelativeSide.BOTTOM, this.getOpenHighlightCuboid(this.open, RelativeSide.BOTTOM, this.direction));
        this.open.put(RelativeSide.TOP, this.getOpenHighlightCuboid(this.open, RelativeSide.TOP, this.direction));
    }

    public Cuboid6 getOpenHighlightCuboid(Map<RelativeSide, Cuboid6> map, RelativeSide side, ForgeDirection facing) {
        double sub = 0.6875;
        double frontSub = sub / 2.0;
        Cuboid6 cuboid = this.closed.get((Object)side).copy();
        if (side == RelativeSide.TOP) {
            cuboid.min.x += frontSub;
            cuboid.min.z += frontSub;
            cuboid.max.x -= frontSub;
            cuboid.max.z -= frontSub;
        } else if (side != RelativeSide.FRONT && side != RelativeSide.LADDER) {
            if (facing.offsetX < 0) {
                cuboid.min.x += sub;
            }
            if (facing.offsetX > 0) {
                cuboid.max.x -= sub;
            }
            if (facing.offsetZ < 0) {
                cuboid.max.z -= sub;
            }
            if (facing.offsetZ > 0) {
                cuboid.min.z += sub;
            }
        } else {
            if (facing.offsetX != 0) {
                cuboid.min.z += frontSub;
                cuboid.max.z -= frontSub;
            }
            if (facing.offsetZ != 0) {
                cuboid.min.x += frontSub;
                cuboid.max.x -= frontSub;
            }
        }
        return cuboid;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return this.collisionRayTrace(world, x, y, z, CatwalkMod.proxy.getPlayerLooking(start, end), start, end);
    }

    public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, EntityPlayer player, Vec3 start, Vec3 end) {
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        boolean hasWrench = true;
        if (player != null) {
            hasWrench = CatwalkUtil.isHoldingWrench(player);
        }
        float ym = 1.0f;
        float px = 0.0625f;
        float px2 = 2.0f * px;
        float outsideDistance = 0.03125f;
        float insideDistance = 0.09375f;
        float out = px / 2.0f;
        float in = out + px;
        int meta = world.func_72805_g(x, y, z);
        if (!(world.func_147439_a(x, y + 1, z) instanceof BlockCagedLadder)) {
            this.addToList(x, y, z, cuboids, (Object)RelativeSide.TOP, this.open.get((Object)RelativeSide.TOP));
        }
        for (RelativeSide rs : RelativeSide.values()) {
            if (rs == RelativeSide.TOP) continue;
            if (this.isOpen(rs, meta)) {
                if (!hasWrench) continue;
                this.addToList(x, y, z, cuboids, (Object)rs, this.open.get((Object)rs));
                continue;
            }
            this.addToList(x, y, z, cuboids, (Object)rs, this.closed.get((Object)rs));
        }
        ExtendedMOP mop = (ExtendedMOP)this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), cuboids, new BlockCoord(x, y, z), (Block)this);
        if (mop != null && mop.field_72310_e == RelativeSide.RStoFD((RelativeSide)((Object)mop.data), this.direction).getOpposite().ordinal()) {
            mop.field_72310_e = ForgeDirection.getOrientation((int)mop.field_72310_e).getOpposite().ordinal();
        }
        return mop;
    }

    public void addToList(int x, int y, int z, List<IndexedCuboid6> list, Object data, Cuboid6 cuboid) {
        list.add(new IndexedCuboid6(data, new Cuboid6((double)x + cuboid.min.x, (double)y + cuboid.min.y, (double)z + cuboid.min.z, (double)x + cuboid.max.x, (double)y + cuboid.max.y, (double)z + cuboid.max.z)));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        World world = event.player.field_70170_p;
        MovingObjectPosition mop = event.target;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == this) {
            RayTracer.retraceBlock((World)world, (EntityPlayer)event.player, (int)mop.field_72311_b, (int)mop.field_72312_c, (int)mop.field_72309_d);
        }
    }

    public void func_149651_a(IIconRegister reg) {
        if (this != CatwalkMod.defaultLadder) {
            return;
        }
        transparent = reg.func_94245_a("catwalks:transparent");
        inventory_bottom = reg.func_94245_a("catwalks:inventory/ladder_bottom");
        inventory_front = reg.func_94245_a("catwalks:inventory/ladder_front");
        inventory_side = reg.func_94245_a("catwalks:inventory/ladder_side");
        inventory_ladder = reg.func_94245_a("catwalks:inventory/ladder_ladder");
        textures = new HashMap<TextureSide, Map<TextureType, IIcon>>();
        for (TextureSide side : TextureSide.values()) {
            HashMap<TextureType, IIcon> sideMap = new HashMap<TextureType, IIcon>();
            textures.put(side, sideMap);
            for (TextureType type : TextureType.values()) {
                IIcon icon = reg.func_94245_a("catwalks:ladder/" + side.filename + "/" + type.filename);
                sideMap.put(type, icon);
            }
        }
        landing = reg.func_94245_a("catwalks:ladder/landing");
        landing_tape = reg.func_94245_a("catwalks:ladder/landing_tape");
    }

    public IIcon func_149691_a(int _side, int meta) {
        ForgeDirection side;
        RelativeSide dir;
        boolean isInventory = false;
        if (_side >= 100) {
            _side -= 100;
            isInventory = true;
        }
        if ((dir = RelativeSide.FDtoRS(side = ForgeDirection.getOrientation((int)_side), this.direction)) == RelativeSide.TOP) {
            return transparent;
        }
        TextureSide tSide = TextureSide.fromRS(dir);
        TextureType type = TextureType.fromLightsAndTape(this.lights, this.tape);
        IIcon ic = null;
        if (isInventory) {
            switch (tSide) {
                case BOTTOM: {
                    ic = inventory_bottom;
                    break;
                }
                case FRONT: {
                    ic = inventory_front;
                    break;
                }
                case LADDER: {
                    ic = inventory_ladder;
                    break;
                }
                case SIDE: {
                    ic = inventory_side;
                }
            }
        } else {
            ic = textures.get((Object)tSide).get((Object)type);
        }
        if (dir == RelativeSide.RIGHT) {
            return new IconFlipped(ic, true, false);
        }
        return ic;
    }

    public IIcon getLightIcon(int _side, int meta) {
        RelativeSide dir = RelativeSide.FDtoRS(ForgeDirection.getOrientation((int)_side), this.direction);
        if (dir == RelativeSide.TOP) {
            return transparent;
        }
        TextureSide tSide = TextureSide.fromRS(dir);
        IIcon ic = textures.get((Object)tSide).get((Object)(this.tape ? TextureType.T_LIGHTS : TextureType.LIGHTS));
        if (dir == RelativeSide.RIGHT) {
            return new IconFlipped(ic, true, false);
        }
        return ic;
    }

    public int func_149750_m() {
        return this.lights ? CatwalkMod.lightLevel : 0;
    }

    public boolean isSideSolid(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess w, int x, int y, int z, int _side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)_side);
        if (dir == ForgeDirection.DOWN && w.isSideSolid(x, y, z, ForgeDirection.DOWN, false)) {
            return false;
        }
        int meta = w.func_72805_g(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
        return !this.isOpen(RelativeSide.FDtoRS(dir, this.direction), meta);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB blockBounds, List list, Entity collidingEntity) {
        float px;
        if (collidingEntity == null) {
            return;
        }
        float out = px = 0.0625f;
        float in = out + px;
        int meta = world.func_72805_g(x, y, z);
        if (!this.isOpen(RelativeSide.FDtoRS(ForgeDirection.NORTH, this.direction), meta)) {
            this.addToList(world, x, y, z, blockBounds, list, out, 0.0, out, 1.0f - out, 1.0, in);
        }
        if (!this.isOpen(RelativeSide.FDtoRS(ForgeDirection.SOUTH, this.direction), meta)) {
            this.addToList(world, x, y, z, blockBounds, list, out, 0.0, 1.0f - out, 1.0f - out, 1.0, 1.0f - in);
        }
        if (!this.isOpen(RelativeSide.FDtoRS(ForgeDirection.EAST, this.direction), meta)) {
            this.addToList(world, x, y, z, blockBounds, list, 1.0f - in, 0.0, out, 1.0f - out, 1.0, 1.0f - out);
        }
        if (!this.isOpen(RelativeSide.FDtoRS(ForgeDirection.WEST, this.direction), meta)) {
            this.addToList(world, x, y, z, blockBounds, list, out, 0.0, out, in, 1.0, 1.0f - out);
        }
        if (!this.isOpen(RelativeSide.FDtoRS(ForgeDirection.DOWN, this.direction), meta) && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP, false)) {
            this.addToList(world, x, y, z, blockBounds, list, out, 0.0, out, 1.0f - out, px, 1.0f - out);
        }
    }

    public void addToList(World world, int x, int y, int z, AxisAlignedBB blockBounds, List list, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        AxisAlignedBB axisalignedbb1 = AxisAlignedBB.func_72330_a((double)((double)x + minX), (double)((double)y + minY), (double)((double)z + minZ), (double)((double)x + maxX), (double)((double)y + maxY), (double)((double)z + maxZ));
        if (blockBounds.func_72326_a(axisalignedbb1)) {
            list.add(axisalignedbb1);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(Item.func_150898_a((Block)CatwalkMod.defaultLadder), 1));
        if (this.lights) {
            ret.add(new ItemStack(CatwalkMod.itemRopeLight, 1));
        }
        if (this.tape) {
            ret.add(new ItemStack(CatwalkMod.itemCautionTape, 1));
        }
        return ret;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public int setBit(int val, int pos, boolean value) {
        if (value) {
            return val | 1 << pos;
        }
        return val & ~(1 << pos);
    }

    public boolean getBit(int val, int pos) {
        return (val & 1 << pos) > 0;
    }

    public boolean isOpen(RelativeSide side, int meta) {
        switch (side) {
            case BOTTOM: {
                return this.isBottomOpen;
            }
            case LADDER: {
                return this.getBit(meta, 3);
            }
            case FRONT: {
                return this.getBit(meta, 2);
            }
            case LEFT: {
                return this.getBit(meta, 1);
            }
            case RIGHT: {
                return this.getBit(meta, 0);
            }
        }
        return false;
    }

    public boolean isOpen(ForgeDirection side, int meta) {
        return this.isOpen(RelativeSide.FDtoRS(side, this.direction), meta);
    }

    public void updateOpenData(World world, int x, int y, int z, RelativeSide side, boolean value) {
        int meta = world.func_72805_g(x, y, z);
        switch (side) {
            case BOTTOM: {
                this.updateIdData(world, x, y, z, this.direction, this.lights, value, this.tape);
                return;
            }
            case LADDER: {
                meta = this.setBit(meta, 3, value);
                break;
            }
            case FRONT: {
                meta = this.setBit(meta, 2, value);
                break;
            }
            case LEFT: {
                meta = this.setBit(meta, 1, value);
                break;
            }
            case RIGHT: {
                meta = this.setBit(meta, 0, value);
            }
        }
        world.func_147465_d(x, y, z, (Block)this, meta, 3);
    }

    public void updateIdData(World world, int x, int y, int z, ForgeDirection facing, boolean lights, boolean bottom, boolean tape) {
        int meta = world.func_72805_g(x, y, z);
        if (facing == ForgeDirection.UP || facing == ForgeDirection.DOWN || facing == ForgeDirection.UNKNOWN) {
            facing = ForgeDirection.NORTH;
        }
        world.func_147465_d(x, y, z, CatwalkMod.ladders.get(facing).get(lights).get(bottom).get(tape), world.func_72805_g(x, y, z), 3);
    }

    public int func_149645_b() {
        return CatwalkMod.ladderRenderType;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @Override
    public boolean shouldConnectToSide(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.isOpen(RelativeSide.FDtoRS(side, this.direction), w.func_72805_g(x, y, z));
    }

    @Override
    public boolean shouldHaveBottom(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        if (!this.isOpen(RelativeSide.BOTTOM, w.func_72805_g(x, y, z))) {
            return true;
        }
        Block b = w.func_147439_a(x, y - 1, z);
        if (b instanceof ICagedLadderConnectable) {
            return ((ICagedLadderConnectable)b).doesSideHaveWall(w, x, y - 1, z, side);
        }
        return false;
    }

    @Override
    public boolean doesSideHaveWall(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return !this.isOpen(RelativeSide.FDtoRS(side, this.direction), w.func_72805_g(x, y, z));
    }

    @Override
    public boolean isThin(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        float px = 0.0625f;
        float px2 = 2.0f * px;
        float d = px * 3.0f;
        return CatwalkMod.options.fullBlockLadder || entity.field_70121_D.func_72326_a(AxisAlignedBB.func_72330_a((double)((float)x + d), (double)y, (double)((float)z + d), (double)((float)(x + 1) - d), (double)(y + 1), (double)((float)(z + 1) - d)));
    }

    @Override
    public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return (entity.func_70093_af() || CatwalkUtil.isHoldingWrench(entity, false) ? 0.15 : 0.25) * (double)CatwalkMod.options.ladderSpeedMultiplier;
    }

    @Override
    public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.25 * (double)CatwalkMod.options.ladderSpeedMultiplier;
    }

    @Override
    public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
        return true;
    }

    @Override
    public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() || CatwalkUtil.isHoldingWrench(entity, false);
    }

    @Override
    public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() && CatwalkUtil.isHoldingWrench(entity, false);
    }

    @Override
    public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.15;
    }

    public static enum RelativeSide {
        LADDER,
        FRONT,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;


        public static RelativeSide FDtoRS(ForgeDirection side, ForgeDirection facing) {
            switch (facing) {
                case NORTH: {
                    switch (side) {
                        case NORTH: {
                            return LADDER;
                        }
                        case SOUTH: {
                            return FRONT;
                        }
                        case EAST: {
                            return RIGHT;
                        }
                        case WEST: {
                            return LEFT;
                        }
                        case UP: {
                            return TOP;
                        }
                        case DOWN: {
                            return BOTTOM;
                        }
                    }
                }
                case SOUTH: {
                    switch (side) {
                        case NORTH: {
                            return FRONT;
                        }
                        case SOUTH: {
                            return LADDER;
                        }
                        case EAST: {
                            return LEFT;
                        }
                        case WEST: {
                            return RIGHT;
                        }
                        case UP: {
                            return TOP;
                        }
                        case DOWN: {
                            return BOTTOM;
                        }
                    }
                }
                case EAST: {
                    switch (side) {
                        case NORTH: {
                            return RIGHT;
                        }
                        case SOUTH: {
                            return LEFT;
                        }
                        case EAST: {
                            return FRONT;
                        }
                        case WEST: {
                            return LADDER;
                        }
                        case UP: {
                            return TOP;
                        }
                        case DOWN: {
                            return BOTTOM;
                        }
                    }
                }
                case WEST: {
                    switch (side) {
                        case NORTH: {
                            return LEFT;
                        }
                        case SOUTH: {
                            return RIGHT;
                        }
                        case EAST: {
                            return LADDER;
                        }
                        case WEST: {
                            return FRONT;
                        }
                        case UP: {
                            return TOP;
                        }
                        case DOWN: {
                            return BOTTOM;
                        }
                    }
                }
            }
            switch (side) {
                case NORTH: {
                    return LADDER;
                }
                case SOUTH: {
                    return FRONT;
                }
                case EAST: {
                    return RIGHT;
                }
                case WEST: {
                    return LEFT;
                }
                case UP: {
                    return TOP;
                }
                case DOWN: {
                    return BOTTOM;
                }
            }
            return BOTTOM;
        }

        public static ForgeDirection RStoFD(RelativeSide side, ForgeDirection facing) {
            switch (facing) {
                case NORTH: {
                    switch (side) {
                        case LADDER: {
                            return ForgeDirection.NORTH;
                        }
                        case FRONT: {
                            return ForgeDirection.SOUTH;
                        }
                        case RIGHT: {
                            return ForgeDirection.EAST;
                        }
                        case LEFT: {
                            return ForgeDirection.WEST;
                        }
                        case TOP: {
                            return ForgeDirection.UP;
                        }
                        case BOTTOM: {
                            return ForgeDirection.DOWN;
                        }
                    }
                }
                case SOUTH: {
                    switch (side) {
                        case FRONT: {
                            return ForgeDirection.NORTH;
                        }
                        case LADDER: {
                            return ForgeDirection.SOUTH;
                        }
                        case LEFT: {
                            return ForgeDirection.EAST;
                        }
                        case RIGHT: {
                            return ForgeDirection.WEST;
                        }
                        case TOP: {
                            return ForgeDirection.UP;
                        }
                        case BOTTOM: {
                            return ForgeDirection.DOWN;
                        }
                    }
                }
                case EAST: {
                    switch (side) {
                        case RIGHT: {
                            return ForgeDirection.NORTH;
                        }
                        case LEFT: {
                            return ForgeDirection.SOUTH;
                        }
                        case FRONT: {
                            return ForgeDirection.EAST;
                        }
                        case LADDER: {
                            return ForgeDirection.WEST;
                        }
                        case TOP: {
                            return ForgeDirection.UP;
                        }
                        case BOTTOM: {
                            return ForgeDirection.DOWN;
                        }
                    }
                }
                case WEST: {
                    switch (side) {
                        case LEFT: {
                            return ForgeDirection.NORTH;
                        }
                        case RIGHT: {
                            return ForgeDirection.SOUTH;
                        }
                        case LADDER: {
                            return ForgeDirection.EAST;
                        }
                        case FRONT: {
                            return ForgeDirection.WEST;
                        }
                        case TOP: {
                            return ForgeDirection.UP;
                        }
                        case BOTTOM: {
                            return ForgeDirection.DOWN;
                        }
                    }
                }
            }
            switch (side) {
                case LADDER: {
                    return ForgeDirection.NORTH;
                }
                case FRONT: {
                    return ForgeDirection.SOUTH;
                }
                case RIGHT: {
                    return ForgeDirection.EAST;
                }
                case LEFT: {
                    return ForgeDirection.WEST;
                }
                case TOP: {
                    return ForgeDirection.UP;
                }
                case BOTTOM: {
                    return ForgeDirection.DOWN;
                }
            }
            return ForgeDirection.DOWN;
        }
    }

    public static enum TextureType {
        LIGHTS("plain/lights"),
        T_LIGHTS("tape/lights"),
        W_LIGHTS("plain/w_lights"),
        WO_LIGHTS("plain/no_lights"),
        T_W_LIGHTS("tape/w_lights"),
        T_WO_LIGHTS("tape/no_lights");

        public String filename;

        private TextureType(String filename) {
            this.filename = filename;
        }

        public static TextureType fromLightsAndTape(boolean lights, boolean tape) {
            if (!lights && !tape) {
                return WO_LIGHTS;
            }
            if (lights && !tape) {
                return W_LIGHTS;
            }
            if (!lights && tape) {
                return T_WO_LIGHTS;
            }
            if (lights && tape) {
                return T_W_LIGHTS;
            }
            return WO_LIGHTS;
        }
    }

    public static enum TextureSide {
        LADDER("ladder"),
        SIDE("side"),
        FRONT("front"),
        BOTTOM("bottom");

        public String filename;

        private TextureSide(String filename) {
            this.filename = filename;
        }

        public static TextureSide fromRS(RelativeSide side) {
            switch (side) {
                case FRONT: {
                    return FRONT;
                }
                case LEFT: 
                case RIGHT: {
                    return SIDE;
                }
                case LADDER: {
                    return LADDER;
                }
                case BOTTOM: {
                    return BOTTOM;
                }
            }
            return BOTTOM;
        }
    }
}

