/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

class EventQueue {
    private final int maxEvents;
    private int eventCount = 0;
    private int readEventPos = 0;
    private int writeEventPos = 1;
    private long lastDroppedMessageMs = 0L;

    EventQueue(int maxEvents) {
        this.maxEvents = maxEvents;
    }

    synchronized void add() {
        ++this.eventCount;
        if (this.eventCount > this.maxEvents) {
            this.eventCount = this.maxEvents;
            long ms = System.currentTimeMillis();
            if (ms - this.lastDroppedMessageMs > 1000L) {
                this.lastDroppedMessageMs = ms;
                System.out.println("Dropping LWJGL input events due to not frequent enough polling");
            }
        }
        ++this.writeEventPos;
        if (this.writeEventPos >= this.maxEvents) {
            this.writeEventPos = 0;
        }
        if (this.writeEventPos == this.readEventPos) {
            ++this.readEventPos;
            --this.eventCount;
        }
        if (this.readEventPos >= this.maxEvents) {
            this.readEventPos = 0;
        }
    }

    synchronized boolean next() {
        if (this.eventCount == 0) {
            return false;
        }
        --this.eventCount;
        ++this.readEventPos;
        if (this.readEventPos >= this.maxEvents) {
            this.readEventPos = 0;
        }
        return true;
    }

    int getEventCount() {
        return this.eventCount;
    }

    int getMaxEvents() {
        return this.maxEvents;
    }

    int getCurrentPos() {
        return this.readEventPos;
    }

    int getLastWrittenPos() {
        return (this.writeEventPos + this.maxEvents - 1) % this.maxEvents;
    }

    int getNextPos() {
        return this.writeEventPos;
    }
}

