/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.tiles.TileMirror;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageParticles;
import tuhljin.automagy.tiles.TileWithEyes;

public abstract class TileEntityMirrorWithEye
extends TileWithEyes
implements IInventory {
    protected static TileMirror staticMirror = new TileMirror();

    public TileEntityMirrorWithEye(String eyeInvName) {
        super(eyeInvName, 1, 0);
    }

    protected TileMirror getTargetMirror(int i) {
        WorldSpecificCoordinates coord = this.eyesContainingInventory.getCoordinates(i);
        if (coord != null) {
            WorldServer targetWorld = DimensionManager.getWorld((int)coord.dim);
            if (targetWorld == null) {
                return null;
            }
            TileEntity te = targetWorld.func_147438_o(coord.x, coord.y, coord.z);
            if (te == null || !(te instanceof TileMirror)) {
                this.handleInvalidTarget(i);
                return null;
            }
            TileMirror tm = (TileMirror)te;
            if (tm.linked) {
                return tm;
            }
            this.handleInvalidTarget(i);
        }
        return null;
    }

    public abstract TileMirror getDestinationMirror();

    protected abstract void handleInvalidTarget(int var1);

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        TileMirror target = this.getDestinationMirror();
        if (target != null) {
            target.addStack(stack.func_77946_l());
            TileEntityMirrorWithEye.addParticles(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.spawnItem(stack.func_77946_l());
        }
    }

    public String func_145825_b() {
        return "Automagy Mirror";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.getDestinationMirror() != null;
    }

    public boolean spawnItem(ItemStack stack) {
        try {
            ForgeDirection face = ForgeDirection.getOrientation((int)this.func_145832_p());
            EntityItem ie2 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 - (double)face.offsetX * 0.3, (double)this.field_145848_d + 0.5 - (double)face.offsetY * 0.3, (double)this.field_145849_e + 0.5 - (double)face.offsetZ * 0.3, stack);
            ie2.field_70159_w = (float)face.offsetX * 0.15f;
            ie2.field_70181_x = (float)face.offsetY * 0.15f;
            ie2.field_70179_y = (float)face.offsetZ * 0.15f;
            ie2.field_71088_bW = 20;
            this.field_145850_b.func_72838_d((Entity)ie2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void addParticles(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            staticMirror.func_145834_a(world);
            TileEntityMirrorWithEye.staticMirror.field_145851_c = x;
            TileEntityMirrorWithEye.staticMirror.field_145848_d = y;
            TileEntityMirrorWithEye.staticMirror.field_145849_e = z;
            TileEntityMirrorWithEye.staticMirror.field_145847_g = world.func_72805_g(x, y, z);
            staticMirror.func_145842_c(1, 0);
        } else {
            MessageParticles.sendToClients(world, x, y, z, 0, 0, 0, (short)12);
        }
    }

    public static boolean spawnItem(ItemStack stack, World world, int x, int y, int z) {
        staticMirror.func_145834_a(world);
        TileEntityMirrorWithEye.staticMirror.field_145851_c = x;
        TileEntityMirrorWithEye.staticMirror.field_145848_d = y;
        TileEntityMirrorWithEye.staticMirror.field_145849_e = z;
        TileEntityMirrorWithEye.staticMirror.field_145847_g = world.func_72805_g(x, y, z);
        return staticMirror.spawnItem(stack);
    }
}

