/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.mixins.Mixins;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.TransformerExclusions(value={"com.mitchej123.hodgepodge.asm", "optifine"})
@IFMLLoadingPlugin.SortingIndex(value=1002)
@IFMLLoadingPlugin.DependsOn(value={"cofh.asm.LoadingPlugin"})
public class HodgepodgeCore
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    private static final Logger log = LogManager.getLogger((String)"Hodgepodge");
    public static final IFMLLoadingPlugin.SortingIndex index = HodgepodgeCore.class.getAnnotation(IFMLLoadingPlugin.SortingIndex.class);
    private String[] transformerClasses;

    public static int getSortingIndex() {
        return index != null ? index.value() : 0;
    }

    public String getMixinConfig() {
        return "mixins.hodgepodge.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArrayList<String> notLoading = new ArrayList<String>();
        for (Mixins mixin : Mixins.values()) {
            if (mixin.phase != Mixins.Phase.EARLY) continue;
            if (mixin.shouldLoad(loadedCoreMods, Collections.emptySet())) {
                mixins.addAll(mixin.mixinClasses);
                continue;
            }
            notLoading.addAll(mixin.mixinClasses);
        }
        Common.log.info("Not loading the following EARLY mixins: {}", new Object[]{((Object)notLoading).toString()});
        return mixins;
    }

    public String[] getASMTransformerClass() {
        if (this.transformerClasses == null) {
            this.transformerClasses = (String[])Arrays.stream(AsmTransformers.values()).map(asmTransformer -> {
                if (asmTransformer.shouldBeLoaded()) {
                    log.info("Loading hodgepodge transformers {}", new Object[]{((AsmTransformers)asmTransformer).name});
                    return ((AsmTransformers)asmTransformer).asmTransformers;
                }
                return null;
            }).filter(Objects::nonNull).flatMap(Collection::stream).toArray(String[]::new);
        }
        return this.transformerClasses;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static enum AsmTransformers {
        POLLUTION_TRANSFORMER("Pollution Transformer", () -> Common.config.pollutionAsm, Collections.singletonList("com.mitchej123.hodgepodge.asm.transformers.pollution.PollutionClassTransformer")),
        CoFHWorldTransformer("World Transformer - Remove CoFH tile entity cache", () -> Common.config.cofhWorldTransformer, Collections.singletonList("com.mitchej123.hodgepodge.asm.transformers.cofh.WorldTransformer")),
        SpeedupProgressBar("Speed up Progress Bar by speeding up stripSpecialCharacters", () -> Common.config.speedupProgressBar, Collections.singletonList("com.mitchej123.hodgepodge.asm.transformers.fml.SpeedupProgressBarTransformer")),
        THERMOS_SLEDGEHAMMER_FURNACE_FIX("Take a sledgehammer to CraftServer.resetRecipes() to prevent it from breaking our Furnace Fix", () -> Common.thermosTainted && Common.config.speedupVanillaFurnace, Collections.singletonList("com.mitchej123.hodgepodge.asm.transformers.thermos.ThermosFurnaceSledgeHammer"));

        private final String name;
        private final Supplier<Boolean> applyIf;
        private final List<String> asmTransformers;

        private AsmTransformers(String name, Supplier<Boolean> applyIf, List<String> asmTransformers) {
            this.name = name;
            this.applyIf = applyIf;
            this.asmTransformers = asmTransformers;
        }

        public boolean shouldBeLoaded() {
            return this.applyIf.get();
        }
    }
}

