/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island;

import chylex.hee.init.BlockList;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeEnchantedIsland;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import java.util.Random;
import net.minecraft.init.Blocks;

public class StructureGooLake
extends AbstractIslandStructure {
    @Override
    protected boolean generate(Random rand) {
        int x = this.getRandomXZ(rand, 16);
        int z = this.getRandomXZ(rand, 16);
        int y = this.world.getHighestY(x, z) + 1;
        int yOff = 0;
        int minY = y + 3;
        if (y <= 1) {
            return false;
        }
        boolean isSwamp = this.biomeData.hasDeviation(IslandBiomeEnchantedIsland.GOO_SWAMP);
        double rad = (isSwamp ? 3.0 * (rand.nextDouble() * 2.0 + 0.8) : 2.0) + rand.nextDouble() * 3.0 + rand.nextDouble() * 3.0;
        double hrad = rad * 0.5;
        boolean canGenerate = true;
        int testX = MathUtil.floor((double)x - rad);
        while ((double)testX <= (double)x + rad) {
            int testZ = MathUtil.floor((double)z - rad);
            while ((double)testZ <= (double)z + rad) {
                boolean found = false;
                for (int testY = y + 2; testY >= y - 2; --testY) {
                    if (!this.world.isAir(testX, testY, testZ) || this.world.getBlock(testX, testY - 1, testZ) != this.surface()) continue;
                    found = true;
                    if (testY >= minY) break;
                    minY = testY;
                    break;
                }
                if (!found) {
                    testX += 999;
                    canGenerate = false;
                    break;
                }
                ++testZ;
            }
            ++testX;
        }
        if (!canGenerate) {
            return false;
        }
        --minY;
        int a = 0;
        while (true) {
            double d = a;
            int n = isSwamp ? 10 : 5;
            if (!(d < 3.0 + rad + (double)rand.nextInt(n))) break;
            double cx = (double)x + Math.min(hrad, Math.abs(rand.nextGaussian() * 0.7 * (double)a)) * ((double)rand.nextInt(2) * 2.0 - 1.0);
            double cz = (double)z + Math.min(hrad, Math.abs(rand.nextGaussian() * 0.7 * (double)a)) * ((double)rand.nextInt(2) * 2.0 - 1.0);
            double r = hrad * (0.25 + rand.nextDouble() * 0.75);
            for (int iteration = 0; iteration < Math.min(1, rand.nextInt(3)); ++iteration) {
                if (iteration == 1) {
                    r *= 0.75;
                    yOff = -1;
                }
                int px = MathUtil.floor(cx - r);
                while ((double)px <= cx + r) {
                    int pz = MathUtil.floor(cz - r);
                    while ((double)pz <= cz + r) {
                        if (MathUtil.distance((double)px - cx, (double)pz - cz) < r - 0.3 + rand.nextDouble() * 0.7) {
                            for (int py = minY + yOff; py < y + 2; ++py) {
                                if (py <= minY) {
                                    this.world.setBlock(px, py, pz, BlockList.ender_goo);
                                    continue;
                                }
                                this.world.setBlock(px, py, pz, Blocks.field_150350_a);
                            }
                        }
                        ++pz;
                    }
                    ++px;
                }
            }
            ++a;
            yOff = 0;
        }
        return true;
    }
}

