/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.element;

import chylex.hee.api.message.element.base.Precondition;
import net.minecraft.nbt.NBTBase;

public class DecimalValue
extends Precondition<Double> {
    private double minValue;
    private double maxValue;

    public static final DecimalValue any() {
        return new DecimalValue(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public static final DecimalValue positiveOrZero() {
        return new DecimalValue(0.0, Double.MAX_VALUE);
    }

    public static final DecimalValue negativeOrZero() {
        return new DecimalValue(Double.MIN_VALUE, 0.0);
    }

    private DecimalValue(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public boolean checkType(NBTBase tag) {
        return tag != null && (tag.func_74732_a() == 3 || tag.func_74732_a() == 1 || tag.func_74732_a() == 2 || tag.func_74732_a() == 4 || tag.func_74732_a() == 6 || tag.func_74732_a() == 5);
    }

    @Override
    public boolean checkValue(NBTBase tag) {
        double value = ((NBTBase.NBTPrimitive)tag).func_150286_g();
        return value >= this.minValue && value <= this.maxValue;
    }

    @Override
    public Double getValue(NBTBase tag) {
        return ((NBTBase.NBTPrimitive)tag).func_150286_g();
    }
}

