/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega.GT_TileEntity_MegaMultiBlockBase;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaBlastFurnace
extends GT_TileEntity_MegaMultiBlockBase<GT_TileEntity_MegaBlastFurnace>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 11;
    private static final IStructureDefinition<GT_TileEntity_MegaBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", GT_TileEntity_MegaBlastFurnace.createShape()).addElement('=', GT_TileEntity_MegaMultiBlockBase.StructureElementAirNoHint.getInstance()).addElement('t', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaBlastFurnace.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputHatch.withAdder(GT_TileEntity_MegaBlastFurnace::addOutputHatchToTopList).withCount(t -> t.mPollutionOutputHatches.size())}).casingIndex(11).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 11)).addElement('m', GT_HatchElement.Muffler.newAny(11, 2)).addElement('C', StructureUtility.withChannel((String)"coil", (IStructureElement)GT_StructureUtility.ofCoil(GT_TileEntity_MegaBlastFurnace::setCoilLevel, GT_TileEntity_MegaBlastFurnace::getCoilLevel))).addElement('g', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier))).addElement('b', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaBlastFurnace.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_TileEntity_MegaMultiBlockBase.TTEnabledEnergyHatchElement.INSTANCE}).casingIndex(11).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 11)).build();
    private HeatingCoilLevel mCoilLevel;
    protected final ArrayList<GT_MetaTileEntity_Hatch_Output> mPollutionOutputHatches = new ArrayList();
    protected final FluidStack[] pollutionFluidStacks = new FluidStack[]{Materials.CarbonDioxide.getGas(1000L), Materials.CarbonMonoxide.getGas(1000L), Materials.SulfurDioxide.getGas(1000L)};
    private int mHeatingCapacity;
    private byte glasTier;
    private int polPtick = ConfigHandler.basePollutionMBFSecond / 20 * ConfigHandler.megaMachinesMax;
    private int mufflerTier = -1;
    private byte circuitMode = 0;

    private static String[][] createShape() {
        int i;
        String[][] raw = new String[20][];
        raw[0] = new String[15];
        String topCasing = "ttttttttttttttt";
        String middleTopCasing = "tttttttmttttttt";
        raw[0][0] = topCasing;
        for (int i2 = 1; i2 < 15; ++i2) {
            raw[0][i2] = topCasing;
        }
        raw[0][7] = middleTopCasing;
        raw[1] = new String[15];
        String allGlass = "ggggggggggggggg";
        String allCoil = "gCCCCCCCCCCCCCg";
        String middleLine = "gC===========Cg";
        raw[1][0] = allGlass;
        raw[1][1] = allCoil;
        raw[1][13] = allCoil;
        raw[1][14] = allGlass;
        for (i = 2; i < 13; ++i) {
            raw[1][i] = middleLine;
        }
        for (i = 2; i < 19; ++i) {
            raw[i] = raw[1];
        }
        String bottomCasing = "bbbbbbbbbbbbbbb";
        raw[19] = new String[15];
        for (int i3 = 0; i3 < 15; ++i3) {
            raw[19][i3] = bottomCasing;
        }
        raw[17] = Arrays.copyOf(raw[17], raw[17].length);
        raw[17][0] = "ggggggg~ggggggg";
        return StructureUtility.transpose((String[][])raw);
    }

    public GT_TileEntity_MegaBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaBlastFurnace(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_TileEntity_MegaBlastFurnace(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Blast Furnace").addInfo("Controller block for the Mega Blast Furnace").addInfo("You can use some fluids to reduce recipe time. Place the circuit in the Input Bus").addInfo("Each 900K over the min. Heat required reduces power consumption by 5% (multiplicatively)").addInfo("Each 1800K over the min. Heat required grants one perfect overclock").addInfo("For each perfect overclock the EBF will reduce recipe time 4 times (instead of 2) (100% efficiency)").addInfo("Additionally gives +100K for every tier past MV").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(15, 20, 15, true).addController("3rd layer center").addCasingInfo("Heat Proof Machine Casing", 0).addOtherStructurePart("864x Heating Coils", "Inner 13x18x13 (Hollow)").addOtherStructurePart("1007x Borosilicate Glass", "Outer 15x18x15").addStructureInfo("The glass tier limits the Energy Input tier").addEnergyHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").addMufflerHatch("Top middle").addInputBus("Any bottom layer casing").addInputHatch("Any bottom layer casing").addOutputBus("Any bottom layer casing").addOutputHatch("Gasses, Any top layer casing").addStructureInfo("Recovery amount scales with Muffler Hatch tier").addOutputHatch("Platline fluids, Any bottom layer casing").addStructureHint("This Mega Multiblock is too big to have its structure hologram displayed fully.").toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS);
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.circuitMode = aNBT.func_74771_c("circuitMode");
        this.glasTier = aNBT.func_74771_c("glasTier");
        if (!aNBT.func_74764_b(INPUT_SEPARATION_NBT_KEY)) {
            this.inputSeparation = aNBT.func_74767_n("isBussesSeparate");
        }
        if (!aNBT.func_74764_b(BATCH_MODE_NBT_KEY)) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.circuitMode = (byte)(this.circuitMode - 1);
            if (this.circuitMode < 0) {
                this.circuitMode = (byte)24;
            }
        } else {
            this.circuitMode = (byte)(this.circuitMode + 1);
            if (this.circuitMode > 24) {
                this.circuitMode = 0;
            }
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(this.circuitMode > 0 ? "MEBF will prioritise circuit: " + this.circuitMode : "Circuit prioritisation disabled."));
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        this.inputSeparation = !this.inputSeparation;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation));
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("glasTier", this.glasTier);
        aNBT.func_74774_a("circuitMode", this.circuitMode);
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return this.polPtick;
    }

    public boolean addOutputHatchToTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mPollutionOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    protected boolean addBottomHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addMaintenanceToMachineList(aTileEntity, aBaseCasingIndex) || this.addInputToMachineList(aTileEntity, aBaseCasingIndex) || this.addOutputToMachineList(aTileEntity, aBaseCasingIndex) || this.addEnergyInputToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    protected String[] getExtendedInfoData() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)this.mHeatingCapacity) + EnumChatFormatting.RESET + " K"};
    }

    public boolean checkRecipe(ItemStack itemStack) {
        ItemStack[] tInputs = null;
        FluidStack[] tFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        long nominalV = Mods.TecTech.isModLoaded() ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, Math.min(GT_Utility.getTier((long)nominalV), GT_Values.V.length - 1));
        GT_Recipe tRecipe = null;
        if (this.inputSeparation) {
            for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
                ArrayList<ItemStack> tInputList = new ArrayList<ItemStack>();
                tBus.mRecipeMap = this.getRecipeMap();
                if (GT_TileEntity_MegaBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                    for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                        if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                        tInputList.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                    }
                }
                tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[tInputList.size()]), 0, tInputList.size());
                tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
                if (tRecipe == null || !tRecipe.isRecipeInputEqual(false, tFluids, tInputs)) continue;
                break;
            }
        } else {
            tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
            if (this.circuitMode > 0 && Arrays.stream(tInputs).anyMatch(e -> GT_Utility.areStacksEqual((ItemStack)e, (ItemStack)GT_Utility.getIntegratedCircuit((int)this.circuitMode), (boolean)true))) {
                List<ItemStack> modInputs = Arrays.stream(tInputs).filter(Objects::nonNull).filter(e -> !e.func_77973_b().equals(GT_Utility.getIntegratedCircuit((int)this.circuitMode).func_77973_b())).collect(Collectors.toList());
                modInputs.add(GT_Utility.getIntegratedCircuit((int)this.circuitMode));
                tInputs = modInputs.toArray(new ItemStack[0]);
            }
            if ((tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs)) == null) {
                if (this.circuitMode == 0) {
                    return false;
                }
                tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
                tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            }
        }
        if (tRecipe == null) {
            return false;
        }
        ArrayList<Object> outputItems = new ArrayList();
        ArrayList<Object> outputFluids = new ArrayList();
        boolean found_Recipe = false;
        int processed = 0;
        int tHeatCapacityDivTiers = (this.mHeatingCapacity - tRecipe.mSpecialValue) / 900;
        long precutRecipeVoltage = (long)((double)tRecipe.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
        long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / precutRecipeVoltage);
        if (this.batchMode && tMaxPara == (long)ConfigHandler.megaMachinesMax) {
            tMaxPara *= 128L;
        }
        float tBatchMultiplier = 1.0f;
        if (this.mHeatingCapacity >= tRecipe.mSpecialValue) {
            int tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, tFluids, tInputs, (int)tMaxPara);
            tBatchMultiplier = this.batchMode ? Math.max((float)(tCurrentPara / ConfigHandler.megaMachinesMax), 1.0f) : 1.0f;
            this.updateSlots();
            if (tCurrentPara <= 0) {
                return false;
            }
            processed = Math.min(tCurrentPara, ConfigHandler.megaMachinesMax);
            found_Recipe = true;
            Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
            outputFluids = Outputs.getKey();
            outputItems = Outputs.getValue();
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setParallel(processed).setDuration(tRecipe.mDuration).setEUt(nominalV).setRecipeHeat(tRecipe.mSpecialValue).setMultiHeat(this.mHeatingCapacity).enableHeatOC().enableHeatDiscount().calculate();
            this.mMaxProgresstime = calculator.getDuration();
            this.lEUt = calculator.getConsumption();
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.lEUt == 0x7FFFFFFEL) {
                return false;
            }
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            if (this.batchMode) {
                this.mMaxProgresstime = (int)Math.ceil((float)this.mMaxProgresstime * tBatchMultiplier);
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.polPtick = ConfigHandler.basePollutionMBFSecond / 20 * processed;
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            return true;
        }
        return false;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    public IStructureDefinition<GT_TileEntity_MegaBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 7, 17, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        this.glasTier = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        return this.survivialBuildPiece("main", stackSize, 7, 17, 0, realBudget, source, actor, false, true);
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.mCoilLevel = aCoilLevel;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.mCoilLevel;
    }

    public boolean addOutput(FluidStack aLiquid) {
        ArrayList tOutputHatches;
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        boolean isOutputPollution = false;
        for (FluidStack pollutionFluidStack : this.pollutionFluidStacks) {
            if (!tLiquid.isFluidEqual(pollutionFluidStack)) continue;
            isOutputPollution = true;
            break;
        }
        if (isOutputPollution) {
            tOutputHatches = this.mPollutionOutputHatches;
            int pollutionReduction = 0;
            for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
                if (!GT_TileEntity_MegaBlastFurnace.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                pollutionReduction = 100 - tHatch.calculatePollutionReduction(100);
                break;
            }
            tLiquid.amount = tLiquid.amount * (pollutionReduction + 5) / 100;
        } else {
            tOutputHatches = this.mOutputHatches;
        }
        return GT_TileEntity_MegaBlastFurnace.dumpFluid((List)tOutputHatches, (FluidStack)tLiquid, (boolean)true) || GT_TileEntity_MegaBlastFurnace.dumpFluid((List)tOutputHatches, (FluidStack)tLiquid, (boolean)false);
    }

    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        if (Mods.TecTech.isModLoaded()) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        this.mHeatingCapacity = 0;
        this.glasTier = 0;
        this.mufflerTier = -1;
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mPollutionOutputHatches.clear();
        if (!this.checkPiece("main", 7, 17, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (Mods.TecTech.isModLoaded() && this.glasTier < 8 && (!this.areLazorsLowPowa() || this.areThingsNotProperlyTiered(this.getTecTechEnergyTunnels()) || this.areThingsNotProperlyTiered(this.getTecTechEnergyMultis()))) {
            return false;
        }
        if (this.glasTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        long nominalV = Mods.TecTech.isModLoaded() ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        this.mHeatingCapacity = (int)this.getCoilLevel().getHeat() + 100 * (BW_Util.getTier(nominalV) - 2);
        return true;
    }

    @Optional.Method(modid="tectech")
    private boolean areThingsNotProperlyTiered(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (((GT_MetaTileEntity_TieredMachineBlock)tecTechEnergyMulti).mTier <= this.glasTier) continue;
                return true;
            }
        }
        return false;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBlastRecipes;
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }
}

