/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_LongPowerUsageBase;
import goodgenerator.client.GUI.GG_UITextures;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import goodgenerator.util.MyRecipeAdder;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_HatchElementBuilder;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class PreciseAssembler
extends GT_MetaTileEntity_LongPowerUsageBase<PreciseAssembler>
implements IConstructable,
ISurvivalConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST_GLOW");
    protected IStructureDefinition<PreciseAssembler> multiDefinition = null;
    protected int casingAmount;
    protected int casingTier;
    protected int machineTier;
    protected int mode;
    protected int energyHatchTier;
    private GT_Recipe lastRecipe;

    public PreciseAssembler(String name) {
        super(name);
    }

    public PreciseAssembler(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IStructureDefinition<PreciseAssembler> getStructureDefinition() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"CCCC~CCCC", "CMMMMMMMC", "CMMMMMMMC", "CMMMMMMMC", "CCCCCCCCC"}})).addElement('C', (IStructureElement)GT_HatchElementBuilder.builder().atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Muffler, GT_HatchElement.ExoticEnergy.or((IHatchElement)GT_HatchElement.Energy)}).adder(PreciseAssembler::addToPAssList).casingIndex(1539).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlocksTiered((block, meta) -> block == Loaders.preciseUnitCasing ? meta : -2, IntStream.range(0, 3).mapToObj(meta -> Pair.of((Object)Loaders.preciseUnitCasing, (Object)meta)).collect(Collectors.toList()), (Object)-1, PreciseAssembler::setCasingTier, PreciseAssembler::getCasingTier))})).addElement('F', GT_StructureUtility.ofFrame((Materials)Materials.TungstenSteel)).addElement('G', BW_Util.ofGlassTieredMixed((byte)4, (byte)127, (int)2)).addElement('M', StructureUtility.ofBlocksTiered((block, meta) -> block == GregTech_API.sBlockCasings1 ? meta : -2, IntStream.range(0, 10).mapToObj(meta -> Pair.of((Object)GregTech_API.sBlockCasings1, (Object)meta)).collect(Collectors.toList()), (Object)-1, PreciseAssembler::setMachineTier, PreciseAssembler::getMachineTier)).build();
        }
        return this.multiDefinition;
    }

    public boolean addToPAssList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_EnergyMulti) {
            return this.mExoticEnergyHatches.add((GT_MetaTileEntity_Hatch_EnergyMulti)aMetaTileEntity);
        }
        return false;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.casingTier = aNBT.func_74762_e("casingTier");
        this.machineTier = aNBT.func_74762_e("machineTier");
        this.mode = aNBT.func_74762_e("RunningMode");
        super.loadNBTData(aNBT);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("casingTier", this.casingTier);
        aNBT.func_74768_a("machineTier", this.machineTier);
        aNBT.func_74768_a("RunningMode", this.mode);
        super.saveNBTData(aNBT);
    }

    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.mode = (this.mode + 1) % 2;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)));
        }
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        if (this.casingTier < 0 || this.machineTier < 0) {
            return false;
        }
        FluidStack[] inputFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        if (this.mode == 0) {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)bus)) continue;
                this.lastRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.lastRecipe, false, Math.min(this.getMachineVoltageLimit(), this.getRealVoltage()), inputFluids, this.getStoredItemFromHatch(bus));
                if (this.lastRecipe == null || this.lastRecipe.mSpecialValue > this.casingTier + 1) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.lastRecipe.isRecipeInputEqual(true, inputFluids, this.getStoredItemFromHatch(bus));
                this.mOutputItems = this.lastRecipe.mOutputs;
                this.calculateOverclockedNessMulti(this.lastRecipe.mEUt, this.lastRecipe.mDuration, 1, this.getRealVoltage());
                this.updateSlots();
                if (this.lEUt > 0L) {
                    this.lEUt = -this.lEUt;
                }
                return true;
            }
        } else {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)bus) || this.getStoredItemFromHatch(bus).length < 1) continue;
                this.lastRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.lastRecipe, false, Math.min(this.getMachineVoltageLimit(), this.getRealVoltage()), inputFluids, this.getStoredItemFromHatch(bus));
                if (this.lastRecipe == null) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                long fullInput = this.getRealVoltage();
                int pall = RecipeFinderForParallel.handleParallelRecipe((GT_Recipe)this.lastRecipe, (FluidStack[])inputFluids, (ItemStack[])this.getStoredItemFromHatch(bus), (int)((int)Math.min((long)Math.pow(2.0, 4 + (this.casingTier + 1)), fullInput / (long)this.lastRecipe.mEUt)));
                if (pall <= 0) continue;
                com.github.bartimaeusnek.bartworks.util.Pair Outputs = RecipeFinderForParallel.getMultiOutput((GT_Recipe)this.lastRecipe, (int)pall);
                this.mOutputItems = ((ArrayList)Outputs.getValue()).toArray(new ItemStack[0]);
                this.calculateOverclockedNessMulti((long)this.lastRecipe.mEUt * (long)pall, this.lastRecipe.mDuration / 2, 1, this.getRealVoltage());
                this.updateSlots();
                if (this.lEUt > 0L) {
                    this.lEUt = -this.lEUt;
                }
                return true;
            }
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public long getMachineVoltageLimit() {
        if (this.machineTier < 0) {
            return 0L;
        }
        if (this.machineTier >= 9) {
            return GT_Values.V[this.energyHatchTier];
        }
        return GT_Values.V[Math.min(this.machineTier, this.energyHatchTier)];
    }

    public ItemStack[] getStoredItemFromHatch(GT_MetaTileEntity_Hatch_InputBus tHatch) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
            if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
            rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
        }
        return rList.toArray(new ItemStack[0]);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.mode == 0) {
            return MyRecipeAdder.instance.PA;
        }
        return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 4, 4, 0, elementBudget, source, actor, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.machineTier = -1;
        this.casingAmount = 0;
        this.casingTier = -1;
        this.energyHatchTier = 0;
        if (this.checkPiece(this.mName, 4, 4, 0)) {
            this.energyHatchTier = this.checkEnergyHatchTier();
            if (this.casingTier >= 0) {
                this.reUpdate(1539 + this.casingTier);
            }
            this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
            return this.casingAmount >= 42 && this.machineTier >= 0 && this.casingTier >= 0 && this.mMaintenanceHatches.size() == 1 && !this.mMufflerHatches.isEmpty();
        }
        return false;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Precise Assembler/Assembler").addInfo("Controller block for the Precise Assembler").addInfo("The error is no more than 7nm.").addInfo("Can assemble precise component in Precise Mode.").addInfo("Can work like a normal assembler in Normal Mode.").addInfo("Use screwdriver to change mode.").addInfo("Machine Casing and Energy Hatch limits the voltage tier the machine can work on.").addInfo("UHV Machine Casing will unlock all voltage, but you still need good Energy Hatch.").addInfo("Precise Electronic Unit Casing won't limit recipe in Normal Mode.").addInfo("But gives more parallel with more advanced one.").addInfo("It is 100% faster in Normal Mode.").addInfo("MK-I = 32x, MK-II = 64x, MK-III = 128x").addPollutionAmount(this.getPollutionPerSecond(null)).addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addController("Front bottom").addInputHatch("Any Casing").addInputBus("Any Casing").addOutputHatch("Any Casing").addOutputBus("Any Casing").addEnergyHatch("Any Casing").addMufflerHatch("Any Casing").addMaintenanceHatch("Any Casing").toolTipFinisher("Good Generator");
        return tt;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 780;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("PreciseAssembler.hint", 7);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new PreciseAssembler(this.mName);
    }

    private int checkEnergyHatchTier() {
        int tier = 0;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tier = Math.max(tHatch.mTier, tier);
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mExoticEnergyHatches) {
            if (!PreciseAssembler.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tier = Math.max(tHatch.mTier, tier);
        }
        return tier;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public int getMachineTier() {
        return this.machineTier;
    }

    public void setMachineTier(int i) {
        this.machineTier = i;
    }

    public void reUpdate(int texture) {
        for (GT_MetaTileEntity_Hatch hatch : this.mInputHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mInputBusses) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mOutputHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mOutputBusses) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mEnergyHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mMaintenanceHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mMufflerHatches) {
            hatch.updateTexture(texture);
        }
        for (GT_MetaTileEntity_Hatch hatch : this.mExoticEnergyHatches) {
            hatch.updateTexture(texture);
        }
    }

    public byte getUpdateData() {
        return (byte)this.casingTier;
    }

    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && (aValue & 0x80) == 0) {
            this.casingTier = aValue;
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        int t = Math.max(this.getCasingTier(), 0);
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1539 + t)), TextureFactory.of((IIconContainer)textureFontOn), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOn_Glow}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1539 + t)), TextureFactory.of((IIconContainer)textureFontOff), TextureFactory.builder().addIcon(new IIconContainer[]{textureFontOff_Glow}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)(1539 + t))};
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mode == 1, val -> {
            this.mode = val != false ? 1 : 0;
        }).setTextureGetter(state -> state == 1 ? GG_UITextures.OVERLAY_BUTTON_ASSEMBLER_MODE : GG_UITextures.OVERLAY_BUTTON_PRECISE_MODE).setBackground(new IDrawable[]{GT_UITextures.BUTTON_STANDARD}).setPos(80, 91).setSize(16, 16).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)))).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5));
    }

    public boolean isInputSeparationEnabled() {
        return true;
    }
}

