/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.tasks.PanelTaskInteractEntity;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskInteractEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TaskInteractEntity
extends TaskProgressableBase<Integer> {
    @Nullable
    public BigItemStack targetItem = null;
    public boolean ignoreItemNBT = false;
    public boolean partialItemMatch = true;
    public String entityID = "Villager";
    public NBTTagCompound entityTags = new NBTTagCompound();
    public boolean entitySubtypes = true;
    public boolean ignoreEntityNBT = true;
    public boolean onInteract = true;
    public boolean onHit = false;
    public int required = 1;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.targetItem = BigItemStack.loadItemStackFromNBT(nbt.func_74775_l("item"));
        this.ignoreItemNBT = nbt.func_74767_n("ignoreItemNBT");
        this.partialItemMatch = nbt.func_74767_n("partialItemMatch");
        this.entityID = nbt.func_74779_i("targetID");
        this.entityTags = nbt.func_74775_l("targetNBT");
        this.ignoreEntityNBT = nbt.func_74767_n("ignoreTargetNBT");
        this.entitySubtypes = nbt.func_74767_n("targetSubtypes");
        this.required = nbt.func_74762_e("requiredUses");
        this.onInteract = nbt.func_74767_n("onInteract");
        this.onHit = nbt.func_74767_n("onHit");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)(this.targetItem != null ? this.targetItem.writeToNBT(new NBTTagCompound()) : new NBTTagCompound()));
        nbt.func_74757_a("ignoreItemNBT", this.ignoreItemNBT);
        nbt.func_74757_a("partialItemMatch", this.partialItemMatch);
        nbt.func_74778_a("targetID", this.entityID);
        nbt.func_74782_a("targetNBT", (NBTBase)this.entityTags);
        nbt.func_74757_a("ignoreTargetNBT", this.ignoreEntityNBT);
        nbt.func_74757_a("targetSubtypes", this.entitySubtypes);
        nbt.func_74768_a("requiredUses", this.required);
        nbt.func_74757_a("onInteract", this.onInteract);
        nbt.func_74757_a("onHit", this.onHit);
        return nbt;
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.interact_entity";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskInteractEntity.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelTaskInteractEntity(rect, this);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    @Override
    public Integer getUsersProgress(UUID uuid) {
        Integer n = (Integer)this.userProgress.get(uuid);
        return n == null ? 0 : n;
    }

    @Override
    public Integer readUserProgressFromNBT(NBTTagCompound nbt) {
        return nbt.func_74762_e("value");
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, Integer progress) {
        nbt.func_74768_a("value", progress.intValue());
    }

    @Override
    public void detect(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if ((Integer)value.func_76340_b() >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(quest.getKey());
    }

    public void onInteract(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest, ItemStack item, Entity entity, boolean isHit) {
        if (!this.onHit && isHit || !this.onInteract && !isHit) {
            return;
        }
        Class targetClass = (Class)EntityList.field_75625_b.get(this.entityID);
        if (targetClass == null) {
            return;
        }
        Class<?> subjectClass = entity.getClass();
        String subjectRes = EntityList.func_75621_b((Entity)entity);
        if (subjectRes == null) {
            return;
        }
        if (this.entitySubtypes ? !targetClass.isAssignableFrom(subjectClass) : !subjectRes.equals(this.entityID)) {
            return;
        }
        if (!this.ignoreEntityNBT) {
            NBTTagCompound subjectTags = new NBTTagCompound();
            entity.func_70039_c(subjectTags);
            if (!ItemComparison.CompareNBTTag((NBTBase)this.entityTags, (NBTBase)subjectTags, true)) {
                return;
            }
        }
        if (this.targetItem != null) {
            if (this.targetItem.hasOreDict() && !ItemComparison.OreDictionaryMatch(this.targetItem.getOreIngredient(), this.targetItem.GetTagCompound(), item, !this.ignoreItemNBT, this.partialItemMatch)) {
                return;
            }
            if (!ItemComparison.StackMatch(this.targetItem.getBaseStack(), item, !this.ignoreItemNBT, this.partialItemMatch)) {
                return;
            }
        }
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if (this.isComplete((UUID)value.func_76341_a())) {
                return;
            }
            int np = Math.min(this.required, (Integer)value.func_76340_b() + 1);
            this.setUserProgress((UUID)value.func_76341_a(), np);
            if (np >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(quest.getKey());
    }

    @Override
    public List<String> getTextsForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(this.entityID);
        if (this.targetItem != null) {
            texts.add(this.targetItem.getBaseStack().func_82833_r());
        }
        return texts;
    }
}

