/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenReceiver;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenStorage;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.oxygen.NetworkHelper;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityOxygen
extends TileBaseElectricBlock
implements IOxygenReceiver,
IOxygenStorage {
    public float maxOxygen;
    public float oxygenPerTick;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float storedOxygen;
    public float lastStoredOxygen;
    public static int timeSinceOxygenRequest;

    public TileEntityOxygen(float maxOxygen, float oxygenPerTick) {
        this.maxOxygen = maxOxygen;
        this.oxygenPerTick = oxygenPerTick;
    }

    public int getScaledOxygenLevel(int scale) {
        return (int)Math.floor(this.getOxygenStored() * (float)scale / (this.getMaxOxygenStored() - this.oxygenPerTick));
    }

    public abstract boolean shouldUseOxygen();

    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor((double)this.storedOxygen / (double)this.maxOxygen * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (timeSinceOxygenRequest > 0) {
                --timeSinceOxygenRequest;
            }
            if (this.shouldUseOxygen()) {
                this.storedOxygen = Math.max(this.storedOxygen - this.oxygenPerTick, 0.0f);
            }
        }
        this.lastStoredOxygen = this.storedOxygen;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storedOxygen = nbt.func_74764_b("storedOxygen") ? (float)nbt.func_74762_e("storedOxygen") : nbt.func_74760_g("storedOxygenF");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("storedOxygenF", this.storedOxygen);
    }

    @Override
    public void setOxygenStored(float oxygen) {
        this.storedOxygen = Math.max(Math.min(oxygen, this.getMaxOxygenStored()), 0.0f);
    }

    @Override
    public float getOxygenStored() {
        return this.storedOxygen;
    }

    @Override
    public float getMaxOxygenStored() {
        return this.maxOxygen;
    }

    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || ForgeDirection.UNKNOWN.equals((Object)direction)) {
            return false;
        }
        if (type == NetworkType.OXYGEN) {
            return this.getOxygenInputDirections().contains(direction) || this.getOxygenOutputDirections().contains(direction);
        }
        if (type == NetworkType.POWER) {
            return super.canConnect(direction, type);
        }
        return false;
    }

    @Override
    public float receiveOxygen(ForgeDirection from, float receive, boolean doReceive) {
        if (this.getOxygenInputDirections().contains(from)) {
            if (!doReceive) {
                return this.getOxygenRequest(from);
            }
            return this.receiveOxygen(receive, doReceive);
        }
        return 0.0f;
    }

    public float receiveOxygen(float receive, boolean doReceive) {
        if (receive > 0.0f) {
            float prevOxygenStored = this.getOxygenStored();
            float newStoredOxygen = Math.min(prevOxygenStored + receive, this.getMaxOxygenStored());
            if (doReceive) {
                timeSinceOxygenRequest = 20;
                this.setOxygenStored(newStoredOxygen);
            }
            return Math.max(newStoredOxygen - prevOxygenStored, 0.0f);
        }
        return 0.0f;
    }

    @Override
    public float provideOxygen(ForgeDirection from, float request, boolean doProvide) {
        if (this.getOxygenOutputDirections().contains(from)) {
            return this.provideOxygen(request, doProvide);
        }
        return 0.0f;
    }

    public float provideOxygen(float request, boolean doProvide) {
        if (request > 0.0f) {
            float requestedOxygen = Math.min(request, this.storedOxygen);
            if (doProvide) {
                this.setOxygenStored(this.storedOxygen - requestedOxygen);
            }
            return requestedOxygen;
        }
        return 0.0f;
    }

    public void produceOxygen() {
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection direction : this.getOxygenOutputDirections()) {
                if (direction == ForgeDirection.UNKNOWN) continue;
                this.produceOxygen(direction);
            }
        }
    }

    public boolean produceOxygen(ForgeDirection outputDirection) {
        float provide = this.getOxygenProvide(outputDirection);
        if (provide > 0.0f) {
            float requestedOxygen;
            TileEntity outputTile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, outputDirection);
            IOxygenNetwork outputNetwork = NetworkHelper.getOxygenNetworkFromTileEntity(outputTile, outputDirection);
            if (outputNetwork != null) {
                TileEntity[] tileEntityArray = new TileEntity[]{this};
                float powerRequest = outputNetwork.getRequest(tileEntityArray);
                if (powerRequest > 0.0f) {
                    float rejectedPower = outputNetwork.produce(provide, this);
                    this.provideOxygen(Math.max(provide - rejectedPower, 0.0f), true);
                    return true;
                }
            } else if (outputTile instanceof IOxygenReceiver && (requestedOxygen = ((IOxygenReceiver)outputTile).getOxygenRequest(outputDirection.getOpposite())) > 0.0f) {
                float acceptedOxygen = ((IOxygenReceiver)outputTile).receiveOxygen(outputDirection.getOpposite(), provide, true);
                this.provideOxygen(acceptedOxygen, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public float getOxygenRequest(ForgeDirection direction) {
        if (this.shouldPullOxygen()) {
            return this.oxygenPerTick * 2.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldPullOxygen() {
        return this.storedOxygen < this.maxOxygen;
    }

    @Override
    public float getOxygenProvide(ForgeDirection direction) {
        return 0.0f;
    }
}

