/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui.buttons;

import com.google.common.base.Splitter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import thaumicenergistics.client.gui.buttons.ThEGuiButtonBase;
import thaumicenergistics.client.textures.IStateIconTexture;

@SideOnly(value=Side.CLIENT)
public abstract class ThEStateButton
extends ThEGuiButtonBase {
    private IStateIconTexture backgroundIcon;
    private int iconXOffset = 0;
    private int iconYOffset = 0;
    protected IStateIconTexture stateIcon;

    public ThEStateButton(int ID, int xPosition, int yPosition, int buttonWidth, int buttonHeight, IStateIconTexture icon, int iconXOffset, int iconYOffset, IStateIconTexture backgroundIcon) {
        super(ID, xPosition, yPosition, buttonWidth, buttonHeight, "");
        this.stateIcon = icon;
        this.iconXOffset = iconXOffset;
        this.iconYOffset = iconYOffset;
        this.backgroundIcon = backgroundIcon;
    }

    private void drawScaledTexturedModalRect(int xPosition, int yPosition, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float magic_number = 0.00390625f;
        float minU = (float)u * magic_number;
        float maxU = (float)(u + textureWidth) * magic_number;
        float minV = (float)v * magic_number;
        float maxV = (float)(v + textureHeight) * magic_number;
        double dHeight = height;
        double dWidth = width;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xPosition, (double)yPosition + dHeight, (double)this.field_73735_i, (double)minU, (double)maxV);
        tessellator.func_78374_a((double)xPosition + dWidth, (double)yPosition + dHeight, (double)this.field_73735_i, (double)maxU, (double)maxV);
        tessellator.func_78374_a((double)xPosition + dWidth, (double)yPosition, (double)this.field_73735_i, (double)maxU, (double)minV);
        tessellator.func_78374_a((double)xPosition, (double)yPosition, (double)this.field_73735_i, (double)minU, (double)minV);
        tessellator.func_78381_a();
    }

    protected void addAboutToTooltip(List<String> tooltip, String title, String text) {
        tooltip.add(EnumChatFormatting.WHITE + title);
        for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)text, (int)30, (String)"\n", (boolean)false))) {
            tooltip.add(EnumChatFormatting.GRAY + line.trim());
        }
    }

    protected void drawIcon(Minecraft minecraftInstance, IStateIconTexture icon, int xPos, int yPos, int iconWidth, int iconHeight) {
        minecraftInstance.func_110434_K().func_110577_a(icon.getTexture());
        this.drawScaledTexturedModalRect(xPos + this.iconXOffset, yPos + this.iconYOffset, icon.getU(), icon.getV(), iconWidth, iconHeight, icon.getWidth(), icon.getHeight());
    }

    public void func_146112_a(Minecraft minecraftInstance, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.backgroundIcon != null) {
            this.drawIcon(minecraftInstance, this.backgroundIcon, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        }
        if (this.stateIcon != null) {
            this.drawIcon(minecraftInstance, this.stateIcon, this.field_146128_h + this.iconXOffset, this.field_146129_i + this.iconYOffset, this.field_146120_f, this.field_146121_g);
        }
    }
}

