/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryItem
implements IInventory {
    private final ItemStack stack;
    private ItemStack[] inv;
    private int stackSize = 64;

    public InventoryItem(ItemStack stack, int slotCount) {
        this.stack = stack;
        this.inv = new ItemStack[slotCount];
        this.readFromNBT();
    }

    private InventoryItem(ItemStack stack, int slotCount, int stackSize) {
        this.stack = stack;
        this.inv = new ItemStack[slotCount];
        this.stackSize = stackSize;
        this.readFromNBT();
    }

    public ItemStack getStack() {
        return this.stack.func_77946_l();
    }

    public void readFromNBT() {
        this.readFromNBT(this.stack.func_77978_p());
    }

    private void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            this.stack.func_77982_d(new NBTTagCompound());
            nbt = this.stack.func_77978_p();
        }
        NBTTagList itemList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound tag = itemList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void writeToNBT() {
        this.writeToNBT(this.stack.func_77978_p());
    }

    private void writeToNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            this.stack.func_77982_d(new NBTTagCompound());
            nbt = this.stack.func_77978_p();
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.inv[slot] != null) {
            if (this.inv[slot].field_77994_a <= count) {
                ItemStack itemstack = this.inv[slot];
                this.inv[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inv[slot].func_77979_a(count);
            if (this.inv[slot].field_77994_a == 0) {
                this.inv[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inv[slot] != null) {
            ItemStack itemstack = this.inv[slot];
            this.inv[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.stackSize;
    }

    public void func_70296_d() {
        this.writeToNBT();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

