/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.creeper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.creeper.EntityMiniCreeper;
import toast.specialMobs.entity.creeper.Entity_SpecialCreeper;

public class EntitySplittingCreeper
extends Entity_SpecialCreeper {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "creeper/splitting.png")};
    private byte babies;

    public EntitySplittingCreeper(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.setExplodesWhenShot(true);
        this.field_70728_aV += 2;
        this.babies = (byte)this.field_70146_Z.nextInt(4);
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 20.0);
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = powered ? (float)this.field_82226_g * 2.0f : (float)this.field_82226_g;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power - 1.0f, false);
        if (!this.field_70170_p.field_72995_K) {
            EntityMiniCreeper baby = null;
            int i = this.babies + (int)power;
            while (i-- > 0) {
                baby = new EntityMiniCreeper(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.func_70624_b(this.func_70638_az());
                baby.func_110161_a(null);
                baby.field_70159_w = (this.field_70146_Z.nextDouble() - 0.5) * (double)power / 3.0;
                baby.field_70179_y = (this.field_70146_Z.nextDouble() - 0.5) * (double)power / 3.0;
                baby.field_70122_E = false;
                if (powered) {
                    baby.func_70096_w().func_75692_b(17, (Object)1);
                }
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            this.field_70170_p.func_72956_a((Entity)baby, "random.pop", 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a("Babies", this.babies);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("Babies")) {
            this.babies = saveTag.func_74771_c("Babies");
        } else if (tag.func_74764_b("Babies")) {
            this.babies = tag.func_74771_c("Babies");
        }
    }
}

