/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import pcl.opensecurity.CommonProxy;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.client.renderer.RenderDisplayPanel;
import pcl.opensecurity.client.renderer.RenderEnergyTurret;
import pcl.opensecurity.client.renderer.RenderEntityEnergyBolt;
import pcl.opensecurity.client.renderer.RenderItemEnergyTurret;
import pcl.opensecurity.client.renderer.RenderKeypad;
import pcl.opensecurity.client.sounds.AlarmResource;
import pcl.opensecurity.containers.CardWriterContainer;
import pcl.opensecurity.containers.MagCardContainer;
import pcl.opensecurity.entity.EntityEnergyBolt;
import pcl.opensecurity.tileentity.TileEntityCardWriter;
import pcl.opensecurity.tileentity.TileEntityDisplayPanel;
import pcl.opensecurity.tileentity.TileEntityEnergyTurret;
import pcl.opensecurity.tileentity.TileEntityKeypadLock;
import pcl.opensecurity.tileentity.TileEntityMagReader;
import pcl.opensecurity.tileentity.TileEntityRFIDReader;

public class ClientProxy
extends CommonProxy {
    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityMagReader) {
            TileEntityMagReader icte = (TileEntityMagReader)te;
            return new MagCardContainer(player.field_71071_by, icte);
        }
        if (te != null && te instanceof TileEntityRFIDReader) {
            TileEntityCardWriter icte = (TileEntityCardWriter)te;
            return new CardWriterContainer(player.field_71071_by, icte);
        }
        return null;
    }

    @Override
    public void registerRenderers() {
        RenderDisplayPanel panelDisplayPanel = new RenderDisplayPanel();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDisplayPanel.class, (TileEntitySpecialRenderer)panelDisplayPanel);
        RenderEnergyTurret turretRenderer = new RenderEnergyTurret();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnergyTurret.class, (TileEntitySpecialRenderer)turretRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ContentRegistry.energyTurretBlock), (IItemRenderer)new RenderItemEnergyTurret(turretRenderer));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnergyBolt.class, (Render)new RenderEntityEnergyBolt());
        RenderKeypad keypadRenderer = new RenderKeypad();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeypadLock.class, (TileEntitySpecialRenderer)keypadRenderer);
        MinecraftForgeClient.registerItemRenderer((Item)new ItemStack(ContentRegistry.keypadLockBlock).func_77973_b(), (IItemRenderer)keypadRenderer);
        OpenSecurity.logger.info("Registered TESRs");
    }

    public void listFilesForFolder(File folder) {
        AlarmResource r = new AlarmResource();
        int i = 1;
        if (folder.listFiles() != null) {
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory()) {
                    this.listFilesForFolder(fileEntry);
                    continue;
                }
                r.addSoundReferenceMapping(i, fileEntry.getName());
                ++i;
                System.out.println(OpenSecurity.alarmSounds + File.separator + fileEntry.getName());
            }
        }
        r.registerAsResourceLocation();
    }

    @Override
    public World getWorld(int dimId) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world.field_73011_w.field_76574_g == dimId) {
            return world;
        }
        return null;
    }

    @Override
    public void registerSounds() {
        this.listFilesForFolder(OpenSecurity.alarmSounds);
    }
}

