/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.elementalMatter.core.recipes;

import com.github.technus.tectech.mechanics.elementalMatter.core.maps.EMConstantStackMap;
import com.github.technus.tectech.mechanics.elementalMatter.core.maps.IEMMapRead;
import com.github.technus.tectech.mechanics.elementalMatter.core.stacks.IEMStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class EMRecipe<T>
implements Comparable<EMRecipe<T>> {
    private final int ID;
    private final EMConstantStackMap inEM;
    private final IEMMapRead<? extends IEMStack> outEM;
    private final ItemStack[] outItems;
    private final FluidStack[] outFluids;
    private T extension;

    public EMRecipe(EMConstantStackMap inEM, int id, IEMMapRead<? extends IEMStack> outEM, ItemStack[] outItems, FluidStack[] outFluids) {
        this.inEM = inEM;
        this.outEM = outEM;
        this.outItems = outItems;
        this.outFluids = outFluids;
        this.ID = id;
    }

    public EMRecipe<T> extend(T data) {
        this.setExtension(data);
        return this;
    }

    @Override
    public int compareTo(EMRecipe<T> o) {
        int compare = this.getInEM().compareTo((IEMMapRead)o.getInEM());
        if (compare != 0) {
            return compare;
        }
        return Integer.compare(this.getID(), o.getID());
    }

    public boolean equals(Object obj) {
        if (obj instanceof EMRecipe) {
            return this.compareTo((EMRecipe)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getInEM().hashCode();
    }

    public int getID() {
        return this.ID;
    }

    public EMConstantStackMap getInEM() {
        return this.inEM;
    }

    public IEMMapRead<? extends IEMStack> getOutEM() {
        return this.outEM;
    }

    public ItemStack[] getOutItems() {
        return this.outItems;
    }

    public FluidStack[] getOutFluids() {
        return this.outFluids;
    }

    public T getExtension() {
        return this.extension;
    }

    public void setExtension(T extension) {
        this.extension = extension;
    }
}

