/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.Map;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.plugins.thaumcraft.EssentiaTank;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.EssentiaFuelProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;

public class EntityLocomotiveSteamMagic
extends EntityLocomotiveSteam
implements ISidedInventory,
IAspectContainer {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private static final int SLOT_TICKET = 6;
    private static final int SLOT_DESTINATION = 7;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 7);
    private static final byte FIRE_ASPECT_DATA_ID = 30;
    private static final byte WATER_ASPECT_DATA_ID = 31;
    private final IInventory invBurn = new InventoryMapper((IInventory)this, 2, 1);
    private final IInventory invStock = new InventoryMapper((IInventory)this, 3, 3);
    private final IInventory invFuel = new InventoryMapper((IInventory)this, 2, 4);
    private final IInventory invTicket = new InventoryMapper((IInventory)this, 6, 2, false);
    private EssentiaTank fireAspect;
    private EssentiaTank waterAspect;

    public EntityLocomotiveSteamMagic(World world) {
        super(world);
    }

    public EntityLocomotiveSteamMagic(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.LOCO_STEAM_MAGIC;
    }

    @Override
    public LocomotiveRenderType getRenderType() {
        return LocomotiveRenderType.STEAM_MAGIC;
    }

    public boolean doesContainerAccept(Aspect tag) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.fireAspect = new EssentiaTank(Aspect.FIRE, 256, this.field_70180_af, 30);
        this.waterAspect = new EssentiaTank(Aspect.WATER, 256, this.field_70180_af, 31);
        this.boiler.setFuelProvider(new EssentiaFuelProvider(this.fireAspect){

            @Override
            public double getMoreFuel() {
                if (EntityLocomotiveSteamMagic.this.isShutdown()) {
                    return 0.0;
                }
                return super.getMoreFuel();
            }
        });
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isHost(this.field_70170_p)) {
            InvTools.moveOneItem(this.invStock, this.invBurn);
            InvTools.moveOneItem(this.invBurn, this.invWaterOutput, FluidContainerRegistry.EMPTY_BUCKET);
        }
    }

    @Override
    protected void openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOCO_STEAM, player, this.field_70170_p, (Entity)this);
    }

    @Override
    public boolean needsRefuel() {
        FluidStack water = this.tankWater.getFluid();
        if (water == null || water.amount < this.tankWater.getCapacity() / 2) {
            return true;
        }
        if (InvTools.countItems(this.invFuel) < 16) {
            return true;
        }
        for (IInvSlot slot : InventoryIterator.getIterable(this.invFuel)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack != null && stack.field_77994_a >= stack.func_77976_d() / 4) continue;
            return true;
        }
        return false;
    }

    public EssentiaTank getFireAspect() {
        return this.fireAspect;
    }

    public EssentiaTank getWaterAspect() {
        return this.waterAspect;
    }

    @Override
    protected IInventory getTicketInventory() {
        return this.invTicket;
    }

    @Override
    public int func_70302_i_() {
        return 8;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot < 6;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 0: {
                return FluidItemHelper.containsFluid(stack, Fluids.WATER.get(1));
            }
            case 6: {
                return ItemTicket.FILTER.matches(stack);
            }
        }
        return false;
    }

    public AspectList getAspects() {
        return new AspectList().add(Aspect.FIRE, this.fireAspect.getAmount()).add(Aspect.WATER, this.waterAspect.getAmount());
    }

    public void setAspects(AspectList aspects) {
    }

    public int addToContainer(Aspect tag, int amount) {
        if (tag == Aspect.FIRE) {
            return this.fireAspect.fill(amount, true);
        }
        if (tag == Aspect.WATER) {
            return this.waterAspect.fill(amount, true);
        }
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (tag == Aspect.FIRE) {
            return this.fireAspect.remove(amount, true);
        }
        if (tag == Aspect.WATER) {
            return this.waterAspect.remove(amount, true);
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        if (tag == Aspect.FIRE) {
            return this.fireAspect.contains(amount);
        }
        if (tag == Aspect.WATER) {
            return this.waterAspect.contains(amount);
        }
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        for (Map.Entry entry : ot.aspects.entrySet()) {
            if (this.doesContainerContainAmount((Aspect)entry.getKey(), (Integer)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int containerContains(Aspect tag) {
        if (tag == Aspect.FIRE) {
            return this.fireAspect.getAmount();
        }
        if (tag == Aspect.WATER) {
            return this.waterAspect.getAmount();
        }
        return 0;
    }
}

