/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import cofh.api.energy.IEnergyProvider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileRFLoaderBase;
import mods.railcraft.common.carts.EntityCartRF;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.rf.RedstoneFluxPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRFUnloader
extends TileRFLoaderBase
implements IEnergyProvider,
IGuiReturnHandler {
    private boolean waitTillEmpty = true;
    private static final int AMOUNT_TO_PUSH_TO_TILES = 2000;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.RF_UNLOADER;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.UNLOADER_RF, player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.field_145850_b)) {
            return;
        }
        RedstoneFluxPlugin.pushToTiles(this, this.tileCache, 2000);
    }

    @Override
    protected boolean processCart() {
        boolean transferred = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return false;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return false;
        }
        if (this.isPaused()) {
            return false;
        }
        EntityCartRF rfCart = (EntityCartRF)cart;
        if (this.amountRF < this.getMaxRF() && rfCart.getRF() > 0) {
            int request = 8000;
            int room = this.getMaxRF() - this.getRF();
            if (room < request) {
                request = room;
            }
            double extracted = rfCart.removeRF(request);
            this.amountRF = (int)((double)this.amountRF + extracted);
            boolean bl = transferred = extracted > 0.0;
        }
        if (!transferred && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
        return transferred;
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof EntityCartRF)) {
            return true;
        }
        EntityCartRF rfCart = (EntityCartRF)cart;
        if (!this.waitTillEmpty) {
            return true;
        }
        return rfCart.getRF() <= 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("WaitTillEmpty", this.waitTillEmpty());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setWaitTillEmpty(nbttagcompound.func_74767_n("WaitTillEmpty"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.waitTillEmpty = data.readBoolean();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.waitTillEmpty = data.readBoolean();
    }

    public boolean waitTillEmpty() {
        return this.waitTillEmpty;
    }

    public void setWaitTillEmpty(boolean wait) {
        this.waitTillEmpty = wait;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.removeRF(maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.getRF();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxRF();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

