/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world.claims;

import ftb.lib.LMSecurity;
import ftb.lib.PrivacyLevel;
import ftb.lib.api.friends.ILMPlayer;
import ftb.utils.mod.FTBU;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerServer;
import net.minecraft.util.EnumChatFormatting;

public class ChunkType {
    public static final ChunkType UNLOADED = new ChunkType(0, "unloaded", EnumChatFormatting.DARK_GRAY, -16777216);
    public static final ChunkType SPAWN = new ChunkType(-1, "spawn", EnumChatFormatting.AQUA, -16715809);
    public static final ChunkType WORLD_BORDER = new ChunkType(-2, "world_border", EnumChatFormatting.RED, -65536);
    public static final ChunkType WILDERNESS = new ChunkType(-3, "wilderness", EnumChatFormatting.DARK_GREEN, -13656576);
    public static final ChunkType LOADED_SELF = new ChunkType(-4, "chunkloaded", EnumChatFormatting.RED, -65536);
    public static final ChunkType[] UNCLAIMED_VALUES = new ChunkType[]{UNLOADED, SPAWN, WORLD_BORDER, WILDERNESS, LOADED_SELF};
    public final int ID;
    public final String lang;
    private final EnumChatFormatting chatColor;
    private final int areaColor;

    public ChunkType(int id, String s, EnumChatFormatting c, int col) {
        this.ID = id;
        this.lang = "chunktype." + s;
        this.chatColor = c;
        this.areaColor = col;
    }

    public boolean isClaimed() {
        return false;
    }

    public boolean isChunkOwner(LMPlayer p) {
        return this == WILDERNESS;
    }

    public boolean drawGrid() {
        return this != WILDERNESS && this != UNLOADED;
    }

    public String getIDS() {
        return FTBU.mod.translate(this.lang, new Object[0]);
    }

    public int hashCode() {
        return this.ID;
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public EnumChatFormatting getChatColor(LMPlayer p) {
        return this.chatColor;
    }

    public int getAreaColor(LMPlayer p) {
        return this.areaColor;
    }

    public boolean canInteract(LMPlayerServer p, boolean leftClick) {
        return this == WILDERNESS || this == SPAWN;
    }

    public static final class PlayerClaimed
    extends ChunkType {
        public LMPlayer chunkOwner = null;

        public PlayerClaimed(LMPlayer o) {
            super(o.getPlayerID(), "claimed", null, 0);
            this.chunkOwner = o;
        }

        public boolean isFriendly(LMPlayer p) {
            return this.chunkOwner.equalsPlayer(p) || this.chunkOwner.isFriend(p);
        }

        @Override
        public boolean isClaimed() {
            return true;
        }

        @Override
        public boolean isChunkOwner(LMPlayer p) {
            return this.chunkOwner.equals(p);
        }

        @Override
        public EnumChatFormatting getChatColor(LMPlayer p) {
            return this.isFriendly(p) ? EnumChatFormatting.GREEN : EnumChatFormatting.BLUE;
        }

        @Override
        public int getAreaColor(LMPlayer p) {
            return this.isFriendly(p) ? -16711903 : -16739073;
        }

        @Override
        public boolean canInteract(LMPlayerServer p, boolean leftClick) {
            if (this.chunkOwner.equals(p)) {
                return true;
            }
            if (p.isFake()) {
                return this.chunkOwner.getSettings().get((byte)2);
            }
            LMSecurity s = new LMSecurity((Object)this.chunkOwner);
            s.level = (PrivacyLevel)p.getRank().config.forced_chunk_security.get();
            if (s.level == null) {
                s.level = this.chunkOwner.getSettings().blocks;
            }
            return s.canInteract((ILMPlayer)p);
        }
    }
}

