/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.api.guide;

import ftb.lib.mod.FTBLibMod;
import ftb.utils.mod.FTBU;
import ftb.utils.world.LMPlayerServer;
import java.util.Comparator;
import latmod.lib.LMStringUtils;
import latmod.lib.LMUtils;
import latmod.lib.MathHelperLM;
import net.minecraft.util.IChatComponent;

public abstract class Top
implements Comparator<LMPlayerServer> {
    public final String ID;
    public final IChatComponent title;
    public static final Top first_joined = new Top("first_joined"){

        @Override
        public int compare(LMPlayerServer o1, LMPlayerServer o2) {
            return Long.compare(o1.stats.firstJoined, o2.stats.firstJoined);
        }

        @Override
        public Object getData(LMPlayerServer p) {
            return LMStringUtils.getTimeString((long)(LMUtils.millis() - p.stats.firstJoined));
        }
    };
    public static final Top deaths = new Top("deaths"){

        @Override
        public int compare(LMPlayerServer o1, LMPlayerServer o2) {
            return Integer.compare(o2.stats.deaths, o1.stats.deaths);
        }

        @Override
        public Object getData(LMPlayerServer p) {
            return Integer.toString(p.stats.deaths);
        }
    };
    public static final Top deaths_ph = new Top("deaths_ph"){

        @Override
        public int compare(LMPlayerServer o1, LMPlayerServer o2) {
            return Double.compare(o2.stats.getDeathsPerHour(), o1.stats.getDeathsPerHour());
        }

        @Override
        public Object getData(LMPlayerServer p) {
            return MathHelperLM.toSmallDouble((double)p.stats.getDeathsPerHour());
        }
    };
    public static final Top last_seen = new Top("last_seen"){

        @Override
        public int compare(LMPlayerServer o1, LMPlayerServer o2) {
            return Long.compare(o2.stats.lastSeen, o1.stats.lastSeen);
        }

        @Override
        public Object getData(LMPlayerServer p) {
            if (p.isOnline()) {
                return FTBLibMod.mod.chatComponent("label.online", new Object[0]);
            }
            return LMStringUtils.getTimeString((long)(LMUtils.millis() - p.stats.lastSeen));
        }
    };
    public static final Top time_played = new Top("time_played"){

        @Override
        public int compare(LMPlayerServer o1, LMPlayerServer o2) {
            return Long.compare(o2.stats.timePlayed, o1.stats.timePlayed);
        }

        @Override
        public Object getData(LMPlayerServer p) {
            return LMStringUtils.getTimeString((long)p.stats.timePlayed) + " [" + p.stats.timePlayed / 3600000L + "h]";
        }
    };

    public Top(String s) {
        this.ID = s;
        this.title = FTBU.mod.chatComponent("top." + s, new Object[0]);
    }

    public abstract Object getData(LMPlayerServer var1);
}

